/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.StatusListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.ImageButton;

public class ToolBar
extends Panel
implements CarteHostListener,
ItemListener,
KeyListener,
ActionListener,
StatusListener {
    private static final String BTN_STATUS = "btn_status";
    private static final String BTN_ZOOMFULL = "btn_zoomfull";
    private static final String BTN_ZOOMLYR = "btn_zoomlayer";
    private static final String BTN_GETDATA = "btn_getdata";
    private static final String BTN_SEARCH = "btn_search";
    private static final String BTN_TIPS = "btn_tips";
    private static final String BTN_HELP = "btn_help";
    private static final String LST_DOMAINS = "lst_domains";
    private static final String LST_THEMES = "lst_themes";
    private static final String TXT_SEARCH = "txt_search";
    private static final String TF_SEARCH = "tf_search";
    private Carte map = null;
    private boolean isExact = false;
    private String helpFile = null;
    private TextField searchField = null;
    private Color SF_ENABLED_COLOR = null;
    private Color SF_DISABLED_COLOR = null;
    private static String STR_DISABLED_COLOR = "txt_search_disabled";
    public String searchLayer = null;

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof Component) {
            String sName = ((Component)o).getName();
            byte tool = Carte.getToolCode(sName);
            if (tool != 0) {
                this.map.setTool(tool);
            } else if (sName.equalsIgnoreCase(BTN_ZOOMFULL)) {
                this.map.zoomToFullExtent();
                this.map.updateMap();
            } else if (sName.equalsIgnoreCase(BTN_ZOOMLYR)) {
                this.map.zoomToLayer(this.map.getActiveLayer());
            } else if (sName.equalsIgnoreCase(BTN_GETDATA)) {
                this.map.showAttribForSelection(null, 30, null);
            } else if (sName.equalsIgnoreCase(BTN_TIPS)) {
                MapUtils.isTipsActive = !MapUtils.isTipsActive;
                ((ImageButton)o).setDown(MapUtils.isTipsActive);
            } else if (sName.equalsIgnoreCase(BTN_SEARCH) && this.searchField != null) {
                this.map.searchAttribute(this.searchLayer, this.searchField.getText(), this.isExact ? 1 : 2);
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 10 && this.searchField != null) {
            this.map.searchAttribute(this.searchLayer, this.searchField.getText(), this.isExact ? 1 : 2);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        Component o = (Component)e.getSource();
        String name = (String)e.getItem();
        String sName = o.getName();
        if (sName.equalsIgnoreCase(LST_DOMAINS)) {
            this.map.zoomToDomain(name);
            this.map.updateMap();
        } else if (sName.equalsIgnoreCase(LST_THEMES)) {
            this.map.setThematicMap(name);
            this.map.updateMap();
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.SF_DISABLED_COLOR = XmlUtils.getColor(STR_DISABLED_COLOR, layout, null);
        this.isExact = XmlUtils.getBoolean("equal", layout, false);
        this.helpFile = XmlUtils.getLangString("helpdoc", layout, "TMJavaResources/help_en.html", MapUtils.language);
        this.searchLayer = XmlUtils.getString("layer", layout, null);
        this.map = host.getMapByName(layout);
        this.map.statusListeners.addElement(this);
    }

    public void stop() {
    }

    public void afterProjectLoaded(boolean bSuccess) {
        if (bSuccess) {
            Component c;
            StringTokenizer tok;
            Project project = this.map.getProject();
            Choice ch = (Choice)MapUtils.findComp(this, LST_DOMAINS);
            if (ch != null) {
                ch.removeAll();
                tok = new StringTokenizer(project.domainsNames, "\n\r");
                while (tok.hasMoreTokens()) {
                    ch.add(tok.nextToken());
                }
                ch.addItemListener(this);
                if (project.startExtentName != null) {
                    ch.select(project.startExtentName);
                }
            }
            if ((ch = (Choice)MapUtils.findComp(this, LST_THEMES)) != null) {
                tok = new StringTokenizer(project.themesNames, "\n\r");
                while (tok.hasMoreTokens()) {
                    ch.add(tok.nextToken());
                }
                ch.addItemListener(this);
                if (project.startTheme != null) {
                    ch.select(project.startTheme);
                }
            }
            this.searchField = (TextField)MapUtils.findComp(this, TXT_SEARCH);
            if (this.searchField == null) {
                this.searchField = (TextField)MapUtils.findComp(this, TF_SEARCH);
            }
            if (this.searchField != null) {
                this.SF_ENABLED_COLOR = this.searchField.getBackground();
                this.searchField.addKeyListener(this);
            }
            MapUtils.addActionListener(this, this);
            if (MapUtils.isTipsActive && (c = MapUtils.findComp(this, BTN_TIPS)) != null) {
                ((ImageButton)c).setDown(true);
            }
        }
    }

    public void notifyStatus(int code, Object obj) {
        Choice ch;
        if (code == 112) {
            Component c;
            String s = Carte.getToolName(this.map.getTool());
            if (s != null && (c = MapUtils.findComp(this, s)) != null) {
                ((ImageButton)c).setDown(true);
            }
        } else if (code == 107 || code == 11 && obj == null) {
            boolean isEnabled;
            Layer lyr = this.map.getActiveLayer();
            if (lyr != null) {
                String link = lyr.linkSearch != null ? lyr.linkSearch : this.map.getProject().linkSearch;
                isEnabled = lyr.canSearch && (lyr.fi_description >= 0 || lyr.isGeocoding || link != null);
            } else {
                isEnabled = false;
            }
            if (this.searchField != null) {
                this.searchField.setEnabled(isEnabled);
                Color clr = isEnabled ? this.SF_ENABLED_COLOR : this.SF_DISABLED_COLOR;
                this.searchField.setBackground(clr);
            }
            Component c = null;
            c = MapUtils.findComp(this, BTN_SEARCH);
            if (c != null) {
                c.setEnabled(isEnabled);
            }
        } else if (code == 106 && obj != null && (ch = (Choice)MapUtils.findComp(this, LST_THEMES)) != null) {
            String name = (String)obj;
            ch.select(name);
        }
    }
}

