/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import org.alov.map.Carte;
import org.alov.map.MapUtils;

class TipRect
extends Canvas {
    private Carte map;
    private Container containerOnWhichTheTooltipShows;
    private String caption;
    private int x;
    private int y;
    private int width;
    private int height;
    private Font tooltipFont;
    private boolean fill;
    private boolean outline;
    private Color fillColor;
    private Color outlineColor;
    private boolean bWrap = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TipRect(String caption, Font tooltipFont, Carte map, Point ppt, boolean fill, boolean outline, Color fillColor, Color outlineColor, int maxWidth) {
        this.map = map;
        this.containerOnWhichTheTooltipShows = map.getParent();
        this.containerOnWhichTheTooltipShows.add(this);
        this.caption = caption;
        this.tooltipFont = tooltipFont;
        FontMetrics fontSize = null;
        Graphics g = map.getGraphics();
        try {
            if (tooltipFont != null) {
                g.setFont(tooltipFont);
            }
            fontSize = g.getFontMetrics();
            this.width = fontSize.stringWidth(caption) + 3;
            if (maxWidth > 0 && this.width > maxWidth) {
                this.bWrap = true;
                Dimension d = MapUtils.getTextDimension(caption, g, maxWidth, true);
                this.height = d.height + 4;
                this.width = d.width + 10;
            } else {
                this.height = fontSize.getHeight() + 2;
            }
        }
        finally {
            g.dispose();
        }
        ppt.y -= this.height;
        if (ppt.x < 0) {
            ppt.x = 0;
        }
        if (ppt.y < 0) {
            ppt.y = 0;
        }
        if (ppt.x + this.width > this.containerOnWhichTheTooltipShows.getSize().width) {
            ppt.x = this.containerOnWhichTheTooltipShows.getSize().width - this.width;
        }
        if (ppt.y + this.height > this.containerOnWhichTheTooltipShows.getSize().height) {
            ppt.y = this.containerOnWhichTheTooltipShows.getSize().height - this.height;
        }
        this.x = ppt.x;
        this.y = ppt.y;
        this.fill = fill;
        this.outline = outline;
        this.fillColor = fillColor;
        this.outlineColor = outlineColor;
    }

    void dispose() {
        this.containerOnWhichTheTooltipShows.remove(this);
        this.map.updateMap();
    }

    public void paint(Graphics g) {
        if (this.fill) {
            g.setColor(this.fillColor);
            g.fillRect(this.x, this.y, this.width, this.height);
        }
        g.setColor(this.outlineColor);
        if (this.outline) {
            g.drawRect(this.x, this.y, this.width, this.height);
        }
        if (this.tooltipFont != null) {
            g.setFont(this.tooltipFont);
        }
        if (this.bWrap) {
            MapUtils.drawString(g, this.caption, this.x + 2, this.y, this.width, this.height, true);
        } else {
            g.drawString(this.caption, this.x + 2, this.y + this.height - 4);
        }
    }
}

