/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.StatusListener;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.TimerListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

class StatusPanel
extends Canvas
implements CarteHostListener,
CarteListener,
StatusListener,
TimerListener {
    private static final int NS_TOOLTIP = 1;
    private static final int NS_SYSTEM = 2;
    private static final int NS_FAILURE = 3;
    private static final int NS_MAP = 4;
    private static final int NS_OTHER = 5;
    private String lblXY = "";
    private String lblZoom = "";
    private String lblStatus = null;
    private String oldStatus = null;
    private Color colorStatus;
    private Color oldColor;
    int loadPercent = 0;
    boolean showZoom = true;
    private String showParams = null;
    private int mapUnits;
    private int MapUnitsFormat = 100;
    private Color progressColor = Color.blue;
    private Color colorOther = null;
    private Color colorMap = null;
    private Color colorFailure = null;
    private Color colorNetwork = null;
    private Color colorTips = null;
    private String zoom_label;
    private Carte map;
    private SimpleTimer st;
    private Point ptForSearch = null;
    private int reset = 0;
    private static final String _ZOOM = "Zoom";
    private final String MSG_TIME = "Time ranges: ";
    private final String MSG_TILDA = " ~ ";

    StatusPanel() {
    }

    void setXY(String text) {
        this.lblXY = text;
        this.repaint();
    }

    void setZoom(String text) {
        this.lblZoom = text;
        this.repaint();
    }

    void setStatus(String text, int type) {
        switch (type) {
            case 1: {
                this.colorStatus = this.colorTips;
                break;
            }
            case 2: {
                this.colorStatus = this.colorNetwork;
                break;
            }
            case 3: {
                this.colorStatus = this.colorFailure;
                break;
            }
            case 4: {
                this.colorStatus = this.colorMap;
                break;
            }
            default: {
                this.colorStatus = this.colorOther;
            }
        }
        this.lblStatus = text;
        this.repaint();
    }

    void saveStatus() {
        if (this.colorStatus != this.colorNetwork) {
            this.oldColor = this.colorStatus;
            this.oldStatus = this.lblStatus;
        }
    }

    void restoreStatus() {
        if (this.oldStatus != null) {
            this.colorStatus = this.oldColor;
            this.lblStatus = this.oldStatus;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (d == null) {
            return;
        }
        int w2 = d.width;
        if (this.showZoom) {
            int wCoords = this.showParams.charAt(0) == '1' ? g.getFontMetrics().stringWidth(this.lblXY) : 0;
            int wZoom = this.showParams.charAt(1) == '1' ? g.getFontMetrics().stringWidth(this.lblZoom) : 0;
            w2 -= Math.max(wCoords, wZoom);
        }
        if (this.showParams.charAt(2) == '1') {
            if (this.loadPercent > 0) {
                g.setColor(this.progressColor);
                g.fillRect(0, 1, w2 / 100 * this.loadPercent, 8);
            } else {
                g.setColor(this.getForeground());
                g.clearRect(0, 0, w2, d.height);
            }
        }
        if (this.showParams.charAt(3) == '1' && this.lblStatus != null) {
            g.setColor(this.colorStatus);
            FontMetrics fm = g.getFontMetrics();
            StringTokenizer tok = new StringTokenizer(this.lblStatus, " ");
            String line = "";
            int line_len = 0;
            int line_height = fm.getHeight();
            int cur_y = 8 + line_height;
            w2 -= 10;
            while (tok.hasMoreTokens()) {
                String wrd = tok.nextToken() + " ";
                int word_len = fm.stringWidth(wrd) + 3;
                if (line_len + word_len > w2) {
                    g.drawString(line, 2, cur_y);
                    cur_y += line_height;
                    line_len = 0;
                    line = new String(wrd);
                    continue;
                }
                line_len += word_len;
                line = line + wrd;
            }
            if (!Strings.isNullOrBlank(line)) {
                g.drawString(line, 2, cur_y);
            }
        }
        if (this.showZoom) {
            g.setColor(this.getForeground());
            g.clearRect(w2, 0, d.width, d.height);
            if (this.lblXY != null && this.showParams.charAt(0) == '1') {
                g.drawString(this.lblXY, d.width - g.getFontMetrics().stringWidth(this.lblXY) - 2, g.getFontMetrics().getHeight());
            }
            if (this.lblZoom != null && this.showParams.charAt(1) == '1') {
                g.drawString(this.lblZoom, d.width - g.getFontMetrics().stringWidth(this.lblZoom) - 2, g.getFontMetrics().getHeight() * 2);
            }
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        int kk;
        this.colorOther = XmlUtils.getColor("forecolor", layout, Color.darkGray);
        this.colorMap = XmlUtils.getColor("select_clr", layout, Color.blue);
        this.colorFailure = XmlUtils.getColor("err_color", layout, Color.red);
        this.colorNetwork = XmlUtils.getColor("net_color", layout, Color.darkGray);
        this.colorTips = XmlUtils.getColor("tip_color", layout, Color.magenta);
        this.progressColor = XmlUtils.getColor("progress_color", layout, Color.blue);
        this.showParams = XmlUtils.getString("paint", layout, "");
        while (this.showParams.length() < 4) {
            this.showParams = this.showParams + "1";
        }
        this.showZoom = XmlUtils.getBoolean("usezoom", layout, true);
        String units = XmlUtils.getString("mapunits", layout, null);
        if (units != null && (kk = units.indexOf(44)) >= 0) {
            try {
                int rnd = Integer.parseInt(units.substring(kk + 1));
                int n = this.MapUnitsFormat = Math.abs(rnd) > 5 ? rnd : (int)Math.pow(10.0, Math.abs(rnd));
                if (rnd < 0) {
                    this.MapUnitsFormat = -this.MapUnitsFormat;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            units = kk > 0 ? units.substring(0, kk - 1) : null;
        }
        this.mapUnits = MapUtils.setUnits(units, -1);
        this.map = host.getMapByName(layout);
        this.map.mapListeners.addElement(this);
        this.map.statusListeners.addElement(this);
        this.st = new SimpleTimer(500L, this);
    }

    public void stop() {
    }

    public void afterProjectLoaded(boolean bSuccess) {
        this.zoom_label = this.map.getResource(_ZOOM);
        if (this.mapUnits < 0 && bSuccess) {
            this.mapUnits = this.map.getProject().MapUnits;
            if (this.mapUnits < 0) {
                this.mapUnits = 0;
            }
        }
    }

    public void notifyStatus(int code, Object obj) {
        int type;
        if (code == 109) {
            String s = this.map.getResource("in");
            switch (this.map.getProject().ZoomUnits) {
                case 1: {
                    s = this.map.getResource("m");
                    break;
                }
                case 2: {
                    s = this.map.getResource("km");
                    break;
                }
                case 4: {
                    s = this.map.getResource("ft");
                    break;
                }
                case 5: {
                    s = this.map.getResource("mi");
                    break;
                }
                case 6: {
                    s = this.map.getResource("nmi");
                }
            }
            this.setZoom(this.zoom_label + "  " + (long)(((Float)obj).floatValue() * 1000.0f) / 1000L + ' ' + s);
            return;
        }
        if (code == 108) {
            TimeInterval tin = (TimeInterval)obj;
            String s = this.map.getResource("Time ranges: ") + tin.date1().toString() + " ~ " + tin.date2().toString();
            this.setStatus(s, 4);
            return;
        }
        if (code == 13 || code == 11 && obj == null) {
            this.restoreStatus();
            return;
        }
        if (code == 10 && obj == null) {
            this.saveStatus();
            return;
        }
        if (code == 114 || code == 115) {
            this.oldStatus = null;
        }
        if (obj == null || !(obj instanceof String)) {
            return;
        }
        String mess = (String)obj;
        if (code == 12) {
            type = 1;
            this.saveStatus();
        } else {
            int n = code < 0 ? 3 : (type = code < 100 ? 2 : 4);
            if (code == 11) {
                this.loadPercent = 0;
            } else if (code == 4) {
                int n2 = mess.indexOf(37);
                this.loadPercent = n2 > 0 ? Integer.parseInt(mess.substring(0, n2)) : 0;
            }
            String s2 = this.map.getResource_((type == 4 ? "m" : "sp") + Math.abs(code));
            mess = (s2 + "  " + mess).trim();
        }
        this.setStatus(mess, type);
    }

    public void mouseMapPressed(MouseEvent e) {
    }

    public void mouseMapReleased(FloatRectangle selRect, MouseEvent e) {
    }

    public void mouseMapMoved(MouseEvent e) {
        Point ppt = e.getPoint();
        FloatPoint pt = this.map.screenToMap(ppt);
        if (pt != null) {
            if (this.mapUnits == 0 && this.MapUnitsFormat < 100 && this.MapUnitsFormat > 97) {
                this.setXY(MapUtils.formatDegree(pt.x, true, this.MapUnitsFormat == 98) + " " + MapUtils.formatDegree(pt.y, false, this.MapUnitsFormat == 98));
            } else {
                this.setXY(Strings.doubleToStr(pt.x, this.MapUnitsFormat) + ", " + Strings.doubleToStr(pt.y, this.MapUnitsFormat));
            }
            this.ptForSearch = ppt;
            if (this.reset != 1) {
                this.reset = 0;
            }
        } else {
            this.setStatus("", 5);
        }
    }

    public void afterMapDraw(Graphics g) {
    }

    public void timerTick() {
        if (this.reset == 1 && this.ptForSearch != null) {
            String s;
            Record rec;
            Layer activeLayer = this.map.getActiveLayer();
            if (MapUtils.isTipsActive && activeLayer != null && activeLayer.isVisibleNow(this.map) && (rec = activeLayer.findAtScreenPoint(this.ptForSearch)) != null && (s = activeLayer.getFieldString(rec, activeLayer.fi_description)).length() > 0) {
                this.setStatus(s + " [" + activeLayer.getName() + ']', 4);
            }
            this.ptForSearch = null;
            this.reset = 0;
        } else {
            ++this.reset;
        }
    }
}

