/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import org.alov.map.DisplayContext;
import org.alov.map.Layer;
import org.alov.map.LayerGroup;
import org.alov.map.MapUtils;
import org.alov.map.Renderer;
import org.alov.map.RendererChart;
import org.alov.map.RendererDef;
import org.alov.map.RendererDot;
import org.alov.map.RendererGrad;
import org.alov.map.RendererLabel;
import org.alov.map.Symbol;
import org.alov.tm.MultiAnimation;
import org.alov.viewer.LayerCtl;
import org.alov.viewer.LayerCtlImpl;
import org.alov.viewer.LayerItemButton;

class LayerControlItem {
    int cwidth = 120;
    private static final int buttonSize = 10;
    private static final int checkX = 2;
    private static final int expandX = 14;
    private static final int captionX = 24;
    private boolean drawSeparator = false;
    private boolean drawSelection = true;
    private boolean compactSingleRend = false;
    private boolean isCompact = false;
    private Color foreColor = Color.black;
    Color backColor = Color.white;
    private Color networkColor;
    private Color selectionColor = this.networkColor = new Color(208, 208, 238);
    private Color disabledColor = Color.gray;
    private Color failureColor = Color.gray;
    private Font fontBold;
    private Font fontPlain;
    private Image imageClock = null;
    private Image imageZoomIn = null;
    private Image imageZoomOut = null;
    private Image imageNetwork = null;
    private Image imageOutExt = null;
    private Image imageKey = null;
    private Image imageChecked = null;
    private Image imageUncheck = null;
    private int headHeight;
    private int itemSampleHeight;
    private Rectangle bounds = new Rectangle();
    Object animation = null;
    private Layer layer;
    LayerCtlImpl layerCtl;
    private Vector visibleRenderers = new Vector();
    private Vector notPaintedRenderers = new Vector();
    private Vector buttons = new Vector();

    LayerControlItem(Layer lyr, LayerCtlImpl layerCtl) {
        this.layerCtl = layerCtl;
        this.layer = lyr;
        if (layerCtl != null) {
            this.foreColor = layerCtl.getForeground();
            this.backColor = layerCtl.getBackground();
            this.networkColor = layerCtl.networkColor;
            this.selectionColor = layerCtl.selectionColor;
            this.disabledColor = layerCtl.disabledColor;
            this.failureColor = layerCtl.failureColor;
            this.drawSeparator = layerCtl.drawSeparator;
            this.drawSelection = layerCtl.drawSelection;
            this.compactSingleRend = layerCtl.compactSingleRend;
            this.fontBold = layerCtl.fontBold;
            this.fontPlain = layerCtl.fontPlain;
            this.imageClock = layerCtl.imageClock;
            this.imageZoomIn = layerCtl.imageZoomIn;
            this.imageZoomOut = layerCtl.imageZoomOut;
            this.imageNetwork = layerCtl.imageNetwork;
            this.imageOutExt = layerCtl.imageOutExt;
            this.imageKey = layerCtl.imageKey;
            this.imageChecked = layerCtl.imageChecked;
            this.imageUncheck = layerCtl.imageUncheck;
        } else {
            this.fontBold = MapUtils.defaultBoldFont;
            this.fontPlain = MapUtils.defaultPlainFont;
        }
    }

    private int calcControlWidth() {
        return this.layerCtl != null ? this.layerCtl.getWidth() : this.cwidth;
    }

    protected void updateBounds(DisplayContext dc) {
        Layer lyr = this.layer;
        this.visibleRenderers.removeAllElements();
        Graphics g = dc.getDrawToGraphics();
        if (g == null) {
            return;
        }
        int controlWidth = this.calcControlWidth();
        int h = 0;
        int fullHeight = 0;
        this.itemSampleHeight = 0;
        g.setFont(this.fontBold);
        this.headHeight = MapUtils.textHeight(this.layer.getName(), g, controlWidth - 24 - 4, this.layer.legendWrapText) + 4;
        g.setFont(MapUtils.defaultBoldFont);
        if (this.layer.isInvisibleInLegend(dc)) {
            fullHeight = 0;
        } else if (this.layer.notPrepared || this.layer.isEmpty() || this.layer.metadata.loadFailed || !this.layer.isPassResolved() || this.layer.isOutOfRange(dc) != 0 || this.layer.isOutOfExtent(dc)) {
            fullHeight = this.headHeight;
        } else {
            Vector rends = this.layer.renderers;
            int count = rends.size();
            for (int i = 0; i < count; ++i) {
                Renderer rend = (Renderer)rends.elementAt(i);
                if (!rend.isRendererVisible(dc) || !rend.legendVisible) continue;
                rend.sampleHeight = this.getRendererHeight(rend, g, controlWidth - 14);
                if (!rend.enabled && rend.allowToggle && rend.legendVisible && rend.sampleHeight == 0 && this.notPaintedRenderers.indexOf(rend) == -1) {
                    this.notPaintedRenderers.addElement(rend);
                }
                if (rend.sampleHeight <= 0 && (!rend.allowToggle || !rend.legendVisible)) continue;
                h += rend.sampleHeight + 3;
                if (rend.label != null) {
                    rend.rendLabelHeight = MapUtils.textHeight(rend.label, g, controlWidth - 14, this.layer.legendWrapText);
                    h += rend.rendLabelHeight;
                }
                this.visibleRenderers.addElement(rend);
            }
            this.itemSampleHeight = h;
            boolean bl = this.isCompact = this.compactSingleRend && this.itemSampleHeight > 0 && this.itemSampleHeight < this.headHeight * 2;
            if (this.isCompact) {
                this.headHeight = MapUtils.textHeight(this.layer.getName(), g, controlWidth - 24 - this.itemSampleHeight - 2, this.layer.legendWrapText) + 4;
                fullHeight = Math.max(this.headHeight, this.itemSampleHeight);
            } else {
                fullHeight = lyr.legendExpanded ? this.headHeight + this.itemSampleHeight : this.headHeight;
            }
        }
        this.bounds = new Rectangle(0, 0, controlWidth, fullHeight);
    }

    protected boolean isNotPaintedRenderer(Renderer rend) {
        int i = this.notPaintedRenderers.indexOf(rend);
        if (i != -1) {
            this.notPaintedRenderers.removeElementAt(i);
            return true;
        }
        return false;
    }

    int getRendererHeight(Renderer rend, Graphics g, int controlWidth) {
        int count;
        int height = 0;
        if (rend instanceof RendererChart) {
            int fontHeight = MapUtils.getCurrentFontHeight(g);
            height = fontHeight > 20 ? fontHeight : 20;
            height = ((RendererChart)rend).fields == null ? 0 : height * ((RendererChart)rend).fields.length;
        } else if (rend instanceof RendererLabel) {
            int count2 = rend.getSymbolCount();
            if (count2 > 0) {
                for (int i = 0; i < count2; ++i) {
                    Symbol sym = rend.getSymbol(i);
                    if (!sym.legendVisible || sym.sampleFont == null) continue;
                    g.setFont(sym.sampleFont);
                    int h = MapUtils.getCurrentFontHeight(g);
                    sym.sampleSize.setSize(h, h);
                    height += h;
                }
                g.setFont(MapUtils.defaultBoldFont);
            }
        } else if ((rend instanceof RendererGrad || rend instanceof RendererDef || rend instanceof RendererDot) && (count = rend.getSymbolCount()) > 0) {
            Layer layer = rend.getLayer();
            for (int i = 0; i < count; ++i) {
                Symbol sym = rend.getSymbol(i);
                int objectType = 1;
                if (!sym.drawMarker) {
                    objectType = layer.isObjectType(-1) ? layer.legendObjectType : layer.dataStorage.getObjectType();
                }
                this.calcSymbolSize(sym, g, controlWidth, objectType, layer.legendWrapText);
                height += Math.max(sym.sampleSize.height, sym.sampleSize.width);
            }
        }
        return height;
    }

    private void calcSymbolSize(Symbol sym, Graphics g, int width, int objectType, boolean wrapLabel) {
        if (sym.legendVisible) {
            int symHeight = 0;
            if (objectType == 1) {
                symHeight = (sym.image == null ? sym.size : sym.image.getHeight(MapUtils.getGlobalImageObserver())) + 2;
            }
            if (symHeight < 20) {
                symHeight = 20;
            }
            int labelHeight = MapUtils.textHeight(sym.label, g, width - symHeight - 4, wrapLabel);
            sym.sampleSize.setSize(symHeight, labelHeight);
        } else {
            sym.sampleSize.setSize(0, 0);
        }
    }

    public void setLocation(int x, int y) {
        this.bounds.x = x;
        this.bounds.y = y;
    }

    public void setSize(int w, int h) {
        this.bounds.width = w;
        this.bounds.height = h;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Layer getLayer() {
        return this.layer;
    }

    private void drawCheckbox(Graphics drawTo, int x, int y, int w, int h, boolean checked) {
        if (this.imageChecked == null || this.imageUncheck == null) {
            drawTo.drawRect(x, y, w, h);
            if (checked) {
                drawTo.fillRect(x + 2, y + 2, w - 3, h - 3);
            }
        } else {
            drawTo.drawImage(checked ? this.imageChecked : this.imageUncheck, x, y, MapUtils.getGlobalImageObserver());
        }
    }

    void paint(boolean selected, boolean hasControls, DisplayContext dc) {
        Graphics drawTo = dc.getDrawToGraphics();
        try {
            boolean itemDisabled;
            this.buttons.removeAllElements();
            int x0 = this.bounds.x;
            int y0 = this.bounds.y;
            int y = 0;
            int w = this.bounds.width;
            int h = this.bounds.height;
            int xOrg = this.bounds.x;
            int yOrg = this.bounds.y;
            int controlWidth = w;
            boolean textHeight = false;
            if (h <= 0 || w <= 0) {
                return;
            }
            int yOff = yOrg + (this.headHeight - 10) / 2;
            int xOff = xOrg + 6;
            int xOff_img = xOrg + 2;
            if (this.layer.metadata.networkActivity) {
                drawTo.setColor(this.networkColor);
            } else if (selected && this.drawSelection) {
                drawTo.setColor(this.selectionColor);
            } else if (this.layer.legendColor != null) {
                drawTo.setColor(this.layer.legendColor);
            } else {
                drawTo.setColor(this.backColor);
            }
            drawTo.fillRect(xOrg, yOrg, w, h);
            if (this.drawSeparator) {
                drawTo.setColor(this.disabledColor);
                drawTo.drawLine(xOrg, yOrg + h - 1, w, yOrg + h - 1);
            }
            int zoomStatus = this.layer.isOutOfRange(dc);
            boolean bl = itemDisabled = this.layer.metadata.loadFailed || !this.layer.isPassResolved() || zoomStatus != 0 || this.layer.notPrepared;
            if (this.layer.metadata.loadFailed) {
                drawTo.setColor(this.failureColor);
                drawTo.setFont(this.fontBold);
                drawTo.drawString("!", xOff + 4, yOrg + this.headHeight - 4);
            } else {
                drawTo.setColor(this.foreColor);
                if (this.layer.metadata.networkActivity && this.imageNetwork != null) {
                    hasControls = false;
                    drawTo.drawImage(this.imageNetwork, xOff_img, yOff, MapUtils.getGlobalImageObserver());
                    if (this.animation != null) {
                        this.animation = MultiAnimation.animate(this.imageNetwork, this.layerCtl, xOff_img, yOff);
                    }
                }
                if (!this.layer.isPassResolved()) {
                    if (this.imageKey != null) {
                        drawTo.drawImage(this.imageKey, xOff_img, yOff, MapUtils.getGlobalImageObserver());
                    } else {
                        drawTo.drawOval(xOff, yOff, 4, 4);
                        drawTo.drawLine(xOff + 4, yOff + 2, xOff + 10, yOff + 2);
                        drawTo.drawLine(xOff + 10, yOff + 2, xOff + 10, yOff + 4);
                    }
                } else if (zoomStatus != 0) {
                    if (Math.abs(zoomStatus) == 2) {
                        if (this.imageClock == null) {
                            drawTo.drawOval(xOff, yOff, 10, 10);
                            drawTo.drawLine(xOff + 5, yOff, xOff + 5, yOff + 5);
                            drawTo.drawLine(xOff + 3, yOff + 3, xOff + 5, yOff + 5);
                        } else {
                            drawTo.drawImage(this.imageClock, xOff_img, yOff, MapUtils.getGlobalImageObserver());
                        }
                    } else if (this.imageZoomIn != null && zoomStatus > 0) {
                        drawTo.drawImage(this.imageZoomIn, xOff_img, yOff, MapUtils.getGlobalImageObserver());
                    } else if (this.imageZoomOut != null && zoomStatus < 0) {
                        drawTo.drawImage(this.imageZoomOut, xOff_img, yOff, MapUtils.getGlobalImageObserver());
                    } else {
                        drawTo.drawOval(xOff, yOff, 8, 8);
                        drawTo.drawLine(xOff + 2, yOff + 4, xOff + 6, yOff + 4);
                        if (zoomStatus > 0) {
                            drawTo.drawLine(xOff + 4, yOff + 2, xOff + 4, yOff + 6);
                        }
                        drawTo.drawLine(xOff + 7, yOff + 7, xOff + 9, yOff + 9);
                    }
                } else if (this.layer.isOutOfExtent(dc)) {
                    if (this.imageOutExt != null) {
                        drawTo.drawImage(this.imageOutExt, xOff_img, yOff, MapUtils.getGlobalImageObserver());
                    } else {
                        drawTo.drawRect(xOff, yOff, 6, 6);
                        drawTo.drawRect(xOff + 3, yOff + 3, 6, 6);
                    }
                } else {
                    boolean isPaintExpandButton;
                    drawTo.setColor(this.foreColor);
                    if (hasControls) {
                        if (this.layer.visible_always) {
                            drawTo.setColor(this.disabledColor);
                        }
                        this.drawCheckbox(drawTo, xOrg + 2, yOff, 9, 9, this.layer.isVisible());
                        if (!this.layer.visible_always) {
                            this.buttons.addElement(new LayerItemButton(new Rectangle(xOrg + 2, yOff - yOrg, 9, 9), this.layer));
                        }
                        if (this.layer.visible_always) {
                            drawTo.setColor(this.foreColor);
                        }
                    }
                    Vector rends = this.visibleRenderers;
                    int rendCount = rends.size();
                    xOff += 10;
                    boolean bl2 = isPaintExpandButton = (rendCount > 0 || this.layer instanceof LayerGroup) && hasControls && !this.isCompact;
                    if (this.layer.legendExpanded) {
                        if (isPaintExpandButton) {
                            int cz = 10;
                            int[] xc = new int[]{xOff, xOff + cz / 2, xOff + cz};
                            int[] yc = new int[]{yOff + cz / 3, yOff + cz / 3 + cz / 2, yOff + cz / 3};
                            drawTo.fillPolygon(xc, yc, 3);
                        }
                        if (!itemDisabled) {
                            y += this.headHeight;
                            drawTo.setFont(this.fontPlain);
                            Rectangle sampleRect = new Rectangle();
                            for (int i = 0; i < rendCount; ++i) {
                                Renderer rend = (Renderer)rends.elementAt(i);
                                drawTo.setColor(this.foreColor);
                                if (hasControls && rend.allowToggle && !this.layer.visible_always) {
                                    this.drawCheckbox(drawTo, xOrg + 2 + 2, yOrg + y + 2, 7, 7, rend.enabled);
                                    this.buttons.addElement(new LayerItemButton(new Rectangle(xOrg + 2, y + 2, 9, 9), rend));
                                }
                                if (rend.rendLabelHeight > 0) {
                                    MapUtils.drawString(drawTo, rend.label, xOrg + 14, yOrg + y, controlWidth - xOrg - 14, rend.rendLabelHeight, this.layer.legendWrapText);
                                    y += rend.rendLabelHeight;
                                }
                                int sampleH = rend.sampleHeight;
                                if (this.isCompact) {
                                    sampleRect.setBounds(controlWidth - sampleH - 2, yOrg + (this.bounds.height - sampleH) / 2, controlWidth - 2, sampleH);
                                } else {
                                    sampleRect.setBounds(xOrg + 14, yOrg + y, w - 14, sampleH);
                                }
                                LayerCtl.paintSample(drawTo, sampleRect, rend);
                                y += sampleH;
                                if (i >= rendCount - 1 || sampleH <= 0) continue;
                                drawTo.setColor(this.disabledColor);
                                drawTo.drawLine(xOrg + 5, yOrg + y + 1, xOrg + w - 6, yOrg + y + 1);
                                y += 3;
                            }
                        }
                    } else if (isPaintExpandButton) {
                        drawTo.drawRect(xOrg + 2, yOff, 9, 9);
                        int[] xc = new int[]{xOff, xOff + 5, xOff};
                        int[] yc = new int[]{yOff, yOff + 5, yOff + 10};
                        drawTo.fillPolygon(xc, yc, 3);
                    }
                }
            }
            if (itemDisabled) {
                if (this.layer.metadata.loadFailed) {
                    drawTo.setColor(this.failureColor);
                } else {
                    drawTo.setColor(this.disabledColor);
                }
            } else {
                drawTo.setColor(this.foreColor);
            }
            drawTo.setFont(this.fontBold);
            int rightBound = this.isCompact ? controlWidth - xOrg - 24 - this.itemSampleHeight - 2 : controlWidth - xOrg - 24 - 4;
            MapUtils.drawString(drawTo, this.layer.getName(), xOrg + 24 + 4, yOrg - 2, controlWidth - xOrg - 24 - 4, this.headHeight, this.layer.legendWrapText);
            if (selected && this.drawSelection) {
                drawTo.setColor(this.foreColor);
                drawTo.drawRect(xOrg, yOrg, w - 1, h - 1);
                if (!this.compactSingleRend) {
                    int[] xc = new int[]{w - 5, w - 1, w - 5};
                    int[] yc = new int[]{yOrg + (h - this.headHeight) / 2, yOrg + h / 2, yOrg + (h + this.headHeight) / 2};
                    drawTo.fillPolygon(xc, yc, 3);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean isExpandButton(Point p) {
        return !this.isCompact && p.x > 14 && p.x < 24 && p.y < this.headHeight;
    }

    public Object getCheckboxObject(Point pt) {
        int count = this.buttons.size();
        Object obj = null;
        for (int i = 0; i < count; ++i) {
            LayerItemButton btn = (LayerItemButton)this.buttons.elementAt(i);
            if (!btn.rect.contains(pt)) continue;
            obj = btn.object;
            break;
        }
        return obj;
    }

    void expandClicked() {
        this.layer.setExpanded(!this.layer.legendExpanded);
        this.bounds.height = this.isCompact ? Math.max(this.headHeight, this.itemSampleHeight) : (this.layer.legendExpanded ? this.headHeight + this.itemSampleHeight : this.headHeight);
    }
}

