/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.MapUtils;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class ImageButton
extends Component
implements CarteHostListener {
    private static final String IMAGE_DISABLED = "image_disabled";
    private static final String IMAGE_HOT = "image_hot";
    private static final String IMAGE_PRESSED = "image_down";
    private static final String _FLAT = "flat";
    private static final String _DOWN = "down";
    Image image = null;
    Image imageDisabled = null;
    Image imageHot = null;
    Image imagePressed = null;
    boolean isFlat = false;
    private String linkmask = null;
    private String targetPage = null;
    String hint;
    boolean isDown = false;
    CarteHost host;
    public int group = -1;
    public boolean drawBorder = true;
    private ActionListener actListener = null;
    private boolean isHot = false;
    private boolean tempDown = false;
    private static int _num = 0;

    public ImageButton() {
        this(null);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public ImageButton(Image image) {
        this.image = image;
        this.hint = "";
        this.isDown = false;
        this.enableEvents(16L);
        this.setName("imagebutton" + _num);
        ++_num;
    }

    public void setImage(Image img) {
        this.image = img;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getHint() {
        return this.hint;
    }

    public void setDown(boolean b) {
        this.isHot = false;
        Container cont = this.getParent();
        if (cont != null && this.group >= 0 && b) {
            int cnt = cont.getComponentCount();
            for (int i = 0; i < cnt; ++i) {
                Component c2 = cont.getComponent(i);
                if (!(c2 instanceof ImageButton) || this.equals(c2) || ((ImageButton)c2).group != this.group) continue;
                ((ImageButton)c2).isDown = false;
            }
        }
        this.isDown = b;
        if (cont != null) {
            cont.repaint();
        }
    }

    public static void setAllUp(Container cont, int group) {
        if (group >= 0) {
            int cnt = cont.getComponentCount();
            for (int i = 0; i < cnt; ++i) {
                Component c2 = cont.getComponent(i);
                if (!(c2 instanceof ImageButton) || ((ImageButton)c2).group != group) continue;
                ((ImageButton)c2).isDown = false;
            }
            cont.repaint();
        }
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        Image currentImage = null;
        currentImage = this.isEnabled() ? (this.isDown || this.tempDown ? this.imagePressed : (this.isHot ? this.imageHot : this.image)) : this.imageDisabled;
        if (currentImage == null) {
            currentImage = this.image;
        }
        if (null != currentImage) {
            int iX = (d.width - currentImage.getWidth(this)) / 2;
            int iY = (d.height - currentImage.getHeight(this)) / 2;
            g.drawImage(currentImage, iX, iY, this);
        }
        if (this.drawBorder) {
            if (this.isDown || this.tempDown) {
                g.setColor(SystemColor.controlDkShadow);
                g.drawLine(d.width, 0, 0, 0);
                g.drawLine(0, 0, 0, d.height);
                if (!this.isFlat) {
                    g.setColor(SystemColor.controlShadow);
                    g.drawLine(d.width, 1, 1, 1);
                    g.drawLine(1, 1, 1, d.height);
                    g.setColor(SystemColor.controlHighlight);
                    g.drawLine(d.width - 2, 1, d.width - 2, d.height);
                    g.drawLine(d.width, d.height - 2, 1, d.height - 2);
                }
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(d.width - 1, 0, d.width - 1, d.height);
                g.drawLine(d.width, d.height - 1, 0, d.height - 1);
            } else if (!this.isFlat || this.isHot) {
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(d.width, 0, 0, 0);
                g.drawLine(0, 0, 0, d.height);
                if (!this.isFlat) {
                    g.setColor(SystemColor.controlHighlight);
                    g.drawLine(d.width, 1, 1, 1);
                    g.drawLine(1, 1, 1, d.height);
                    g.setColor(SystemColor.controlShadow);
                    g.drawLine(d.width - 2, 1, d.width - 2, d.height);
                    g.drawLine(d.width, d.height - 2, 1, d.height - 2);
                }
                g.setColor(SystemColor.controlDkShadow);
                g.drawLine(d.width - 1, 0, d.width - 1, d.height);
                g.drawLine(d.width, d.height - 1, 0, d.height - 1);
            }
            g.setColor(this.getBackground());
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        if (this.isEnabled()) {
            int id = e.getID();
            switch (id) {
                case 501: {
                    if (this.tempDown) break;
                    this.tempDown = true;
                    Container cont = this.getParent();
                    if (cont == null) break;
                    cont.repaint();
                    break;
                }
                case 502: {
                    if (this.tempDown) {
                        this.tempDown = false;
                        if (this.group >= 0) {
                            this.setDown(true);
                        }
                    }
                    if (this.group < 0) {
                        this.setDown(false);
                    }
                    this.processActionEvent(new ActionEvent(this, e.getID(), this.getName()));
                    if (this.linkmask == null) break;
                    this.host.showURL(this.linkmask, this.targetPage);
                    break;
                }
                case 504: {
                    if (this.imageHot != null && this.isEnabled() && !this.isDown && !this.tempDown && !this.isHot) {
                        this.isHot = true;
                        this.repaint();
                    }
                    super.processMouseEvent(e);
                    break;
                }
                case 505: {
                    if (this.imageHot != null && this.isEnabled() && !this.isDown && !this.tempDown && this.isHot) {
                        this.isHot = false;
                        this.repaint();
                    }
                }
                default: {
                    super.processMouseEvent(e);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        int id = e.getID();
        this.processActionEvent(new ActionEvent(this, e.getID(), null));
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actListener != null) {
            this.actListener.actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actListener = AWTEventMulticaster.add(this.actListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actListener = AWTEventMulticaster.remove(this.actListener, l);
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.group = XmlUtils.getInt("group", layout, -1);
        this.image = host.getImage(XmlUtils.getString("image", layout, null));
        this.imageDisabled = host.getImage(XmlUtils.getString(IMAGE_DISABLED, layout, null));
        this.imageHot = host.getImage(XmlUtils.getString(IMAGE_HOT, layout, null));
        this.imagePressed = host.getImage(XmlUtils.getString(IMAGE_PRESSED, layout, null));
        String s = XmlUtils.getString("style", layout, "3D");
        this.drawBorder = true;
        this.isFlat = true;
        if (XmlUtils.getBoolean(_FLAT, layout, false) || "none".equalsIgnoreCase(s)) {
            this.drawBorder = false;
        } else if ("3D".equalsIgnoreCase(s)) {
            this.isFlat = false;
        }
        if (this.imageHot == null && this.isFlat) {
            this.imageHot = this.image;
        }
        this.host = host;
        this.linkmask = XmlUtils.getLangString("linkmask", layout, null, MapUtils.language);
        if (this.linkmask != null) {
            this.linkmask = MapUtils.parameterArgument(host, this.linkmask);
        }
        this.targetPage = XmlUtils.getString("target", layout, null);
        this.isDown = XmlUtils.getBoolean(_DOWN, layout, false);
    }

    public void stop() {
    }
}

