/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.alov.util.AlovMapException;
import org.alov.util.Log;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.util.closeTag;
import org.alov.util.defTag;
import org.alov.util.infoTag;

public class XmlParser {
    public static Vector messages = null;
    private static int currentPos = 0;
    private static int counter = 0;

    public static int indexOf(char[] v, int ch, int fromIndex, int max) {
        for (int i = fromIndex; i < max; ++i) {
            if (v[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(StringBuffer v, int ch, int fromIndex, int max) {
        for (int i = fromIndex; i < max; ++i) {
            if (v.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstWhitespace(StringBuffer v, int fromIndex, int max) {
        for (int i = fromIndex; i < max; ++i) {
            if (!Character.isWhitespace(v.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] v, String ch, int fromIndex, int max) {
        char startCh = ch.charAt(0);
        int max2 = ch.length();
        for (int i = fromIndex; i < max; ++i) {
            if (v[i] != startCh) continue;
            boolean tr = true;
            for (int k = 1; k < max2; ++k) {
                if (v[k + i] == ch.charAt(k)) continue;
                tr = false;
                break;
            }
            if (!tr) continue;
            return i;
        }
        return -1;
    }

    public static XmlElement parseXml(String buf) throws AlovMapException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf.getBytes());
        return XmlParser.parseXml(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmlElement parseXml(InputStream is) throws AlovMapException {
        try {
            StringBuffer buf = new StringBuffer();
            messages = new Vector();
            XmlElement lastTag = null;
            currentPos = 0;
            int in_pos = 0;
            InputStreamReader in = null;
            String strEnc = "ISO-8859-1";
            ByteArrayInputStream bis = null;
            try {
                int bytesRead;
                Stack<Object> stack = new Stack<Object>();
                boolean bNotEncoded = true;
                boolean isTagClosed = false;
                boolean isDef = false;
                String defSearch = ">";
                ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
                byte[] bytes = new byte[8192];
                while ((bytesRead = is.read(bytes)) > 0) {
                    bos.write(bytes, 0, bytesRead);
                }
                bytes = bos.toByteArray();
                bos = null;
                bis = new ByteArrayInputStream(bytes);
                in = new InputStreamReader((InputStream)bis, "ISO-8859-1");
                char[] cbuf = new char[8192];
                StringBuffer buf2 = new StringBuffer();
                boolean bTagFull = true;
                while ((bytesRead = in.read(cbuf)) > -1) {
                    in_pos += bytesRead;
                    currentPos = 0;
                    while (currentPos < bytesRead) {
                        XmlElement root;
                        int tag_end;
                        int tag_start;
                        if (bTagFull) {
                            buf.setLength(0);
                            tag_start = XmlParser.indexOf(cbuf, 60, currentPos, bytesRead);
                            isTagClosed = false;
                            if (tag_start > currentPos) {
                                buf2.append(cbuf, currentPos, tag_start - currentPos);
                            }
                            if (tag_start == -1) {
                                buf2.append(cbuf, currentPos, bytesRead - currentPos);
                                currentPos = bytesRead;
                            } else if (tag_start == bytesRead - 1) {
                                bTagFull = false;
                                currentPos = bytesRead;
                            }
                            if (currentPos == bytesRead) {
                                continue;
                            }
                        } else {
                            tag_start = -1;
                        }
                        if (tag_start > -1) {
                            currentPos = tag_start + 1;
                        }
                        if ((tag_end = XmlParser.indexOf(cbuf, 62, currentPos, bytesRead)) <= -1) {
                            buf.append(cbuf, currentPos, bytesRead - currentPos);
                            bTagFull = false;
                            currentPos = bytesRead;
                            continue;
                        }
                        buf.append(cbuf, currentPos, tag_end - currentPos);
                        if (buf.length() < 1) {
                            throw new AlovMapException("Empty tag. ");
                        }
                        if (!isDef) {
                            switch (buf.charAt(0)) {
                                case '!': {
                                    isDef = true;
                                    if (XmlUtils.subBuffer(buf, 1, 3).toString().equals("--")) {
                                        defSearch = "--";
                                        break;
                                    }
                                    if (XmlUtils.subBuffer(buf, 1, 2).toString().equals("[")) {
                                        defSearch = "]";
                                        break;
                                    }
                                    isDef = false;
                                }
                            }
                        }
                        if (isDef && !buf.toString().endsWith(defSearch)) {
                            bTagFull = false;
                            buf.append('>');
                            currentPos = tag_end + 1;
                            continue;
                        }
                        int max = buf.length() - 1;
                        if (buf.charAt(max) == '/') {
                            buf = XmlUtils.subBuffer(buf, 0, max);
                            isTagClosed = true;
                        }
                        Object el = XmlParser.parseTag(buf);
                        bTagFull = true;
                        if (el instanceof infoTag) {
                            strEnc = XmlUtils.getString("encoding", (XmlElement)el, "ISO-8859-1");
                            if (!strEnc.equals("ISO-8859-1") && bNotEncoded) {
                                if (strEnc.equals("UTF-8")) {
                                    strEnc = "UTF8";
                                }
                                bis.reset();
                                in = new InputStreamReader((InputStream)bis, strEnc);
                                buf.setLength(0);
                                bNotEncoded = false;
                                bytesRead = -1;
                                in_pos = 0;
                            }
                        } else if (el instanceof defTag) {
                            String val;
                            isDef = false;
                            defTag def = (defTag)el;
                            if (Strings.isNullOrBlank(def.name) && !Strings.isNullOrBlank(val = (String)def.attributes.get("CDATA")) && !stack.empty()) {
                                XmlElement root2 = (XmlElement)stack.peek();
                                root2.value = val;
                            }
                        } else if (el instanceof closeTag) {
                            if (stack.empty()) {
                                throw new AlovMapException("Tag missing with name \"" + ((closeTag)el).name + "\".");
                            }
                            root = (XmlElement)stack.peek();
                            if (!root.tagName.equals(((closeTag)el).name)) throw new AlovMapException("End tag \"" + ((closeTag)el).name + "\" does not correspond start tag \"" + root.tagName + "\".");
                            if (root.children.size() == 0 && buf2.length() > 0) {
                                if (root.value == null) {
                                    root.value = XmlUtils.removeObjs(buf2).trim();
                                }
                                buf2 = new StringBuffer();
                            }
                            stack.pop();
                            lastTag = root;
                        } else {
                            buf2 = new StringBuffer();
                            if (!stack.empty()) {
                                root = (XmlElement)stack.peek();
                                root.addChild((XmlElement)el);
                            }
                            if (!isTagClosed) {
                                stack.push(el);
                            } else {
                                lastTag = (XmlElement)el;
                            }
                        }
                        currentPos = tag_end < 0 ? bytesRead : tag_end + 1;
                    }
                }
            }
            catch (Exception e) {
                String s = e.getMessage();
                if (bis != null) {
                    bis.reset();
                    Hashtable str = XmlParser.getPos(bis, in_pos, currentPos, strEnc);
                    Enumeration en = str.keys();
                    while (en.hasMoreElements()) {
                        String k = (String)en.nextElement();
                        Object v = str.get(k);
                        s = s + k + v + " ";
                    }
                }
                e.printStackTrace();
                throw new AlovMapException(s);
            }
            XmlElement xmlElement = lastTag;
            return xmlElement;
        }
        finally {
            if (messages.size() > 0) {
                for (int i = 0; i < messages.size(); ++i) {
                    Log.log(0, (String)messages.elementAt(i));
                }
            }
        }
    }

    private static Hashtable getPos(ByteArrayInputStream bis, int pos, int cpos, String strEnc) {
        Hashtable<String, Integer> res = new Hashtable<String, Integer>();
        int ln = 0;
        try {
            int bytesRead;
            InputStreamReader in = new InputStreamReader((InputStream)bis, strEnc);
            int prev_pos = 0;
            int g_pos = 0;
            char[] cbuf = new char[8192];
            while ((bytesRead = in.read(cbuf)) > -1) {
                g_pos += bytesRead;
                int cur_pos = 0;
                while (cur_pos < bytesRead) {
                    int i = XmlParser.indexOf(cbuf, 10, cur_pos, bytesRead);
                    if (i > -1) {
                        ++ln;
                        prev_pos = cur_pos;
                        cur_pos = i + 1;
                    } else {
                        cur_pos = bytesRead;
                    }
                    if (g_pos < pos || cur_pos < cpos) continue;
                    res.put("Line number:", new Integer(ln));
                    res.put("Column:", new Integer(cpos - prev_pos + 1));
                    return res;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return res;
    }

    private static void parseEl(XmlElement el, StringBuffer buf, int start, int max) throws AlovMapException {
        String garb;
        int eq;
        int end = 0;
        if (max - start < 4) {
            return;
        }
        while ((eq = XmlParser.indexOf(buf, 61, start, max)) > 0) {
            int i = XmlParser.indexOf(buf, 34, eq, max);
            if (i < 0) {
                throw new AlovMapException("Start quote not found.");
            }
            end = XmlParser.indexOf(buf, 34, i + 1, max);
            if (end < 0) {
                throw new AlovMapException("End quote not found.");
            }
            String atName = XmlUtils.subBuffer(buf, start, eq).toString().trim();
            XmlParser.verifyName(atName, start, false);
            el.addAttribute(atName, XmlUtils.removeObjs(XmlUtils.subBuffer(buf, i + 1, end)));
            start = end + 1;
        }
        if (end >= 0 && !Strings.isNullOrBlank(garb = XmlUtils.subBuffer(buf, end + 1).toString().trim())) {
            messages.addElement("Garbage in element " + el.tagName + ": " + garb);
        }
    }

    public static String getTagName(String s) {
        int i = s.indexOf(58);
        if (i < 0) {
            return s;
        }
        return s.substring(i + 1);
    }

    private static Object parseTag(StringBuffer buf) throws AlovMapException {
        int max = buf.length();
        char t = buf.charAt(0);
        switch (t) {
            case '/': {
                String t_name = XmlUtils.subBuffer(buf, 1).toString();
                XmlParser.verifyName(t_name, 1, true);
                closeTag close = new closeTag(t_name);
                return close;
            }
            case '?': {
                if (buf.charAt(max - 1) != '?') {
                    throw new AlovMapException("Invalid tag format: <" + XmlUtils.subBuffer(buf, 0, 10).toString() + "...> ");
                }
                int i = XmlParser.getFirstWhitespace(buf = XmlUtils.subBuffer(buf, 1, max - 1), 0, max -= 2);
                if (i < 0) {
                    return new infoTag(buf.toString());
                }
                infoTag info = new infoTag(XmlUtils.subBuffer(buf, 0, i).toString());
                XmlParser.parseEl(info, buf, i + 1, max);
                return info;
            }
            case '!': {
                return defTag.parseBuf(buf, 1);
            }
        }
        int i = XmlParser.getFirstWhitespace(buf, 0, max);
        if (i < 0) {
            String t_name = buf.toString();
            XmlParser.verifyName(t_name, 0, true);
            return new XmlElement(XmlParser.getTagName(t_name));
        }
        String t_name = XmlUtils.subBuffer(buf, 0, i).toString().trim();
        XmlParser.verifyName(t_name, 0, true);
        XmlElement el = new XmlElement(XmlParser.getTagName(t_name));
        XmlParser.parseEl(el, buf, i + 1, max);
        return el;
    }

    private static void verifyName(String name, int pos, boolean b) throws AlovMapException {
        if (name.length() < 1) {
            throw new AlovMapException("Empty name is not allowed. ");
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c) && c != '_' && c != ':') {
            ++currentPos;
            throw new AlovMapException("Invalid start character '" + c + "': \"" + name + "\". ");
        }
        char[] cbuf = name.toCharArray();
        int l = cbuf.length;
        for (int i = 0; i < l; ++i) {
            c = cbuf[i];
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.' || c == ':') continue;
            currentPos += pos;
            if (b) {
                currentPos += i;
            }
            throw new AlovMapException("Invalid character '" + c + "': \"" + name + "\". ");
        }
    }
}

