/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.util.Strings;
import org.alov.util.XmlUtils;

public class XmlElement {
    Vector children = new Vector();
    Hashtable attributes = new Hashtable();
    String tagName;
    public String value = null;

    public XmlElement(String name) {
        this.tagName = name;
    }

    public String getNodeName() {
        return this.tagName;
    }

    public Vector getChildren() {
        return this.children;
    }

    public Vector getElementsByTagName(String name) {
        return this.getElementsByTagName(name, false);
    }

    public Vector getElementsByTagName(String name, boolean caseSensitive) {
        Vector<XmlElement> result = new Vector<XmlElement>();
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            XmlElement el = (XmlElement)this.children.elementAt(i);
            if (!XmlElement.stringEquals(el.tagName, name, caseSensitive)) continue;
            result.addElement(el);
        }
        return result;
    }

    public XmlElement getFirstElementByName(String name) {
        return this.getFirstElementByName(name, false);
    }

    public XmlElement getFirstElementByName(String name, boolean caseSensitive) {
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            XmlElement el = (XmlElement)this.children.elementAt(i);
            if (!XmlElement.stringEquals(el.tagName, name, caseSensitive)) continue;
            return el;
        }
        return null;
    }

    public XmlElement getLangElementByName(String name, String language, boolean caseSensitive) {
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            String sLang;
            XmlElement el = (XmlElement)this.children.elementAt(i);
            if (!XmlElement.stringEquals(el.tagName, name, caseSensitive) || !(sLang = el.getAttributeValue("xml:lang")).equalsIgnoreCase(language)) continue;
            return el;
        }
        return null;
    }

    public XmlElement findElementByAttrib(String name, String attrName, String val, boolean reqursive) {
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            String s;
            XmlElement el = (XmlElement)this.children.elementAt(i);
            if (XmlElement.stringEquals(el.tagName, name, false) && (s = el.getAttributeValue(attrName)) != null && XmlElement.stringEquals(s, val, false)) {
                return el;
            }
            if (!reqursive || (el = el.findElementByAttrib(name, attrName, val, true)) == null) continue;
            return el;
        }
        return null;
    }

    public Vector findAllElementByAttrib(String name, String attrName, String val, boolean caseSensitive) {
        Vector<XmlElement> result = new Vector<XmlElement>();
        int count = this.children.size();
        for (int i = 0; i < count; ++i) {
            XmlElement el = (XmlElement)this.children.elementAt(i);
            if (!XmlElement.stringEquals(el.tagName, name, caseSensitive)) continue;
            String s = el.getAttributeValue(attrName);
            if (s != null && XmlElement.stringEquals(s, val, caseSensitive)) {
                result.addElement(el);
            }
            XmlUtils.addAll(result, el.findAllElementByAttrib(name, attrName, val, caseSensitive));
        }
        return result;
    }

    public String getAttributeValue(String s) {
        Enumeration e = this.attributes.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            if (!k.equalsIgnoreCase(s)) continue;
            return (String)this.attributes.get(k);
        }
        return null;
    }

    public void addChild(XmlElement el) {
        this.children.addElement(el);
    }

    public XmlElement addChildElement(String name, String value) {
        XmlElement el = new XmlElement(name);
        if (!Strings.isNullOrBlank(value)) {
            el.value = value;
        }
        this.addChild(el);
        return el;
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void removeAllAttributes() {
        this.attributes.clear();
    }

    void addCharacters(char[] ch) {
        String val = new String(ch);
        this.value = this.value != null ? this.value + val : val;
    }

    public String getElValue(String elemName, String def) {
        return this.getElValue(elemName, def, false);
    }

    public String getElValue(String elemName, String def, boolean caseSensitive) {
        XmlElement textElem = this.getFirstElementByName(elemName, caseSensitive);
        return textElem == null || textElem.value == null ? def : textElem.value.trim();
    }

    private static boolean stringEquals(String s1, String s2, boolean caseSensitive) {
        return caseSensitive ? s1.equals(s2) : s1.equalsIgnoreCase(s2);
    }
}

