/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.alov.util.Strings;

public class ExDate
implements Serializable {
    static final double _YRS = 365.25;
    static final double _MON = 30.4375;
    static final double _HRS = 0.041666666666666664;
    static final double _MIN = 6.944444444444444E-4;
    static final double _SEC = 1.1574074074074073E-5;
    private static final long dateOrigin = 2044000L;
    private static final long D1 = 365L;
    private static final long D4 = 1461L;
    private static final long D100 = 36524L;
    private static final long D400 = 146097L;
    private static final int[][] monthDays = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    double days;

    public ExDate() {
    }

    public ExDate(double days) {
        this.days = days;
    }

    public ExDate(long y, long m, long d) {
        this(y, m, d, 0L, 0L, 0L);
    }

    public ExDate(long y, long m, long d, long h, long min, long s) {
        this.days = ExDate.encode(y, m, d, h, min, s);
    }

    public static double encode(long y, long m, long d, long h, long min, long s) {
        int[] dayTable = monthDays[ExDate.isLeapYear(y += 2044000L)];
        if (y < 0L || m < 1L || m > 12L || d < 1L || d > (long)dayTable[(int)m - 1] || h < 0L || h > 23L || min < 0L || min > 59L || s < 0L || s > 59L) {
            return Double.NaN;
        }
        int j = 1;
        while ((long)j <= m - 1L) {
            d += (long)dayTable[j - 1];
            ++j;
        }
        long i = y - 1L;
        double dbl = (double)i * 365.0 + (double)(i / 4L) - (double)(i / 100L) + (double)(i / 400L) + (double)d;
        return dbl += ((double)h + (double)min / 60.0 + (double)s / 3600.0) / 24.0;
    }

    public double getDays() {
        return this.days;
    }

    public int compareTo(ExDate date) {
        if (date.days > this.days) {
            return -1;
        }
        if (date.days < this.days) {
            return 1;
        }
        return 0;
    }

    public void increaseUnits(int units, double value) throws Exception {
        switch (units) {
            case 0: {
                long[] date = this.getYMDHMS();
                date[0] = (long)((double)date[0] + Math.ceil(value));
                this.days = ExDate.encode(date[0], date[1], date[2], date[3], date[4], date[5]);
                this.days += 365.25 * (value - Math.ceil(value));
                break;
            }
            case 1: {
                long[] date = this.getYMDHMS();
                date[1] = (long)((double)date[1] + Math.ceil(value));
                this.days = ExDate.encode(date[0], date[1], date[2], date[3], date[4], date[5]);
                this.days += 30.4375 * (value - Math.ceil(value));
                break;
            }
            case 2: {
                this.days += value;
                break;
            }
            case 3: {
                this.days += 0.041666666666666664 * value;
                break;
            }
            case 4: {
                this.days += 6.944444444444444E-4 * value;
                break;
            }
            case 5: {
                this.days += 1.1574074074074073E-5 * value;
                break;
            }
            default: {
                throw new Exception("Invalid time units: " + units);
            }
        }
    }

    public static ExDate parseObject(Object o) {
        if (o instanceof ExDate) {
            return (ExDate)o;
        }
        if (o instanceof String) {
            return ExDate.parseString((String)o);
        }
        if (o instanceof Number) {
            return ExDate.parseNumber((Number)o);
        }
        return null;
    }

    public static ExDate parseNumber(Number n) {
        long d = (long)n.doubleValue();
        if (Math.abs(d) > 9999L) {
            String s = n.toString();
            return ExDate.parseDBFstring(s);
        }
        return new ExDate(d, 1L, 1L);
    }

    public static ExDate parseDBFstring(String s) {
        if (Strings.isNullOrBlank(s)) {
            return new ExDate(0.0);
        }
        int l = s.length();
        int yc = s.charAt(0) == '-' ? 5 : 4;
        long y = Strings.strToInt(s.substring(0, yc), 1);
        long m = l > yc ? (long)Strings.strToInt(s.substring(yc, yc + 2), 1) : 1L;
        long d = l > yc + 2 ? (long)Strings.strToInt(s.substring(yc + 2, yc + 4), 1) : 1L;
        return new ExDate(y, m, d);
    }

    public static ExDate parseString(String s) {
        if (s == null || s.length() <= 0) {
            return null;
        }
        int bc = 1;
        if (s.charAt(0) == '-') {
            s = s.substring(1);
            bc = -1;
        }
        StringTokenizer tok = new StringTokenizer(s, "-T:/ ");
        long[] values = new long[6];
        for (int i = 0; i < 6; ++i) {
            values[i] = tok.hasMoreTokens() ? Long.parseLong(tok.nextToken()) : (i < 3 ? 1L : 0L);
        }
        return new ExDate((long)bc * values[0], values[1], values[2], values[3], values[4], values[5]);
    }

    private static int isLeapYear(long y) {
        return y % 4L == 0L && (y % 100L != 0L || y % 400L == 0L) ? 1 : 0;
    }

    public static long[] getYMDHMS(double date) {
        long resultD;
        long resultM;
        long resultY;
        double dbl = (date += 1.1574074074074074E-6) - Math.floor(date);
        long resultH = (long)Math.floor(dbl * 24.0) % 24L;
        long resultMin = (long)Math.floor(dbl * 24.0 * 60.0) % 60L;
        long resultS = (long)Math.floor(dbl * 24.0 * 3600.0) % 60L;
        long t = (long)Math.floor(date);
        if (t <= 0L) {
            resultY = 0L;
            resultM = 0L;
            resultD = 0L;
            long resultDOW = 0L;
        } else {
            long resultDOW = t % 7L;
            --t;
            long y = 1L;
            while (t >= 146097L) {
                t -= 146097L;
                y += 400L;
            }
            long i = t / 36524L;
            long d = t % 36524L;
            if (i == 4L) {
                --i;
                d += 36524L;
            }
            y += i * 100L;
            i = d / 1461L;
            y += i * 4L;
            i = (d %= 1461L) / 365L;
            d %= 365L;
            if (i == 4L) {
                --i;
                d += 365L;
            }
            int[] dayTable = monthDays[ExDate.isLeapYear(y += i)];
            int m = 1;
            while (d >= (i = (long)dayTable[m - 1])) {
                d -= i;
                ++m;
            }
            resultY = y - 2044000L;
            resultM = m;
            resultD = d + 1L;
        }
        long[] result = new long[]{resultY, resultM, resultD, resultH, resultMin, resultS};
        return result;
    }

    public long[] getYMDHMS() {
        return ExDate.getYMDHMS(this.days);
    }

    public long getYear() {
        long[] data = ExDate.getYMDHMS(this.days);
        return data[0];
    }

    public static String toString(double days) {
        return ExDate.toString(days, 5);
    }

    public static String toString(double days, int level) {
        long[] ymdhms = ExDate.getYMDHMS(days);
        String separators = "-- ::";
        StringBuffer res = new StringBuffer();
        for (int i = 0; i <= level; ++i) {
            if (i > 0) {
                res.append("-- ::".charAt(i - 1));
            }
            res.append(ymdhms[i]);
        }
        return res.toString();
    }

    public String toString() {
        return ExDate.toString(this.days);
    }

    public String toString(int level) {
        return ExDate.toString(this.days, level);
    }
}

