/*
 * Decompiled with CFR 0.152.
 */
package org.alov.ogcfilter;

import java.util.List;
import java.util.Vector;
import org.alov.ogcfilter.Expression;
import org.alov.ogcfilter.FilterConst;
import org.alov.ogcfilter.FilterException;
import org.alov.util.Strings;
import org.alov.util.XmlElement;

public class Function
implements FilterConst {
    public List expressions = new Vector();
    public String functionName = null;

    public Function(XmlElement root) throws FilterException {
        this.functionName = root.getAttributeValue("name");
        if (Strings.isNullOrBlank(this.functionName)) {
            throw new FilterException("Invalid function name");
        }
        Vector children = root.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                this.expressions.add(new Expression((XmlElement)children.elementAt(i)));
            }
        }
    }

    public StringBuffer constructSQL() throws FilterException {
        StringBuffer result = new StringBuffer();
        result.append(this.functionName).append(" (");
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression expr = (Expression)this.expressions.get(i);
            result.append(expr.constructSQL());
            if (i == this.expressions.size() - 1) continue;
            result.append(", ");
        }
        result.append(")");
        return result;
    }

    public XmlElement getXml() {
        XmlElement root = new XmlElement("Function");
        root.addAttribute("name", this.functionName);
        for (int i = 0; i < this.expressions.size(); ++i) {
            root.addChild(((Expression)this.expressions.get(i)).getXml());
        }
        return root;
    }
}

