/*
 * Decompiled with CFR 0.152.
 */
package org.alov.ogcfilter;

import java.util.List;
import java.util.Vector;
import org.alov.ogcfilter.FilterConst;
import org.alov.ogcfilter.FilterException;
import org.alov.ogcfilter.Function;
import org.alov.util.XmlElement;

public class Expression
implements FilterConst {
    public int type = -1;
    public List expressions = new Vector();
    public String propertyName = null;
    public String literal = null;
    public Function function = null;

    public Expression(int type) {
        this.type = type;
    }

    public Expression(XmlElement root) throws FilterException {
        String tagName = root.getNodeName();
        if ("PropertyName".equalsIgnoreCase(tagName)) {
            this.type = 5;
            this.propertyName = root.value.trim();
            return;
        }
        if ("Literal".equalsIgnoreCase(tagName)) {
            this.type = 6;
            this.literal = root.value.trim();
            return;
        }
        if ("Function".equalsIgnoreCase(tagName)) {
            this.type = 7;
            this.function = new Function(root);
            return;
        }
        if ("Add".equalsIgnoreCase(tagName)) {
            this.type = 1;
        } else if ("Sub".equalsIgnoreCase(tagName)) {
            this.type = 2;
        } else if ("Mul".equalsIgnoreCase(tagName)) {
            this.type = 3;
        } else if ("Div".equalsIgnoreCase(tagName)) {
            this.type = 4;
        }
        Vector xmlExpr = root.getChildren();
        if (xmlExpr == null || xmlExpr.size() != 2) {
            throw new FilterException("Invalid expression: missing elements");
        }
        this.expressions.add(new Expression((XmlElement)xmlExpr.get(0)));
        this.expressions.add(new Expression((XmlElement)xmlExpr.get(1)));
    }

    private static String getBinaryExpressionOperator(int type) {
        String result;
        switch (type) {
            case 1: {
                result = "+";
                break;
            }
            case 2: {
                result = "-";
                break;
            }
            case 4: {
                result = "/";
                break;
            }
            case 3: {
                result = "*";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public StringBuffer constructSQL() throws FilterException {
        StringBuffer result = new StringBuffer();
        switch (this.type) {
            case 5: {
                result.append(this.propertyName);
                break;
            }
            case 6: {
                try {
                    new Double(this.literal);
                    result.append(this.literal);
                }
                catch (NullPointerException ex) {
                    result.append('\'').append('\'');
                }
                catch (NumberFormatException ex) {
                    result.append('\'').append(this.literal).append('\'');
                }
                break;
            }
            case 7: {
                result.append(this.function.constructSQL());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                result.append(((Expression)this.expressions.get(0)).constructSQL());
                result.append(Expression.getBinaryExpressionOperator(this.type));
                result.append(((Expression)this.expressions.get(1)).constructSQL());
                break;
            }
        }
        return result;
    }

    private void addExpressions(XmlElement root) {
        for (int i = 0; i < this.expressions.size(); ++i) {
            root.addChild(((Expression)this.expressions.get(i)).getXml());
        }
    }

    public XmlElement getXml() {
        XmlElement root = null;
        switch (this.type) {
            case 1: {
                root = new XmlElement("Add");
                this.addExpressions(root);
                break;
            }
            case 2: {
                root = new XmlElement("Sub");
                this.addExpressions(root);
                break;
            }
            case 3: {
                root = new XmlElement("Mul");
                this.addExpressions(root);
                break;
            }
            case 4: {
                root = new XmlElement("Div");
                this.addExpressions(root);
                break;
            }
            case 6: {
                root = new XmlElement("Literal");
                root.value = this.literal;
                break;
            }
            case 5: {
                root = new XmlElement("PropertyName");
                root.value = this.propertyName;
                break;
            }
            case 7: {
                root = this.function.getXml();
                break;
            }
        }
        return root;
    }
}

