/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import org.alov.map.FloatRectangle;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;

public class Shape
implements Serializable {
    private static final int MARKER_CIRCLE = 0;
    public static final int MARKER_SQUARE = 1;
    public static final int MARKER_TRIANGLE = 2;
    public static final int MARKER_CROSS = 3;
    public static final int MARKER_CHAR = 4;
    public static final int MARKER_SHAPE = 5;
    private static final int LINE_SOLID = 0;
    private static final int LINE_DASH = 1;
    private static final int LINE_DOT = 2;
    private static final int LINE_DASHDOT = 3;
    private static final int LINE_DASHDOTDOT = 4;
    private static final int LINE_STRIPE = 5;
    private static final int LINE_ARROW = 6;
    public double[] xCoords = null;
    public double[] yCoords = null;
    public static final byte _BOTH = 0;
    public static final byte _FILL = 1;
    public static final byte _OUTLINE = 2;
    public byte typeFill = 0;

    public Shape() {
    }

    public Shape(double[] coords) {
        int count = coords.length / 2;
        this.xCoords = new double[count];
        this.yCoords = new double[count];
        int off = 0;
        int i = 0;
        while (i < count) {
            this.xCoords[i] = coords[off];
            this.yCoords[i] = coords[off + 1];
            ++i;
            off += 2;
        }
    }

    public static void drawBoldLine(Graphics g, int x1, int y1, int x2, int y2) {
        if (x1 < 0 && y1 < 0 && x2 < 0 && y2 < 0) {
            return;
        }
        int[] x = new int[]{x1, x2};
        int[] y = new int[]{y1, y2};
        g.drawPolyline(x, y, 2);
        if (x2 != x1) {
            float k = (y2 - y1) / (x2 - x1);
            if (!((double)Math.abs(k) > 2.7)) {
                // empty if block
            }
        } else {
            ++x1;
            ++x2;
        }
        x[0] = ++x1;
        x[1] = ++x2;
        y[0] = ++y1;
        y[1] = ++y2;
        g.drawPolyline(x, y, 2);
    }

    private static void drawBoldPolyline(Graphics g, int[] x, int[] y, int n) {
        if (n < 2) {
            return;
        }
        for (int i = 1; i < n; ++i) {
            Shape.drawBoldLine(g, x[i - 1], y[i - 1], x[i], y[i]);
        }
    }

    private static void drawCustomLine(Graphics g, int[] x, int[] y, Symbol sym) {
        int pointCount = x.length;
        if (sym.style == 0 || sym.style == 5 || sym.style == 6) {
            if (sym.size == 2) {
                Shape.drawBoldPolyline(g, x, y, pointCount);
                return;
            }
            g.drawPolyline(x, y, pointCount);
            if (sym.style == 0) {
                return;
            }
        }
        double len = (double)sym.step / 4.0;
        double k1 = 0.0;
        double k2 = 0.0;
        double k = 0.0;
        double c = 0.0;
        int iVis = 1;
        int iDots = 0;
        boolean bDashedLine = sym.style == 1 || sym.style == 3 || sym.style == 4;
        int m = 1;
        for (int i = 1; i < pointCount; ++i) {
            int dx = x[i] - x[i - m];
            int dy = y[i] - y[i - m];
            double l = Math.sqrt(dx * dx + dy * dy);
            if (l > 0.0) {
                double dd;
                double dd2;
                double dd1;
                k1 = (double)dy / l;
                k2 = (double)dx / l;
                if (dx == 0) {
                    dd1 = k1 * (double)sym.step;
                    dd2 = k1 * (double)sym.step / 2.0;
                    dd = k1 * len;
                    k = 0.0;
                } else {
                    k = 1.0 * (double)dy / (double)dx;
                    c = (double)y[i - m] - k * (double)x[i - m];
                    dd1 = k2 * (double)sym.step;
                    dd2 = k2 * (double)sym.step / 2.0;
                    dd = k2 * len;
                }
                int dx5 = (int)(k2 * 3.0);
                int dy5 = (int)(k1 * 3.0);
                double x0 = x[i - m];
                double y0 = y[i - m];
                double x1 = x[i - m];
                double y1 = y[i - m];
                double l2 = 0.0;
                while (true) {
                    boolean bLine;
                    boolean bl = bLine = bDashedLine && iVis > 0 && iDots == 0;
                    if (dx == 0) {
                        y1 = y0 + dd;
                        l2 = (y1 - (double)y[i - m]) / k1;
                    } else {
                        x1 = x0 + dd;
                        y1 = k * x1 + c;
                        l2 = (x1 - (double)x[i - m]) / k2;
                    }
                    if (l2 > l || l == 0.0 || l2 <= 0.0) {
                        if (!bLine) break;
                        if (sym.size == 2) {
                            Shape.drawBoldLine(g, (int)x0, (int)y0, x[i], y[i]);
                            break;
                        }
                        g.drawLine((int)x0, (int)y0, x[i], y[i]);
                        break;
                    }
                    if (bLine) {
                        if (sym.size == 2) {
                            Shape.drawBoldLine(g, (int)x0, (int)y0, (int)x1, (int)y1);
                        } else {
                            g.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
                        }
                        iVis = 0;
                    } else {
                        ++iVis;
                    }
                    x0 = x1;
                    y0 = y1;
                    if (sym.style == 5) {
                        g.drawLine((int)(x0 - (double)dy5), (int)(y0 + (double)dx5), (int)(x0 + (double)dy5), (int)(y0 - (double)dx5));
                    } else if (sym.style == 2 || iDots == 1 || sym.style == 4 && iDots == 2) {
                        if (sym.size == 2) {
                            g.fillRect((int)x0 - 1, (int)y0 - 1, 2, 2);
                        } else {
                            g.fillRect((int)x0, (int)y0, 1, 1);
                        }
                    }
                    if (sym.style == 3 && iDots < 2 || sym.style == 4 && iDots < 3) {
                        iVis = 0;
                        ++iDots;
                        len = sym.step / 2;
                        dd = dd2;
                        continue;
                    }
                    iDots = 0;
                    len = sym.step;
                    dd = dd1;
                }
                if (sym.style == 6) {
                    int[] xP = new int[]{x[i], x[i] - 6, x[i] - 6};
                    int[] yP = new int[]{y[i], y[i] - 3, y[i] + 3};
                    float ang = (float)Math.atan2(dy, dx);
                    MapUtils.rotate_coords(xP, yP, x[i], y[i], ang);
                    g.fillPolygon(xP, yP, 3);
                }
                len = l2 - l;
                m = 1;
                continue;
            }
            ++m;
        }
    }

    public static void drawPoint(Graphics g, Symbol sym, int x0, int y0) {
        x0 += sym.xOffset;
        y0 += sym.yOffset;
        Image img = sym.image;
        if (img != null) {
            int x = img.getWidth(null);
            int y = img.getHeight(null);
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            x = x0 - x / 2;
            y = y0 - y / 2;
            Object oldTransform = null;
            if (sym.rotation != 0.0f) {
                oldTransform = Utils2D.getTransform(g);
                Utils2D.rotateGraphics(g, x0, y0, sym.rotation);
            }
            g.drawImage(img, x, y, MapUtils.getGlobalImageObserver());
            if (sym.rotation != 0.0f) {
                Utils2D.setTransform(g, oldTransform);
            }
            return;
        }
        int s = sym.size;
        int x = x0 - s / 2;
        int y = y0 - s / 2;
        int[] xPoints = null;
        int[] yPoints = null;
        int len = 3;
        switch (sym.style) {
            case 1: {
                xPoints = new int[]{x, x + s, x + s, x};
                yPoints = new int[]{y, y, y + s, y + s};
                len = 4;
            }
            case 2: {
                if (sym.style == 2) {
                    xPoints = new int[]{x, x0, x0 + s / 2};
                    yPoints = new int[]{y0 + s / 2, y, y0 + s / 2};
                }
                MapUtils.rotate_coords(xPoints, yPoints, x0, y0, sym.rotation);
                if (sym.fill) {
                    g.setColor(sym.fillColor);
                    g.fillPolygon(xPoints, yPoints, len);
                }
                if (!sym.outline) break;
                g.setColor(sym.outlineColor);
                g.drawPolygon(xPoints, yPoints, len);
                break;
            }
            case 3: {
                if (!sym.outline) {
                    return;
                }
                xPoints = new int[]{x, x0 + s / 2, x0, x0};
                yPoints = new int[]{y0, y0, y, y0 + s / 2};
                MapUtils.rotate_coords(xPoints, yPoints, x0, y0, sym.rotation);
                g.setColor(sym.fillColor);
                g.drawLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                g.drawLine(xPoints[2], yPoints[2], xPoints[3], yPoints[3]);
                break;
            }
            case 4: {
                if (sym.fontName == null) break;
                if (sym.font == null) {
                    sym.font = MapUtils.createAndVerifyFont(sym.fontName, sym.fontStyle, sym.size > 0 ? sym.size : MapUtils.defaultPlainFont.getSize(), sym.charMarker);
                    if (sym.font == null) {
                        System.out.println("Can't set font " + sym.fontName + " for character " + sym.charMarker);
                        sym.fontName = null;
                        return;
                    }
                }
                g.setFont(sym.font);
                g.setColor(sym.fillColor);
                FontMetrics fm = g.getFontMetrics();
                int w = fm.stringWidth(sym.charMarker);
                int h = fm.getHeight();
                x = x0 - w / 2;
                y = y0 + h / 2;
                g.drawString(sym.charMarker, x, y);
                break;
            }
            case 5: {
                int pointCount = sym.symbolShape.xCoords.length;
                int[] xCoords2 = new int[pointCount];
                int[] yCoords2 = new int[pointCount];
                for (int i = 0; i < pointCount; ++i) {
                    xCoords2[i] = (int)sym.symbolShape.xCoords[i] + x0;
                    yCoords2[i] = (int)sym.symbolShape.yCoords[i] + y0;
                }
                MapUtils.rotate_coords(xCoords2, yCoords2, x0, y0, sym.rotation);
                Utils2D.polygon(g, xCoords2, yCoords2, pointCount, sym);
                break;
            }
            default: {
                if (sym.fill) {
                    g.setColor(sym.fillColor);
                    g.fillOval(x, y, s, s);
                }
                if (!sym.outline) break;
                g.setColor(sym.outlineColor);
                g.drawOval(x, y, s, s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void paintShape(Shape shp, Graphics g, Projection prj, Symbol sym, int type) {
        if (shp.xCoords == null) return;
        if (shp.yCoords == null) {
            return;
        }
        boolean bSymWas = true;
        if (shp.typeFill != 0) {
            if (shp.typeFill == 1) {
                if (!sym.fill) {
                    return;
                }
                bSymWas = sym.outline;
                sym.outline = false;
            } else {
                if (!sym.outline) {
                    return;
                }
                bSymWas = sym.fill;
                sym.fill = false;
            }
        }
        try {
            int pointCount = shp.xCoords.length;
            int[] xCoords2 = new int[shp.xCoords.length];
            int[] yCoords2 = new int[shp.yCoords.length];
            for (int i = 0; i < pointCount; ++i) {
                xCoords2[i] = (int)((shp.xCoords[i] + prj.shift.x) * prj.zoom);
                yCoords2[i] = (int)((-shp.yCoords[i] + prj.shift.y) * prj.zoom);
                if (xCoords2[i] > 31999) {
                    xCoords2[i] = 31999;
                } else if (xCoords2[i] < -31999) {
                    xCoords2[i] = -31999;
                }
                if (yCoords2[i] > 31999) {
                    yCoords2[i] = 31999;
                    continue;
                }
                if (yCoords2[i] >= -31999) continue;
                yCoords2[i] = -31999;
            }
            switch (type) {
                case 1: {
                    Shape.drawPoint(g, sym, xCoords2[0], yCoords2[0]);
                    return;
                }
                case 3: {
                    Utils2D.polygon(g, xCoords2, yCoords2, pointCount, sym);
                    return;
                }
                case 2: {
                    if (!sym.outline) {
                        return;
                    }
                    if (Utils2D.have2d() && sym.g2dStroke != null) {
                        Utils2D.line(g, xCoords2, yCoords2, pointCount, sym);
                        return;
                    }
                    g.setColor(sym.outlineColor);
                    Shape.drawCustomLine(g, xCoords2, yCoords2, sym);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            return;
        }
        finally {
            if (shp.typeFill != 0) {
                if (shp.typeFill == 1) {
                    sym.outline = bSymWas;
                } else {
                    sym.fill = bSymWas;
                }
            }
        }
    }

    public static FloatRectangle calculateExtent(Shape shp) {
        if (shp.xCoords == null || shp.yCoords == null) {
            return null;
        }
        double maxX = shp.xCoords[0];
        double maxY = shp.yCoords[0];
        double minX = maxX;
        double minY = maxY;
        for (int i = 1; i < shp.xCoords.length; ++i) {
            if (maxX < shp.xCoords[i]) {
                maxX = shp.xCoords[i];
            } else if (minX > shp.xCoords[i]) {
                minX = shp.xCoords[i];
            }
            if (maxY < shp.yCoords[i]) {
                maxY = shp.yCoords[i];
                continue;
            }
            if (!(minY > shp.yCoords[i])) continue;
            minY = shp.yCoords[i];
        }
        return new FloatRectangle(minX, minY, maxX, maxY);
    }

    public static boolean containsPoint(Shape shp, double x, double y) {
        if (shp.xCoords == null || shp.yCoords == null) {
            return false;
        }
        if (shp.typeFill == 2) {
            return false;
        }
        double[] xCoords = shp.xCoords;
        double[] yCoords = shp.yCoords;
        int sc = 0;
        int len = xCoords.length;
        double p1x = xCoords[len - 1];
        double p1y = yCoords[len - 1];
        for (int i = 0; i < len; ++i) {
            double p2x = xCoords[i];
            double p2y = yCoords[i];
            if ((x < p1x || x < p2x) && (y < p1y && y >= p2y || y < p2y && y >= p1y)) {
                if (x < p1x && x < p2x) {
                    ++sc;
                } else if ((y - p1y) * (p2x - p1x) / (p2y - p1y) + p1x > x) {
                    ++sc;
                }
            }
            p1x = p2x;
            p1y = p2y;
        }
        return sc & true;
    }

    public static boolean isClockWise(Shape shp) {
        int npoints = shp.xCoords.length - 1;
        double area = shp.xCoords[npoints] * shp.yCoords[0] - shp.xCoords[0] * shp.yCoords[npoints];
        for (int i = 0; i < npoints; ++i) {
            area += shp.xCoords[i] * shp.yCoords[i + 1] - shp.xCoords[i + 1] * shp.yCoords[i];
        }
        return area >= 0.0;
    }

    public void setVertex(int index, double x, double y) {
        if (index >= 0 && index < this.xCoords.length) {
            this.xCoords[index] = x;
            this.yCoords[index] = y;
        }
    }
}

