/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.util.Vector;
import org.alov.map.Layer;
import org.alov.map.Renderer;
import org.alov.map.RendererDef;
import org.alov.map.RendererGrad;
import org.alov.map.RendererLabel;
import org.alov.map.SLD_Const;
import org.alov.map.SLD_Graphic;
import org.alov.map.SLD_LineSymbolizer;
import org.alov.map.SLD_PointSymbolizer;
import org.alov.map.SLD_PolySymbolizer;
import org.alov.map.SLD_Symbolizer;
import org.alov.map.SLD_TextSymbolizer;
import org.alov.map.Symbol;
import org.alov.ogcfilter.Filter;
import org.alov.ogcfilter.FilterException;
import org.alov.util.AlovMapException;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

class SLD_Rule
implements SLD_Const {
    String Name = null;
    String Title = null;
    String Abstract = null;
    SLD_Graphic legendGraphic = null;
    Filter filter = null;
    Filter elseFilter = null;
    boolean isElseFilterPresent = false;
    float min_scale = 0.0f;
    float max_scale = 0.0f;
    Vector symbolizers = new Vector();

    SLD_Rule(XmlElement root) throws AlovMapException {
        int i;
        this.Name = XmlUtils.getElString("Name", root, null);
        this.Title = XmlUtils.getElString("Title", root, null);
        this.Abstract = XmlUtils.getElString("Abstract", root, null);
        XmlElement el = root.getFirstElementByName("ElseFilter");
        boolean bl = this.isElseFilterPresent = el != null;
        if (!this.isElseFilterPresent && (el = root.getFirstElementByName("Filter")) != null) {
            try {
                this.filter = new Filter(el);
            }
            catch (FilterException e) {
                throw new AlovMapException(312, e.getMessage());
            }
        }
        this.min_scale = XmlUtils.getElFloat("MinScaleDenominator", root, 0.0f);
        this.max_scale = XmlUtils.getElFloat("MinScaleDenominator", root, 0.0f);
        el = root.getFirstElementByName("LegendGraphic");
        if (el != null) {
            el = root.getFirstElementByName("Graphic");
            if (el != null) {
                this.legendGraphic = new SLD_Graphic(el);
            } else {
                throw new AlovMapException(312, "Graphic element missing");
            }
        }
        Vector v = root.getElementsByTagName("LineSymbolizer");
        for (i = 0; i < v.size(); ++i) {
            el = (XmlElement)v.elementAt(i);
            this.symbolizers.addElement(new SLD_LineSymbolizer(el));
        }
        v = root.getElementsByTagName("PolygonSymbolizer");
        for (i = 0; i < v.size(); ++i) {
            el = (XmlElement)v.elementAt(i);
            this.symbolizers.addElement(new SLD_PolySymbolizer(el));
        }
        v = root.getElementsByTagName("PointSymbolizer");
        for (i = 0; i < v.size(); ++i) {
            el = (XmlElement)v.elementAt(i);
            this.symbolizers.addElement(new SLD_PointSymbolizer(el));
        }
        v = root.getElementsByTagName("TextSymbolizer");
        for (i = 0; i < v.size(); ++i) {
            el = (XmlElement)v.elementAt(i);
            this.symbolizers.addElement(new SLD_TextSymbolizer(el));
        }
    }

    Vector transform(Layer layer) throws AlovMapException {
        Vector<RendererGrad> res = new Vector<RendererGrad>();
        String sFilter = null;
        if (!this.isElseFilterPresent) {
            if (this.filter != null) {
                try {
                    sFilter = this.filter.operation.constructSQL().toString();
                }
                catch (FilterException fe) {
                    throw new AlovMapException(312, fe.getMessage());
                }
            }
        } else if (this.elseFilter != null) {
            try {
                sFilter = this.elseFilter.operation.constructSQL().toString();
                sFilter = "not(" + sFilter + ')';
            }
            catch (FilterException fe) {
                throw new AlovMapException(312, fe.getMessage());
            }
        }
        for (int i = 0; i < this.symbolizers.size(); ++i) {
            Symbol sym;
            Object o = this.symbolizers.elementAt(i);
            Renderer rend = null;
            if (o instanceof SLD_PointSymbolizer || o instanceof SLD_LineSymbolizer || o instanceof SLD_PolySymbolizer) {
                rend = new RendererGrad(layer);
                sym = ((SLD_Symbolizer)o).transform();
                sym.valueStr = sFilter;
                rend.symbolsUnprepared = new Vector();
                rend.symbolsUnprepared.addElement(sym);
            } else if (o instanceof SLD_TextSymbolizer) {
                rend = new RendererLabel(layer);
                ((RendererLabel)rend).labelFieldName = ((SLD_TextSymbolizer)o).label.propertyName;
                sym = ((SLD_Symbolizer)o).transform();
                sym.valueStr = sFilter;
                rend.symbolsUnprepared = new Vector();
                rend.symbolsUnprepared.addElement(sym);
            } else {
                rend = new RendererDef(layer);
            }
            rend.zmin = this.min_scale;
            rend.zmax = this.max_scale;
            rend.label = this.Title;
            rend.name = this.Name + i;
            rend.symbols = null;
            res.addElement((RendererGrad)rend);
        }
        return res;
    }
}

