/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Project;
import org.alov.map.SLD;
import org.alov.map.SLD_Layer;
import org.alov.ogcfilter.Expression;
import org.alov.ogcfilter.FilterException;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlParser;

public class SLD_Loader {
    private static String COMMA = ",";
    private static String EMPTY = "";

    public static boolean containStyle(SLD sld, String layer, String style) {
        for (int i = 0; i < sld.layers.size(); ++i) {
            SLD_Layer l = (SLD_Layer)sld.layers.elementAt(i);
            if (!l.name.equalsIgnoreCase(layer) || l.getStyle(style) == null) continue;
            return true;
        }
        return false;
    }

    public static Vector getStylesTable(String layers, String styles) {
        if (Strings.isNullOrBlank(layers)) {
            return null;
        }
        Vector<String[]> res = new Vector<String[]>();
        StringTokenizer tok = new StringTokenizer(layers, COMMA);
        StringTokenizer tok2 = null;
        if (!Strings.isNullOrBlank(styles)) {
            tok2 = new StringTokenizer(styles, COMMA, true);
        }
        String s2 = EMPTY;
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken().trim();
            if (tok2 != null) {
                if (tok2.hasMoreTokens()) {
                    s2 = tok2.nextToken().trim();
                    if (s2.equals(COMMA)) {
                        s2 = EMPTY;
                    } else if (tok2.hasMoreTokens()) {
                        tok2.nextToken();
                    }
                } else {
                    s2 = EMPTY;
                }
            }
            res.addElement(new String[]{s, s2});
        }
        return res;
    }

    public static String getLayerStyle(String name, Vector stls) {
        for (int i = 0; i < stls.size(); ++i) {
            String[] s = (String[])stls.elementAt(i);
            if (!s[0].equalsIgnoreCase(name)) continue;
            return s[1];
        }
        return null;
    }

    public static void setStyleForProject(Project prj, String sUrl, Vector stls) throws Exception {
        SLD sld = SLD_Loader.getSLD(sUrl);
        sld.transform(prj, stls);
    }

    public static SLD getSLD(String sUrl) throws AlovMapException {
        try {
            XmlElement el = XmlParser.parseXml(new URL(sUrl).openStream());
            return SLD_Loader.getSLD(el);
        }
        catch (Exception e) {
            throw new AlovMapException(312, e.getMessage());
        }
    }

    public static SLD getSLD(XmlElement root) throws AlovMapException {
        return new SLD(root);
    }

    public static Expression loadExpression(String name, XmlElement root) throws AlovMapException {
        Expression expr = null;
        XmlElement el = root.getFirstElementByName(name);
        if (el != null) {
            Vector v = el.getChildren();
            if (v.size() > 0) {
                el = (XmlElement)v.firstElement();
                try {
                    expr = new Expression(el);
                }
                catch (FilterException e) {
                    throw new AlovMapException(312, e.getMessage());
                }
            } else if (!Strings.isNullOrBlank(el.value)) {
                expr = new Expression(6);
                expr.literal = el.value;
            } else {
                throw new AlovMapException(312, "Invalid expression.");
            }
        }
        return expr;
    }

    public static String loadGeometry(XmlElement root) throws AlovMapException {
        Expression expr = SLD_Loader.loadExpression("Geometry", root);
        if (expr != null && !Strings.isNullOrBlank(expr.propertyName)) {
            return expr.propertyName;
        }
        return null;
    }
}

