/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.util.Vector;
import org.alov.map.Layer;
import org.alov.map.Project;
import org.alov.map.SLD_Const;
import org.alov.map.SLD_Layer;
import org.alov.map.SLD_Loader;
import org.alov.util.AlovMapException;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class SLD
implements SLD_Const {
    String Name = null;
    String Title = null;
    String Abstract = null;
    Vector layers = new Vector();

    SLD(XmlElement root) throws AlovMapException {
        if (!root.getNodeName().equalsIgnoreCase("StyledLayerDescriptor")) {
            throw new AlovMapException(312, "Invalid file type: root element must be StyledLayerDescriptor");
        }
        String s = XmlUtils.getString("version", root, "1.0.0");
        if (!s.equalsIgnoreCase("1.0.0")) {
            throw new AlovMapException(312, "Invalid version. Version 1.0.0 only supported");
        }
        this.Name = XmlUtils.getElString("Name", root, null);
        this.Title = XmlUtils.getElString("Title", root, null);
        this.Abstract = XmlUtils.getElString("Abstract", root, null);
        Vector v = root.getElementsByTagName("NamedLayer");
        for (int i = 0; i < v.size(); ++i) {
            XmlElement el = (XmlElement)v.elementAt(i);
            this.layers.addElement(new SLD_Layer(el));
        }
    }

    public void transform(Project prj, Vector stls) throws AlovMapException {
        int i;
        prj.name = this.Title;
        for (i = 0; i < this.layers.size(); ++i) {
            SLD_Layer layer = (SLD_Layer)this.layers.elementAt(i);
            String s = SLD_Loader.getLayerStyle(layer.name, stls);
            layer.transform(prj, s);
        }
        for (i = 0; i < prj.layers.size(); ++i) {
            Layer l = (Layer)prj.layers.elementAt(i);
            if (l.notPrepared) {
                l.prepareLayer();
            }
            if (SLD_Loader.getLayerStyle(l.getName(), stls) != null) continue;
            l.setVisible(false);
            l.legendVisible = false;
        }
    }
}

