/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import org.alov.map.DisplayContext;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;

public class RendererImage
extends Renderer {
    public RendererImage(Layer l) {
        super(l);
    }

    public void paintRecord(Record rec, boolean selected, DisplayContext dc) {
        LayerRaster layer = (LayerRaster)this.layer;
        Image image = layer.getImage();
        if (image != null) {
            if (layer.fixedPosition != null) {
                Graphics drawTo = dc.getDrawToGraphics();
                if (drawTo == null) {
                    return;
                }
                drawTo.drawImage(image, layer.fixedPosition.x, layer.fixedPosition.y, dc.getComponent());
            } else {
                RendererImage.drawImage(image, layer.getLayerExtent(), dc);
            }
        }
    }

    public static boolean calculateImageCoords(Dimension imageSize, Rectangle src, Rectangle dst, FloatRectangle imageLocation, DisplayContext dc) {
        boolean result = false;
        Graphics drawTo = dc.getDrawToGraphics();
        FloatRectangle viewExtent = dc.getLastExtent();
        if (imageSize.width > 0 && imageSize.height > 0 && drawTo != null && viewExtent != null) {
            double reqX1 = viewExtent.x;
            double reqY1 = viewExtent.y2;
            double reqX2 = viewExtent.x2;
            double reqY2 = viewExtent.y;
            double imgX1 = imageLocation.x;
            double imgY1 = imageLocation.y2;
            double imgX2 = imageLocation.x2;
            double imgY2 = imageLocation.y;
            double scaleW = (imgX2 - imgX1) / (1.0 * (double)imageSize.width);
            double scaleH = (imgY1 - imgY2) / (1.0 * (double)imageSize.height);
            if (reqX1 <= imgX2 && reqX2 >= imgX1 && reqY1 >= imgY2 && reqY2 <= imgY1) {
                reqX1 = Math.max(reqX1, imgX1);
                reqX2 = Math.min(reqX2, imgX2);
                reqY1 = Math.min(reqY1, imgY1);
                reqY2 = Math.max(reqY2, imgY2);
                int sx1 = Math.max(0, (int)Math.floor((reqX1 - imgX1) / scaleW - 0.0));
                int sy1 = Math.max(0, (int)Math.floor((imgY1 - reqY1) / scaleH - 0.0));
                int sx2 = Math.min(imageSize.width, (int)Math.ceil((reqX2 - imgX1) / scaleW + 1.0));
                int sy2 = Math.min(imageSize.height, (int)Math.ceil((imgY1 - reqY2) / scaleH + 1.0));
                reqX1 = imgX1 + (double)sx1 * scaleW;
                reqX2 = imgX1 + (double)sx2 * scaleW;
                reqY1 = imgY1 - (double)sy1 * scaleH;
                reqY2 = imgY1 - (double)sy2 * scaleH;
                Projection prj = dc.getProjection();
                double zoom = prj.zoom;
                double shiftX = prj.shift.x;
                double shiftY = prj.shift.y;
                int dx1 = (int)((reqX1 + shiftX) * zoom);
                int dx2 = (int)((reqX2 + shiftX) * zoom);
                int dy1 = (int)((shiftY - reqY1) * zoom);
                int dy2 = (int)((shiftY - reqY2) * zoom);
                src.x = sx1;
                src.y = sy1;
                src.width = sx2 - sx1;
                src.height = sy2 - sy1;
                dst.x = dx1;
                dst.y = dy1;
                dst.width = dx2 - dx1;
                dst.height = dy2 - dy1;
                result = src.width * src.height > 0 && dst.width * dst.height > 0;
            }
        }
        return result;
    }

    public static void drawImage(Image image, FloatRectangle imageLocation, DisplayContext dc) {
        Dimension imageSize;
        boolean draw;
        Rectangle src = new Rectangle();
        Rectangle dst = new Rectangle();
        if (image != null && (draw = RendererImage.calculateImageCoords(imageSize = new Dimension(image.getWidth(dc.getComponent()), image.getHeight(dc.getComponent())), src, dst, imageLocation, dc))) {
            dc.getDrawToGraphics().drawImage(image, dst.x, dst.y, dst.x + dst.width, dst.y + dst.height, src.x, src.y, src.x + src.width, src.y + src.height, dc.getComponent());
        }
    }
}

