/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import org.alov.data.SQLConst;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FloatPoint;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.util.AlovMapException;

public class RendererChart
extends Renderer {
    public static final int CHART_PIE = 1;
    public static final int CHART_BAR = 2;
    public int type;
    public FieldDef[] fields;
    public Vector fieldsUnprepared = null;
    public Color outlineColor;
    public float normalization = 0.0f;
    public String normFieldName;
    int normField;
    public int minSize;
    public int maxSize;
    public String sizeFieldName;
    int sizeField;
    public int width;
    public int height;
    public float nullValue = Float.NaN;
    private double[] values;
    private static final int startAngle = 90;
    private static final int deltaAngle = 270;
    private static final int radius = 8;
    private static final int dx1 = (int)(8.0 * Math.cos(1.5707963267948966));
    private static final int dy1 = (int)(8.0 * Math.sin(1.5707963267948966));
    private static final int dx2 = (int)(8.0 * Math.cos(Math.PI * 2));
    private static final int dy2 = (int)(8.0 * Math.sin(Math.PI * 2));

    public RendererChart(Layer lyr) {
        super(lyr);
    }

    int getLevel() {
        return 100 * (this.layer.drawOrder + 1) + 50;
    }

    public void paintRecord(Record rec, boolean selected, DisplayContext dc) {
        Object sym = null;
        Projection projection = dc.getProjection();
        Graphics g = dc.getDrawToGraphics();
        double[] vals = this.values;
        double sum = 0.0;
        int count = this.fields.length;
        double f = 0.0;
        FloatPoint shift = projection.shift;
        double zoom = projection.zoom;
        FloatPoint centre = rec.getRecordExtent().getCentre();
        int x = (int)((centre.x + shift.x) * zoom);
        int y = (int)((-centre.y + shift.y) * zoom);
        if (this.type == 1) {
            int w;
            for (int i = 0; i < count; ++i) {
                f = this.layer.getFieldDouble(rec, this.fields[i].index);
                if (f == (double)this.nullValue) {
                    return;
                }
                double af = Math.abs(f);
                sum += af;
                vals[i] = af;
            }
            Object sizeFieldValue = this.layer.getFieldValue(rec, this.sizeField);
            if (sizeFieldValue != null) {
                w = ((Number)sizeFieldValue).intValue();
                FieldDef fd = this.layer.getFieldDef(this.sizeField);
                if (fd.maxvalue > (double)this.maxSize || fd.minvalue < (double)this.minSize) {
                    double f1 = (fd.maxvalue - fd.minvalue) / (double)((float)(this.maxSize - this.minSize) * 1.0f);
                    w = (int)((double)w / f1);
                }
                if (this.minSize > 0 || this.maxSize > 0) {
                    if (w < this.minSize) {
                        w = this.minSize;
                    } else if (w > this.maxSize) {
                        w = this.maxSize;
                    }
                }
            } else {
                w = this.maxSize;
            }
            int h = w;
            int minAngle = w > h ? (int)(Math.atan(12.0 / (double)w) / Math.PI * 180.0) : (int)(Math.atan(12.0 / (double)h) / Math.PI * 180.0);
            int cx = x;
            int cy = y;
            int w2 = w / 2;
            int h2 = h / 2;
            x -= w2;
            y -= h2;
            double angle = 0.0;
            int[] xCoords = new int[3];
            int[] yCoords = new int[3];
            xCoords[0] = cx;
            yCoords[0] = cy;
            for (int i = 0; i < count; ++i) {
                angle = vals[i] / sum * 360.0;
                g.setColor(this.fields[i].color);
                int a1 = (int)f;
                int da = (int)angle;
                if (da >= minAngle) {
                    g.fillArc(x, y, w, h, a1, da + 5);
                    f += angle;
                    continue;
                }
                double angle1 = -f / 180.0 * Math.PI;
                int pt1x = cx + (int)Math.round(Math.cos(angle1) * (double)w2);
                int pt1y = cy + (int)Math.round(Math.sin(angle1) * (double)h2);
                double angle2 = -(f + angle * 1.1) / 180.0 * Math.PI;
                int pt2x = cx + (int)Math.round(Math.cos(angle2) * (double)w2);
                int pt2y = cy + (int)Math.round(Math.sin(angle2) * (double)h2);
                xCoords[1] = pt1x;
                yCoords[1] = pt1y;
                xCoords[2] = pt2x;
                yCoords[2] = pt2y;
                g.fillPolygon(xCoords, yCoords, 3);
                f += angle;
            }
            if (this.outlineColor != null && f > 0.0) {
                g.setColor(this.outlineColor);
                g.drawOval(x, y, w, h);
            }
        } else {
            int colWidth = this.width / count;
            if (colWidth < 2) {
                colWidth = 2;
            }
            int w = colWidth * count;
            int h = this.height;
            x -= w / 2;
            double minv = Double.POSITIVE_INFINITY;
            double maxv = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < count; ++i) {
                vals[i] = this.layer.getFieldDouble(rec, this.fields[i].index);
                if (vals[i] == (double)this.nullValue) {
                    return;
                }
                FieldDef fd = this.layer.getFieldDef_(this.fields[i].index);
                if (minv > fd.minvalue) {
                    minv = fd.minvalue;
                }
                if (!(maxv < fd.maxvalue)) continue;
                maxv = fd.maxvalue;
            }
            double factor = 1.0;
            if (Math.abs(maxv) > (double)this.height || Math.abs(minv) < 2.0) {
                factor = (maxv - minv) / (double)((float)(this.height - 2) * 1.0f);
            }
            int cx = x;
            int i = 0;
            while (i < count) {
                g.setColor(this.fields[i].color);
                int colHeight = (int)(vals[i] / factor);
                g.fillRect(cx, y - colHeight, colWidth, colHeight);
                if (this.outlineColor != null) {
                    g.setColor(this.outlineColor);
                    g.drawRect(cx, y - colHeight, colWidth, colHeight);
                }
                ++i;
                cx += colWidth;
            }
        }
    }

    public void paintSampleChart(Graphics g, Rectangle rect) {
        Color clr = g.getColor();
        int fontHeight = MapUtils.getCurrentFontHeight(g);
        int count = this.fields.length;
        int rad = 8;
        int x = rect.x + 10 - rad;
        for (int i = 0; i < count; ++i) {
            FieldDef fi = this.fields[i];
            g.setColor(fi.color);
            if (this.type == 1) {
                int y = rect.y + 20 * i + 10 - rad;
                g.fillArc(x, y, rad * 2, rad * 2, 90, 270);
                g.setColor(Color.black);
                g.drawArc(x, y, rad * 2, rad * 2, 90, 270);
                g.drawLine(x + 8, y + 8, x + 8 + dx1, y + 8 - dy1);
                g.drawLine(x + 8, y + 8, x + 8 + dx2, y + 8 - dy2);
            } else {
                int x2 = rect.x + 10 - 3;
                int y = rect.y + 20 * i + 10 - 6;
                g.fillRect(x2, y, 6, 12);
                g.setColor(clr);
                g.drawRect(x2, y, 6, 12);
            }
            String s = fi.label;
            if (s == null) {
                s = this.layer.getFieldDef((int)this.fields[i].index).name;
            }
            g.drawString(s, rect.x + 30, rect.y + 10 + fontHeight / 2 + 20 * i);
        }
    }

    protected void prepare() throws Exception {
        FieldDef fi;
        int i;
        FieldDef def;
        if (this.height < 5) {
            this.height = 50;
        }
        if (this.width == 0) {
            this.width = 25;
        }
        if (this.minSize < 8) {
            this.minSize = 8;
        }
        if (this.maxSize < 8) {
            this.maxSize = 50;
        }
        if (this.maxSize <= this.minSize) {
            this.minSize = this.maxSize - 2;
        }
        this.sizeField = (def = this.layer.getFieldDef_(this.layer.getFieldIndex(this.sizeFieldName))) != null && SQLConst.isNumber(def.type) ? def.index : -1;
        def = this.layer.getFieldDef_(this.layer.getFieldIndex(this.normFieldName));
        int n = this.normField = def != null && SQLConst.isNumber(def.type) ? def.index : -1;
        if (this.fieldsUnprepared == null) {
            return;
        }
        int count = this.fieldsUnprepared.size();
        int k = 0;
        for (i = 0; i < count; ++i) {
            fi = (FieldDef)this.fieldsUnprepared.elementAt(i);
            def = this.layer.getFieldDef_(this.layer.getFieldIndex(fi.name));
            if (def != null && SQLConst.isNumber(def.type)) {
                fi.index = def.index;
                ++k;
                continue;
            }
            fi.index = -1;
            throw new AlovMapException("  Renderer: " + this.name + "  " + fi.name);
        }
        if (k > 0) {
            this.fields = new FieldDef[k];
            this.values = new double[k];
            k = 0;
            for (i = 0; i < count; ++i) {
                fi = (FieldDef)this.fieldsUnprepared.elementAt(i);
                if (fi.index < 0) continue;
                this.fields[k] = fi;
                ++k;
            }
        }
        this.fieldsUnprepared.removeAllElements();
        this.fieldsUnprepared = null;
        this.isPrepared = this.fields.length > 0;
    }
}

