/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.alov.map.FloatRectangle;
import org.alov.map.MapUtils;
import org.alov.map.MetaElement;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class Meta
extends Vector {
    public static final int MD_TITLE = 8;
    public static final int MD_AUTHOR = 41;
    public static final int MD_DESCRIPTION = 11;
    public static final int MD_RIGHTS = 24;
    public static final int MD_LAYER_TYPE = 34;
    public static final int MD_OBJECT_TYPE = 36;
    public static final int MD_TABLENAME = 43;
    public static final int MD_F_ID = 49;
    public static final int MD_F_FEATURE_ID = 50;
    public static final int MD_F_DESCRIPTION = 51;
    public static final int MD_F_DATE = 52;
    public static final int MD_F_DATE_LOW = 53;
    public static final int MD_F_DATE_HIGH = 54;
    public static final int MD_F_XMIN = 70;
    public static final int MD_F_XMAX = 71;
    public static final int MD_F_YMIN = 72;
    public static final int MD_F_YMAX = 73;
    public static final int MD_F_GEOBLOB = 74;
    public static final int MD_F_X = 75;
    public static final int MD_F_Y = 76;
    public static final int MD_F_LOAD = 80;
    public static final int MD_DEF_SYMBOLOGY = 125;
    public static final int MD_MAINLINK = 63;
    public static final int MD_SEARCHLINK = 301;
    public static final int MD_INFOLINK = 302;
    public static final int MD_TIPSLINK = 310;
    public static final int MD_F_ALIASES_TM = 57;
    public static final int MD_F_ALIASES = 304;
    public static final int MD_DB_ENCODING = 305;
    public static final int MD_TABLENAME_XY = 306;
    public static final int MD_F_VISIBLE = 307;
    public static final int MD_F_VERTEXORDER = 308;
    public static final int MD_VIRTUAL_FIELD = 309;
    public static final int MD_IMAGEPATH = 310;
    public static final int MD_F_EDITABLE = 312;
    public static final int MD_GEOFORMAT = 313;
    public static final int MD_DATE_TYPE = 37;
    public static final int MD_XMIN = 4;
    public static final int MD_XMAX = 5;
    public static final int MD_YMIN = 6;
    public static final int MD_YMAX = 7;
    public static final int MD_THUMBNAIL_FILE = 119;
    public static final int MD_DOC_FILE = 120;
    public static final int MD_SAMPLE_FILE = 121;
    public static final int MD_SYSTEMID = 133;
    public static final int MD_SYSTEREGDATE = 127;
    public static final int MD_IMAGEFILE = 123;
    public static final int MD_IMAGE_SCRN_X = 138;
    public static final int MD_IMAGE_SCRN_Y = 139;
    public static final int MD_IMAGE_X = 142;
    public static final int MD_IMAGE_Y = 143;
    public static final int MD_IMAGE_SX = 144;
    public static final int MD_IMAGE_SY = 145;
    public static final int MD_IMAGE_WIDTH = 146;
    public static final int MD_IMAGE_HEIGHT = 147;
    public static final int MD_MAX_RESOLUTION_LEVEL = 148;
    public static final int MD_BASE_SQL_FILTER = 149;
    public static final int MD_SQL_FILTER = 150;
    public static final int MD_SRS = 162;
    public static final int MD_WMS_LAYERS = 166;
    public static final int MD_WMS_STYLES = 167;
    public static final int MD_WMS_EXTRA = 311;
    public static final int MD_SRV_DRIVER = 168;
    public static final int MD_SRV_HOST = 169;
    public static final int MD_SRV_DATABASE = 170;
    public static final int MD_SRV_PATH = 171;
    public static final int MD_SRV_URL = 172;
    public static final int MD_SRV_PORT = 173;
    public static final int MD_SRV_USER = 174;
    public static final int MD_SRV_PASS = 175;
    public static final int MD_SRV_SCRIPT = 176;
    public static final int MD_SRV_VERSION = 177;
    public static final int MD_SRV_FORMAT = 178;
    public static final int MD_SRV_OPSYS = 179;
    public static final int MD_SRV_SID_CLIENT = 180;
    public static final int MD_SRV_SID_IMAGE = 181;
    public static final int MD_AUTH_PASSWORD = 303;
    public static final int MD_CITY = 315;
    public static final int MD_CITY_LAYER = 316;
    public static final int MD_FILTER_REQUIRED = 317;
    public static final int MD_GEOCODING_TYPE = 318;
    public static final int MD_GEOCODING_FLDS = 319;
    public boolean isNotLoaded = true;
    boolean isLoaded = false;
    public boolean forceEmptyLoad = false;
    public boolean forceLoad = false;
    public int reloadTimeRange = 0;
    public boolean forceClearCache = true;
    public boolean loadFailed = false;
    public boolean networkActivity = false;
    boolean passResolved = true;
    public boolean passFirstTime = true;
    public FloatRectangle maxExtent = new FloatRectangle();
    public int memsize = 0;
    public int cachesize = 0;

    public String getVal(int id) {
        return this.getVal(id, MapUtils.language);
    }

    public String getVal(int id, String language) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            MetaElement me = (MetaElement)this.elementAt(i);
            if (me.id != id || me.lang != null && !me.lang.equalsIgnoreCase(language)) continue;
            return me.value;
        }
        return null;
    }

    public double getDouble(int id) {
        return MapUtils.toDouble(this.getVal(id, MapUtils.language));
    }

    public void delElement(int id) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (((MetaElement)this.elementAt((int)i)).id != id) continue;
            this.removeElementAt(i);
            break;
        }
    }

    public void replace(int id, String val) {
        this.delElement(id);
        this.put(id, val);
    }

    public String getHtmlStr(int id) {
        String s = this.getVal(id, null);
        if (s == null) {
            return "";
        }
        s = Strings.setObj(s, '&', "&amp;");
        s = Strings.setObj(s, '<', "&lt;");
        return Strings.setObj(s, '>', "&gt;");
    }

    public String getStr(int id) {
        String s = this.getVal(id, null);
        return s == null ? "" : s;
    }

    public Vector getList(int id) {
        int n = this.size();
        Vector<String> res = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            if (((MetaElement)this.elementAt((int)i)).id != id) continue;
            res.addElement(((MetaElement)this.elementAt((int)i)).value);
        }
        return res;
    }

    void put_(int id, int scheme_id, String scheme, String val, String lang) {
        if (val != null) {
            MetaElement me = new MetaElement();
            me.id = id;
            me.scheme = scheme;
            me.scheme_id = scheme_id;
            me.value = val.trim();
            me.lang = lang;
            this.addElement(me);
        }
    }

    public void put(int id, String val) {
        this.put_(id, 0, null, val, null);
    }

    public void loadWorldfile(InputStream is) throws Exception {
        String lineStr;
        this.delElement(144);
        this.delElement(145);
        this.delElement(142);
        this.delElement(143);
        InputStreamReader isReader = new InputStreamReader(is);
        BufferedReader reader = new BufferedReader(isReader, 2048);
        int k = 0;
        int iLine = 0;
        while ((lineStr = reader.readLine()) != null) {
            ++iLine;
            if (lineStr.length() <= 0) continue;
            try {
                Double.valueOf(lineStr).doubleValue();
            }
            catch (Exception ex) {
                throw new AlovMapException(301, "Content of line#" + iLine + ": '" + lineStr + "' is inconsistent with ESRI Worldfile");
            }
            switch (k) {
                case 0: {
                    this.put(144, lineStr);
                    break;
                }
                case 3: {
                    this.put(145, lineStr);
                    break;
                }
                case 4: {
                    this.put(142, lineStr);
                    break;
                }
                case 5: {
                    this.put(143, lineStr);
                }
            }
            if (++k != 6) continue;
        }
        if (k < 6) {
            throw new AlovMapException(301, "Invalid Worldfile");
        }
        this.isNotLoaded = false;
    }

    public void loadMetadata(InputStream is) throws Exception {
        XmlElement root = XmlUtils.parseStream(is, "");
        this.loadMetadata(root);
    }

    public void loadMetadata(XmlElement root) {
        this.removeAllElements();
        Vector nodes = root.getElementsByTagName("meta");
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            XmlElement el = (XmlElement)nodes.elementAt(i);
            int id = XmlUtils.getInt("id", el, 0);
            if (id == 0) {
                id = XmlUtils.getInt("tmcode", el, 0);
            }
            String val = XmlUtils.getString("content", el, "");
            String sLang = el.getAttributeValue("xml:lang");
            this.put_(id, XmlUtils.getInt("schemecode", el, 0), XmlUtils.getString("scheme", el, null), val, sLang);
        }
        this.isNotLoaded = this.size() == 0;
    }

    public void loadMetadata3(XmlElement root) {
        this.removeAllElements();
        Vector nodes = root.getElementsByTagName("MetadataElement");
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            XmlElement el = (XmlElement)nodes.elementAt(i);
            int id = XmlUtils.getElInt("id", el, 0);
            if (id == 0) {
                id = XmlUtils.getElInt("tmcode", el, 0);
            }
            String val = XmlUtils.getElString("Contains", el, "");
            String sLang = el.getAttributeValue("xml:lang");
            this.put_(id, XmlUtils.getInt("schemecode", el, 0), XmlUtils.getString("scheme", el, null), val, sLang);
        }
        this.isNotLoaded = this.size() == 0;
    }

    public String getFieldAlias(String sFieldName, String language) {
        if (language != null) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                MetaElement me = (MetaElement)this.elementAt(i);
                if (me.id != 304 && me.id != 57 || me.lang != null && !language.equalsIgnoreCase(me.lang) || me.value == null || !me.value.toUpperCase().startsWith(sFieldName + '=')) continue;
                return me.value.substring(me.value.indexOf("=") + 1);
            }
        }
        return sFieldName;
    }

    public int getObjType() {
        return Meta.getObjType(this.getVal(36));
    }

    public static int getObjType(String val) {
        int objectType;
        String OBJ_VAL_POINT = "point";
        String OBJ_VAL_LINE = "line";
        String OBJ_VAL_POLYGON = "polygon";
        String OBJ_VAL_BOUNDBOX = "BoundingBox";
        if (val == null) {
            return 0;
        }
        try {
            objectType = Integer.parseInt(val);
        }
        catch (Exception e) {
            objectType = val.equalsIgnoreCase("point") ? 1 : (val.equalsIgnoreCase("line") ? 2 : (val.equalsIgnoreCase("polygon") ? 3 : (val.equalsIgnoreCase("BoundingBox") ? 4 : 0)));
        }
        return objectType;
    }

    public static int getSrvId(String srvType) {
        if (srvType == null) {
            return -1;
        }
        if (srvType.equalsIgnoreCase("odbc")) {
            return 0;
        }
        if (srvType.equalsIgnoreCase("mysql")) {
            return 1;
        }
        if (srvType.equalsIgnoreCase("interbase") || srvType.equalsIgnoreCase("intrbase")) {
            return 2;
        }
        if (srvType.equalsIgnoreCase("sybase")) {
            return 3;
        }
        if (srvType.equalsIgnoreCase("mssql") || srvType.equalsIgnoreCase("ms sql")) {
            return 4;
        }
        if (srvType.equalsIgnoreCase("oracle")) {
            return 5;
        }
        if (srvType.equalsIgnoreCase("informix")) {
            return 6;
        }
        if (srvType.equalsIgnoreCase("db2")) {
            return 7;
        }
        if (srvType.equalsIgnoreCase("shapefile")) {
            return 8;
        }
        if (srvType.equalsIgnoreCase("imagefile") || srvType.equalsIgnoreCase("localfile")) {
            return 9;
        }
        if (srvType.equalsIgnoreCase("mrsid")) {
            return 11;
        }
        if (srvType.equalsIgnoreCase("mrsides")) {
            return 34;
        }
        if (srvType.equalsIgnoreCase("ogcwms")) {
            return 15;
        }
        if (srvType.equalsIgnoreCase("ogcwfs")) {
            return 35;
        }
        if (srvType.equalsIgnoreCase("mapspace_internal")) {
            return 19;
        }
        if (srvType.equalsIgnoreCase("mapspace")) {
            return 20;
        }
        if (srvType.equalsIgnoreCase("macnet")) {
            return 23;
        }
        if (srvType.equalsIgnoreCase("ms access")) {
            return 30;
        }
        if (srvType.equalsIgnoreCase("hypersonic")) {
            return 31;
        }
        if (srvType.equalsIgnoreCase("sapdb") || srvType.equalsIgnoreCase("sap db")) {
            return 32;
        }
        if (srvType.equalsIgnoreCase("postgresql")) {
            return 33;
        }
        return Strings.strToInt(srvType, -1);
    }
}

