/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Domain;
import org.alov.map.FieldDef;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerSetup;
import org.alov.map.LayerVector;
import org.alov.map.Loader;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.Renderer;
import org.alov.map.RendererChart;
import org.alov.map.RendererGrad;
import org.alov.map.RendererLabel;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.util.AlovMapException;
import org.alov.util.Const;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.XmlConst;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

class LoaderTM
implements Const,
XmlConst {
    static final String _TPR_PROJECT = "MAPSPACE";
    static final String _TPR_PRJNAME = "PROJNAME";
    static final String _TPR_MINZOOM = "MINIMUMZOOM";
    static final String _TPR_CLR_MAPBACK = "CLRMAPBACKGROUD";
    static final String _COORDSYS_LATLONG = "Latitude/Longtude";
    static final String _TPR_COORDSYS = "COORDSYS";
    static final String _TPR_ZOOMBEYOUND = "ZOOMBEYOUNDDOMAIN";
    static final String _TPR_DOMAIN = "DOMAIN";
    static final String _TPR_DOMAINNAME = "DOMAINNAME";
    static final String _TPR_DOMAINMINX = "DOMAINMINX";
    static final String _TPR_DOMAINMAXX = "DOMAINMAXX";
    static final String _TPR_DOMAINMINY = "DOMAINMINY";
    static final String _TPR_DOMAINMAXY = "DOMAINMAXY";
    static final String _TPR_USETIMESCALE = "USETIMESCALE";
    static final String _TPR_DOMAINSTARTT = "DOMAINSTARTT";
    static final String _TPR_DOMAINENDT = "DOMAINENDT";
    static final String _TPR_DATASET = "DATASET";
    static final String _TPR_PATH = "PATH";
    static final String _TPR_ECAI_ID = "ECAI_ID";
    static final String _TPR_LAYER = "LAYER";
    static final String _TPR_KEYMAP = "KEYMAP";
    static final String _TPR_LayerTitle = "LayerTitle";
    static final String _TPR_ZoomMin = "ZoomMin";
    static final String _TPR_ZoomMax = "ZoomMax";
    static final String _TPR_WithinZoom = "WithinZoom";
    static final String _TPR_WithinDate = "WithinDate";
    static final String _TPR_DateMin = "DateMin";
    static final String _TPR_DateMax = "DateMax";
    static final String _TPR_TimeVarying = "TimeVarying";
    static final String _TPR_LayerVisible = "LayerVisible";
    static final String _TPR_LayerAlwaysVisible = "LayerAlwaysVisible";
    static final String _TPR_ItemVisible = "ItemVisible";
    static final String _TPR_ItemExpanded = "ItemExpanded";
    static final String _TPR_HIDELEGENDOUTOFRANGE = "HideLegendOutOfRange";
    static final String _TPR_HIDELEGENDOUTOFEXTENT = "HideLegendOutOfExtent";
    static final String _TPR_CANSEARCH = "CanSearch";
    static final String _TPR_DRAWORDER = "DRAWORDER";
    static final String _TPR_UseDefault = "UseDefault";
    static final String _TPR_Default = "Default";
    static final String sLegendLabel4Image = "LegendLabel4Image";
    static final String _TPR_WHERE = "SQLWhere";
    static final String _TPR_RENDERER = "RENDERER";
    static final String _TPR_RendType = "RendererType";
    static final int ltGraduatedColor = 1;
    static final int ltUniqueValues = 2;
    static final int ltLabel = 4;
    static final int ltChart = 5;
    static final String sRendHeader = "RendererHeaderInLegend";
    static final String sRendEnabled = "RendererEnabled";
    static final String sBarHeight = "BarHeight";
    static final String sBarWidth = "BarWidth";
    static final String sChartType = "ChartType";
    static final String sMaxPieSize = "MaxPieSize";
    static final String sMinPieSize = "MinPieSize";
    static final String sShowOutline = "ShowOutline";
    static final String sSizeField = "SizeField";
    static final String _TPR_FIELD = "FIELD";
    static final String sField = "Field";
    static final String sColor = "Color";
    static final String sDrawBackground = "DrawBackground";
    static final String sSymbolField = "SymbolField";
    static final String _TPR_SYMBOL = "SYMBOL";
    static final String _TPR_SELSYMBOL = "SELSYMBOL";
    static final String sSymType = "Type";
    static final String sSymValue = "Value";
    static final String sSymValueStr = "ValueStr";
    static final String sSymSize = "Size";
    static final String sSymColor = "Color";
    static final String sSymOutline = "Outline";
    static final String sOutlineColor = "OutlineColor";
    static final String sSymStyle = "Style";
    static final String sSymCustomStyleFile = "CustomStyle";
    static final String sSymFont = "Font";
    static final String sFontStyle = "FontStyle";
    static final String sRemark = "Remark";
    static final String sLegShow = "LegShow";
    static LayerSetup layerSetup;

    private LoaderTM() {
    }

    static void parseProject(Project prj, XmlElement root, LayerSetup lyrSetup) throws Exception {
        int count2;
        int count;
        Vector nodes;
        layerSetup = lyrSetup;
        if (root == null || !root.getNodeName().equalsIgnoreCase(_TPR_PROJECT)) {
            layerSetup.addStatusInfo(101, null, null);
            throw new AlovMapException(101, null);
        }
        boolean isDynAdd = XmlUtils.getBoolean("dynamic", root, false);
        if (!isDynAdd) {
            XmlElement el;
            int i;
            prj.name = XmlUtils.getString(_TPR_PRJNAME, root, "unnamed");
            prj.zmin = XmlUtils.getFloat(_TPR_MINZOOM, root, -1.0f);
            prj.zmax = -1.0;
            prj.mapBackground = XmlUtils.getColor(_TPR_CLR_MAPBACK, root, Color.white);
            prj.linkMain = root.getElValue("linkmask", null);
            prj.linkSearch = root.getElValue("searchlink", null);
            prj.linkInfo = root.getElValue("infolink", null);
            String Coord_sys = XmlUtils.getString(_TPR_COORDSYS, root, _COORDSYS_LATLONG);
            prj.MapUnits = Coord_sys.equalsIgnoreCase(_COORDSYS_LATLONG) ? 0 : 1;
            prj.ZoomUnits = 2;
            prj.moveBeyondProject = XmlUtils.getBoolean(_TPR_ZOOMBEYOUND, root, false);
            prj.isTimeEnabled = XmlUtils.getBoolean(_TPR_USETIMESCALE, root, false);
            nodes = root.getElementsByTagName(_TPR_DOMAIN);
            count = nodes.size();
            String maxExtentName = "full";
            for (i = 0; i < count; ++i) {
                el = (XmlElement)nodes.elementAt(i);
                FloatRectangle ext = new FloatRectangle(XmlUtils.getFloat(_TPR_DOMAINMINX, el, 0.0f), XmlUtils.getFloat(_TPR_DOMAINMINY, el, 0.0f), XmlUtils.getFloat(_TPR_DOMAINMAXX, el, 0.0f), XmlUtils.getFloat(_TPR_DOMAINMAXY, el, 0.0f));
                if (ext.x == 0.0 && ext.y == 0.0 && ext.x2 == 0.0 && ext.y2 == 0.0) {
                    ext = null;
                }
                String nom = XmlUtils.getString(_TPR_DOMAINNAME, el, "unnamed");
                if (ext != null && ext.x < ext.x2 && ext.y < ext.y2) {
                    Domain domain = new Domain();
                    domain.ext = ext;
                    domain.minDate = ExDate.parseString(XmlUtils.getString(_TPR_DOMAINSTARTT, el, "0"));
                    domain.maxDate = ExDate.parseString(XmlUtils.getString(_TPR_DOMAINENDT, el, "2002"));
                    if (prj.isTimeEnabled && i == 0) {
                        prj.startDate = domain.minDate;
                        prj.endDate = domain.maxDate;
                    }
                    prj.domains.put(nom, domain);
                    prj.domainsNames = prj.domainsNames + nom + "\n\r";
                    if (i == 0) {
                        prj.maxExtent = ext;
                        maxExtentName = nom;
                        continue;
                    }
                    if (i != 1) continue;
                    prj.startExtentName = nom;
                    continue;
                }
                layerSetup.addStatusInfo(102, null, nom);
            }
            if (prj.maxExtent == null) {
                prj.maxExtent = new FloatRectangle(0.0, 0.0, 0.0, 0.0);
                Domain domain = new Domain();
                domain.ext = prj.maxExtent;
                domain.minDate = new ExDate(0.0);
                domain.maxDate = new ExDate(2002L, 1L, 1L);
                prj.domains.put("full", domain);
                prj.domainsNames = prj.domainsNames + "full\n\r";
                prj.startDate = domain.minDate;
                prj.endDate = domain.maxDate;
            }
            if (prj.startExtentName == null) {
                prj.startExtentName = maxExtentName;
            }
            nodes = root.getElementsByTagName("map");
            count = nodes.size();
            for (i = 0; i < count; ++i) {
                el = (XmlElement)nodes.elementAt(i);
                String theme_id = XmlUtils.getString("index", el, null);
                String theme_name = XmlUtils.getString("name", el, "unnamed");
                if (theme_id != null) {
                    prj.themes.put(theme_name, theme_id);
                    prj.themesNames = prj.themesNames + theme_name + "\n\r";
                    if (i != 0 && !XmlUtils.getBoolean("startup", el, false)) continue;
                    prj.startTheme = theme_name;
                    continue;
                }
                layerSetup.addStatusInfo(103, null, theme_name);
            }
            if (prj.themes.size() == 0) {
                prj.themes.put("unnamed", "0");
                prj.startTheme = "unnamed";
                prj.themesNames = "unnamed\n\r";
            }
            prj.keyMapBackground = XmlUtils.getColor("CLRKEYMAPBACKGROUD", root, prj.mapBackground);
            prj.keyMapOutline = XmlUtils.getColor("CLRKEYMAPBOX", root, Color.red);
            prj.keyMapTheme = null;
            XmlElement el2 = root.getFirstElementByName("dynamic");
            boolean bl = prj.isDynamic = el2 != null;
            if (prj.isDynamic) {
                prj.isDynamic_LayerVisible = XmlUtils.getBoolean(_TPR_LayerVisible, el2, true);
                prj.isDynamic_RemoveOutOfExtent = !XmlUtils.getBoolean("retain", el2, false);
                prj.iDynamic_OrderOfLayers = XmlUtils.getInt(_TPR_DRAWORDER, el2, 0);
                nodes = el2.getElementsByTagName("meta");
                count = nodes.size();
                for (int i2 = 0; i2 < count; ++i2) {
                    el2 = (XmlElement)nodes.elementAt(i2);
                    String id = XmlUtils.getString("id", el2, null);
                    String val = XmlUtils.getString("content", el2, null);
                    if (Strings.isNullOrBlank(val) || Strings.isNullOrBlank(id)) continue;
                    prj.sDynamoAdd = prj.sDynamoAdd + id + '@' + val + ',';
                }
                if (prj.sDynamoAdd.length() > 0) {
                    prj.sDynamoAdd = prj.sDynamoAdd.substring(0, prj.sDynamoAdd.length() - 1);
                }
            }
            prj.isTimeMap = true;
        }
        nodes = root.getElementsByTagName(_TPR_DATASET);
        count = nodes.size();
        for (int k = 0; k < count; ++k) {
            Vector nodes2;
            XmlElement elDataset = (XmlElement)nodes.elementAt(k);
            XmlElement elMetadata = elDataset.getFirstElementByName("metadata");
            String dsURL = XmlUtils.getString(_TPR_PATH, elDataset, null);
            String dsType = XmlUtils.getString("type", elDataset, "shp");
            String dsId = XmlUtils.getString(_TPR_ECAI_ID, elDataset, null);
            if (MapUtils.isRunFromDisk && dsId != null) {
                layerSetup.addStatusInfo(0, null, "WARNING#116  dataset id#" + dsId);
                dsId = null;
            }
            if (dsURL == null && dsId == null && !"group".equalsIgnoreCase(dsType)) {
                layerSetup.addStatusInfo(105, null, "dataset#" + k);
                continue;
            }
            if (isDynAdd && prj.getLayerByDsId(dsId) != null) continue;
            Properties connectionData = new Properties();
            ((Hashtable)connectionData).put("type", dsType);
            if (dsURL != null) {
                ((Hashtable)connectionData).put("url", dsURL);
            }
            if (dsId != null) {
                ((Hashtable)connectionData).put("id", dsId);
            }
            if (XmlUtils.getBoolean("direct", elDataset, dsId == null)) {
                ((Hashtable)connectionData).put("direct", "yes");
            }
            if ((count2 = (nodes2 = elDataset.getElementsByTagName(_TPR_LAYER)).size()) == 0) {
                layerSetup.addStatusInfo(109, null, "dataset#" + k);
                continue;
            }
            for (int i = 0; i < count2; ++i) {
                Layer lyr;
                XmlElement el = (XmlElement)nodes2.elementAt(i);
                String nom = XmlUtils.getString("name", el, "unnamed");
                try {
                    lyr = layerSetup.createLayer(connectionData);
                }
                catch (AlovMapException e) {
                    layerSetup.addStatusInfo(e.getCode(), null, nom + "  " + e.getMessage());
                    continue;
                }
                if (!LoaderTM.loadLayer(prj, lyr, el)) continue;
                Layer mainLayer = prj.getLayerByDsId(lyr.datasetId);
                if (mainLayer != null) {
                    lyr.metadata = mainLayer.metadata;
                    lyr.dataStorage = mainLayer.dataStorage;
                }
                if (elMetadata != null) {
                    lyr.metadata.loadMetadata(elMetadata);
                    lyr.resolveMetadata();
                }
                prj.layers.addElement(lyr);
                if (lyr.id == null) {
                    lyr.id = prj.getLayerCount() + "-" + lyr.datasetId;
                }
                lyr.isFullLoad = lyr.isKeyMap;
                boolean bl = prj.hasKeyMap = prj.hasKeyMap || lyr.isKeyMap;
                if (XmlUtils.getBoolean("startup", el, false)) {
                    prj.startLayer = lyr.id;
                }
                lyr.removeOutOfExtent = isDynAdd && prj.isDynamic_RemoveOutOfExtent;
            }
        }
        if (!isDynAdd) {
            count2 = prj.getLayerCount();
            for (int i = 0; i < count2; ++i) {
                Layer lyr = prj.getLayerByIndex(i);
                lyr.drawOrder = count2 - lyr.drawOrder;
            }
            for (int i = 0; i < count2; ++i) {
                for (int j = count2 - 1; j > i; --j) {
                    int l2 = prj.getLayerByIndex((int)j).drawOrder;
                    int l1 = prj.getLayerByIndex((int)i).drawOrder;
                    if (l2 <= l1) continue;
                    Layer lyr = prj.getLayerByIndex(i);
                    prj.layers.setElementAt(prj.getLayerByIndex(j), i);
                    prj.layers.setElementAt(lyr, j);
                }
            }
        }
        if (prj.getLayerCount() == 0) {
            layerSetup.addStatusInfo(109, null, prj.name);
            throw new AlovMapException(109, prj.name);
        }
    }

    private static boolean loadLayer(Project prj, Layer lyr, XmlElement el) {
        try {
            StringTokenizer tok;
            lyr.id = XmlUtils.getString("name", el, null);
            lyr.setName(XmlUtils.getString(_TPR_LayerTitle, el, null));
            layerSetup.addStatusInfo(0, lyr, "Parse");
            if (lyr.id != null && prj.getLayerById(lyr.id) != null) {
                layerSetup.addStatusInfo(106, lyr, lyr.id + " isn't unique");
                lyr.id = null;
            }
            if (lyr.getName() == null) {
                lyr.setName("unnamed#" + prj.getLayerCount() + 1);
            }
            lyr.metadata.passResolved = XmlUtils.getBoolean("password", el, true);
            lyr.metadata.passFirstTime = !prj.isDynamic;
            lyr.legendWrapText = XmlUtils.getBoolean("WrapLayerTitles", el, false);
            lyr.zmin = XmlUtils.getFloat(_TPR_ZoomMin, el, 0.0f) * 100.0f;
            lyr.zmax = XmlUtils.getFloat(_TPR_ZoomMax, el, 0.0f) * 100.0f;
            lyr.withinZoom = XmlUtils.getBoolean(_TPR_WithinZoom, el, false);
            lyr.timeMin = ExDate.parseString(XmlUtils.getString(_TPR_DateMin, el, null));
            lyr.timeMax = ExDate.parseString(XmlUtils.getString(_TPR_DateMax, el, null));
            lyr.withinDate = (lyr.timeMin != null || lyr.timeMax != null) && XmlUtils.getBoolean(_TPR_WithinDate, el, false);
            lyr.timeVarying = XmlUtils.getBoolean(_TPR_TimeVarying, el, true);
            lyr.isKeyMap = XmlUtils.getBoolean(_TPR_KEYMAP, el, false);
            if (lyr.isKeyMap) {
                lyr.setVisible(false);
                lyr.legendVisible = false;
            } else {
                lyr.visible_always = XmlUtils.getBoolean(_TPR_LayerAlwaysVisible, el, false);
                lyr.setVisible(lyr.visible_always ? true : XmlUtils.getBoolean(_TPR_LayerVisible, el, true));
                lyr.legendVisible = XmlUtils.getBoolean(_TPR_ItemVisible, el, true);
                lyr.legendExpanded = XmlUtils.getBoolean(_TPR_ItemExpanded, el, true);
                lyr.legendName = XmlUtils.getString("legend", el, null);
            }
            lyr.initiallyVisible = lyr.isVisible();
            String maps = XmlUtils.getString("map", el, "all");
            if (!maps.equalsIgnoreCase("all")) {
                tok = new StringTokenizer(maps, " ,;");
                while (tok.hasMoreTokens()) {
                    String elt = tok.nextToken();
                    if (Strings.isNullOrBlank(elt = elt.trim()) || elt.equalsIgnoreCase("all")) continue;
                    lyr.themes.addElement(elt);
                }
            }
            lyr.legendObjectType = XmlUtils.getInt("LegType", el, 0);
            maps = XmlUtils.getString("legendsymbolshape", el, null);
            if (maps != null) {
                tok = new StringTokenizer(maps, " ,;");
                double[] tempArray = new double[1000];
                int cnt = 0;
                while (tok.hasMoreTokens()) {
                    tempArray[cnt] = MapUtils.toDouble(tok.nextToken());
                    ++cnt;
                }
                if (cnt > 0) {
                    double[] tempArray2 = new double[cnt];
                    System.arraycopy(tempArray, 0, tempArray2, 0, cnt);
                    lyr.legendSymbolShape = new Shape(tempArray2);
                }
                tempArray = null;
            }
            lyr.legendHideOutRange = XmlUtils.getBoolean(_TPR_HIDELEGENDOUTOFRANGE, el, false);
            lyr.canSearch = XmlUtils.getBoolean(_TPR_CANSEARCH, el, true);
            lyr.drawOrder = XmlUtils.getInt(_TPR_DRAWORDER, el, 0);
            lyr.linkMain = el.getElValue("linkmask", lyr.linkMain);
            String dependent = XmlUtils.getString("dependent", el, null);
            if (!Strings.isNullOrBlank(dependent)) {
                StringTokenizer st = new StringTokenizer(dependent, " ,;");
                lyr.controlledLayers = new Hashtable();
                while (st.hasMoreTokens()) {
                    lyr.controlledLayers.put(st.nextToken(), "1");
                }
            }
            if (lyr instanceof LayerVector) {
                XmlElement elSym;
                ((LayerVector)lyr).linkSearch = el.getElValue("searchlink", ((LayerVector)lyr).linkSearch);
                ((LayerVector)lyr).linkInfo = el.getElValue("infolink", ((LayerVector)lyr).linkInfo);
                ((LayerVector)lyr).localFilter = XmlUtils.getString(_TPR_WHERE, el, ((LayerVector)lyr).localFilter);
                boolean useDefault = false;
                Vector nodes = el.getElementsByTagName(_TPR_SYMBOL);
                if (nodes.size() > 0) {
                    LoaderTM.loadSymbol(((LayerVector)lyr).symbol, (XmlElement)nodes.elementAt(0), false, true);
                }
                if ((elSym = el.getFirstElementByName(_TPR_SELSYMBOL)) != null) {
                    LoaderTM.loadSymbol(((LayerVector)lyr).selectedSymbol, elSym, false, true);
                } else {
                    ((LayerVector)lyr).selectedSymbol.style = ((LayerVector)lyr).symbol.style;
                    ((LayerVector)lyr).selectedSymbol.fontStyle = ((LayerVector)lyr).symbol.fontStyle;
                    ((LayerVector)lyr).selectedSymbol.size = ((LayerVector)lyr).symbol.size;
                }
                nodes = el.getElementsByTagName(_TPR_RENDERER);
                int count = nodes.size();
                for (int i = 0; i < count; ++i) {
                    XmlElement el2 = (XmlElement)nodes.elementAt(i);
                    if (!XmlUtils.getBoolean(sRendEnabled, el2, true)) continue;
                    int k = XmlUtils.getInt(_TPR_RendType, el2, 0);
                    Renderer rend = null;
                    switch (k) {
                        case 1: {
                            rend = new RendererGrad(lyr);
                            rend.equal = -1;
                            break;
                        }
                        case 2: {
                            rend = new RendererGrad(lyr);
                            rend.equal = 0;
                            break;
                        }
                        case 4: {
                            rend = new RendererLabel(lyr);
                            rend.equal = 0;
                            break;
                        }
                        case 5: {
                            rend = new RendererChart(lyr);
                        }
                    }
                    if (rend != null) {
                        if (!LoaderTM.loadRenderer(lyr, rend, el2)) continue;
                        rend.name = String.valueOf(i);
                        lyr.renderers.addElement(rend);
                        useDefault = useDefault || rend.useDefault;
                        continue;
                    }
                    layerSetup.addStatusInfo(107, lyr, "Renderer#" + i + " type=" + k);
                }
                if (lyr.renderers.size() == 0 || useDefault) {
                    lyr.renderers.addElement(lyr.createDefaultRenderer());
                }
            } else if (lyr instanceof LayerRaster) {
                Renderer rend = lyr.createDefaultRenderer();
                rend.name = "1";
                rend.label = XmlUtils.getString(sLegendLabel4Image, el, null);
                rend.legendVisible = rend.label != null;
                lyr.renderers.addElement(rend);
            }
            return true;
        }
        catch (Exception e) {
            layerSetup.addStatusInfo(106, lyr, null);
            return false;
        }
    }

    private static boolean loadRenderer(Layer lyr, Renderer rend, XmlElement el) {
        try {
            rend.label = XmlUtils.getString(sRendHeader, el, null);
            rend.legendVisible = true;
            String maps = XmlUtils.getString("map", el, "all");
            if (!maps.equalsIgnoreCase("all")) {
                StringTokenizer tok = new StringTokenizer(maps, " ,;");
                while (tok.hasMoreTokens()) {
                    String elt = tok.nextToken();
                    if (Strings.isNullOrBlank(elt = elt.trim()) || elt.equalsIgnoreCase("all")) continue;
                    rend.themes.addElement(elt);
                }
            }
            rend.useDefault = XmlUtils.getBoolean(_TPR_UseDefault, el, false);
            Vector nodes = el.getElementsByTagName(_TPR_SYMBOL);
            int symbolCount = nodes.size();
            rend.symbolsUnprepared = new Vector();
            boolean isFontMaker = rend instanceof RendererLabel;
            if (symbolCount > 0) {
                for (int i = 0; i < symbolCount; ++i) {
                    Symbol sym = new Symbol();
                    XmlElement elSymbol = (XmlElement)nodes.elementAt(i);
                    if (!LoaderTM.loadSymbol(sym, elSymbol, isFontMaker, rend.useDefault)) continue;
                    if (isFontMaker && symbolCount > 1) {
                        sym.valueStr = String.valueOf(i);
                    }
                    rend.symbolsUnprepared.addElement(sym);
                }
            }
            if (rend instanceof RendererChart) {
                RendererChart rg = (RendererChart)rend;
                rg.width = XmlUtils.getInt(sBarWidth, el, 0);
                rg.height = XmlUtils.getInt(sBarHeight, el, 0);
                int chartsize = 0;
                if (rg.width <= 0 || rg.height <= 0) {
                    chartsize = XmlUtils.getInt(sMaxPieSize, el, 32);
                    if (chartsize == 0) {
                        chartsize = 32;
                    }
                    rg.width = chartsize;
                    rg.height = chartsize;
                }
                rg.outlineColor = XmlUtils.getBoolean(sShowOutline, el, true) ? Color.black : null;
                int t = XmlUtils.getInt(sChartType, el, 0);
                int n = rg.type = t == 1 ? 2 : 1;
                if (rg.type == 2) {
                    rg.normalization = XmlUtils.getFloat("normalization", el, 0.0f);
                } else {
                    rg.sizeFieldName = XmlUtils.getString(sSizeField, el, null);
                    if (rg.sizeFieldName != null) {
                        rg.minSize = XmlUtils.getInt(sMinPieSize, el, 16);
                        rg.maxSize = XmlUtils.getInt(sMaxPieSize, el, 48);
                    }
                }
                nodes = el.getElementsByTagName(_TPR_FIELD);
                int count = nodes.size();
                rg.fieldsUnprepared = new Vector();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        XmlElement fieldEl = (XmlElement)nodes.elementAt(i);
                        String s = XmlUtils.getString(sField, fieldEl, null);
                        if (s == null) continue;
                        FieldDef fi = new FieldDef();
                        fi.index = -1;
                        fi.name = s;
                        fi.color = XmlUtils.getColor("Color", fieldEl, Color.white);
                        fi.label = s;
                        rg.fieldsUnprepared.addElement(fi);
                    }
                }
                if (rg.fieldsUnprepared.size() <= 0) {
                    layerSetup.addStatusInfo(108, lyr, "renderer#" + rend.name);
                    return false;
                }
            } else if (rend instanceof RendererGrad) {
                RendererGrad rg2 = (RendererGrad)rend;
                rg2.fieldName = XmlUtils.getString(sField, el, null);
                int cnt = rg2.symbolsUnprepared.size();
                if (rg2.fieldName == null || cnt <= 0) {
                    layerSetup.addStatusInfo(108, lyr, "renderer#" + rend.name);
                    return false;
                }
                rg2.drawDefault = XmlUtils.getBoolean(sDrawBackground, el, false);
            } else if (rend instanceof RendererLabel) {
                RendererLabel rg3 = (RendererLabel)rend;
                rg3.labelFieldName = XmlUtils.getString(sField, el, null);
                if (rg3.labelFieldName == null || rg3.symbolsUnprepared.size() <= 0) {
                    layerSetup.addStatusInfo(108, lyr, "renderer#" + rend.name);
                    return false;
                }
                rg3.symbolFieldName = XmlUtils.getString(sSymbolField, el, null);
                rg3.useDefault = rg3.useDefault || XmlUtils.getBoolean(sDrawBackground, el, false);
            }
            return true;
        }
        catch (Exception e) {
            layerSetup.addStatusInfo(106, lyr, "renderer#" + rend.name);
            return false;
        }
    }

    private static boolean loadSymbol(Symbol symb, XmlElement el, boolean isFontMarker, boolean useDefault) {
        boolean isDefault = XmlUtils.getBoolean(_TPR_Default, el, false);
        if (!isDefault || useDefault) {
            int symType = XmlUtils.getInt(sSymType, el, 4);
            symb.size = XmlUtils.getInt(sSymSize, el, isFontMarker ? 10 : (symType == 0 ? 4 : 0));
            if (symType == 0) {
                symb.size += 2;
            }
            if (isFontMarker && symb.size < 10) {
                symb.size = 10;
            }
            symb.fontStyle = symb.style = XmlUtils.getInt(sSymStyle, el, 0);
            symb.fill = symb.style == 0 || symb.style > 7 || symType != 2;
            symb.fillColor = XmlUtils.getColor("Color", el, Color.yellow);
            if (symType == 1) {
                symb.outline = true;
                symb.outlineColor = symb.fillColor;
            } else {
                symb.outline = XmlUtils.getBoolean(sSymOutline, el, !isFontMarker);
                symb.outline = symb.outline || symType == 2 && symb.style != 0;
                symb.outlineColor = XmlUtils.getColor(sOutlineColor, el, Color.black);
            }
            symb.label = XmlUtils.getString(sRemark, el, null);
            symb.valueStr = XmlUtils.getString(sSymValueStr, el, null);
            if (symb.valueStr == null) {
                symb.valueStr = XmlUtils.getString(sSymValue, el, null);
            }
            symb.imageUrl = XmlUtils.getString(sSymCustomStyleFile, el, null);
            symb.legendVisible = XmlUtils.getBoolean(sLegShow, el, true);
            if (isFontMarker) {
                symb.outline = XmlUtils.getBoolean(sSymOutline, el, false);
                symb.fontName = XmlUtils.getString(sSymFont, el, MapUtils.defaultPlainFont.getName());
                symb.fontStyle = XmlUtils.getInt(sFontStyle, el, 0);
                symb.align = XmlUtils.getInt("align", el, 2);
            }
            Loader.load2Dfeatures(el, symb);
            return true;
        }
        return false;
    }
}

