/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.DataStorage;
import org.alov.map.DataStorageFast;
import org.alov.map.DisplayContext;
import org.alov.map.FilterExpression;
import org.alov.map.FloatRectangle;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.RendererImageCatalog;
import org.alov.util.Log;
import org.alov.util.Strings;

public class LayerZoomify
extends LayerVector {
    private static final String FILTER_LEVEL = "level";
    private static final String FILTER_ZEROLEVEL = "zerolevel";
    double geoWidth;
    double geoHeight;
    double imageWidth;
    double imageHeight;
    double tileSize;
    int levelCount = 0;
    private Vector levelFilters = new Vector();
    private Hashtable images = new Hashtable();
    private int fieldIndex = -1;
    public Color transparentColor = null;
    public int transparency = -1;
    public double maxPixelSize = 2.0;

    public LayerZoomify() {
        this.dataStorage = new DataStorageFast();
        Renderer renderer = this.createDefaultRenderer();
        renderer.enabled = true;
        this.renderers.addElement(renderer);
        this.dataStorage.setObjectType(4);
    }

    public void setDimensions(double geoWidth, double geoHeight, double imageWidth, double imageHeight, double tileSize, int levelCount) {
        this.geoWidth = geoWidth;
        this.geoHeight = geoHeight;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.tileSize = tileSize;
        this.levelCount = levelCount;
        this.levelFilters.removeAllElements();
        try {
            for (int i = 0; i < levelCount; ++i) {
                this.levelFilters.addElement(new FilterExpression("(level=" + i + ")", this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setResolutionLevel(DisplayContext dc) {
        double imagePixelsPerUnit;
        double pixelsPerImagePixel;
        if (dc == null || this.levelCount < 1) {
            return;
        }
        FloatRectangle extent = dc.getLastExtent();
        Dimension mapSize = dc.getSize();
        double geoExtentSize = Math.abs(extent.x2 - extent.x);
        if (extent == null || mapSize == null) {
            return;
        }
        double pixelsPerUnit = (double)mapSize.width / (extent.x2 - extent.x);
        double coeff = 1.0;
        int bestLevel = this.levelCount - 1;
        int i = this.levelCount - 1;
        while (i >= 0 && !((pixelsPerImagePixel = pixelsPerUnit / (imagePixelsPerUnit = this.imageWidth / this.geoWidth * coeff)) >= this.maxPixelSize)) {
            bestLevel = i--;
            coeff *= 0.5;
        }
        if (bestLevel >= this.levelCount) {
            bestLevel = this.levelCount - 1;
        }
        if (bestLevel < 0) {
            bestLevel = 0;
        }
        this.filters.put(FILTER_LEVEL, (FilterExpression)this.levelFilters.elementAt(bestLevel));
    }

    public boolean isVisibleNow(DisplayContext dc) {
        boolean result = super.isVisibleNow(dc);
        if (this.isKeyMap || result) {
            this.setResolutionLevel(dc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadZoomifyImages(FloatRectangle extent) {
        if (this.fieldIndex < 0 || this.dataStorage.size() == 0) {
            return;
        }
        boolean bNeedRepaint = false;
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            this.dataStorage.openDataStorage(true);
            try {
                int count = this.dataStorage.size();
                int i = 0;
                while (true) {
                    if (i >= count) break;
                    Record rec = this.newRecord(i);
                    if (this.dataStorage.readRecCoords(rec, extent)) {
                        Integer key;
                        if (this.applyFilters(rec) && !this.images.containsKey(key = new Integer(i))) {
                            block19: {
                                String imgUrl = (String)rec.getField(this.fieldIndex);
                                if (imgUrl == null) {
                                    return;
                                }
                                try {
                                    this.setImageData(i, MapUtils.loadImageToByteArray(this, imgUrl));
                                }
                                catch (Exception e) {
                                    if (!(this.parentMap instanceof Carte)) break block19;
                                    Log.addMessage(306, this.parentMap.getName(), this, "Can't load raster image " + imgUrl + "  " + e.getMessage());
                                }
                            }
                            bNeedRepaint = true;
                        }
                    } else {
                        this.dataStorage.skipAttribute(i);
                    }
                    rec = null;
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
        }
        if (bNeedRepaint && this.parentMap instanceof Carte) {
            ((Carte)this.parentMap).updateMap();
        }
    }

    public void clear(boolean bComplete) {
        Enumeration e = this.images.keys();
        while (e.hasMoreElements()) {
            byte[] img = (byte[])this.images.get((Integer)e.nextElement());
            Object var3_3 = null;
        }
        this.images.clear();
        super.clear(bComplete);
    }

    protected void setImageData(int recIndex, byte[] imageData) {
        this.images.put(new Integer(recIndex), imageData);
    }

    protected byte[] getImageData(int recIndex) {
        return (byte[])this.images.get(new Integer(recIndex));
    }

    protected Image getImage(int recIndex, Record rec) {
        return this.getImage(recIndex, rec, null);
    }

    protected Image getImage(int recIndex, Record rec, Rectangle interest) {
        Image img = null;
        try {
            img = MapUtils.createImageFromBytes(this.getImageData(recIndex));
            if (img != null && (this.transparentColor != null || this.transparency >= 0 && this.transparency < 255)) {
                img = MapUtils.makeColorTransparent(img, this.transparentColor, 255 - this.transparency);
            }
        }
        catch (Exception e) {
            System.out.println(">>>" + e.getMessage());
        }
        return img;
    }

    public void prepareLayer() {
        super.prepareLayer();
        String sName = this.metadata.getVal(310);
        if (Strings.isNullOrBlank(sName)) {
            sName = "image";
        }
        this.fieldIndex = this.getFieldIndex(sName);
        if (this.fieldIndex < 0) {
            Log.addMessage(303, this.parentMap.getName(), this, "Field with Image path not found. " + sName);
        }
    }

    public void applyRasterFilters(int alpha) {
        this.transparency = alpha;
    }

    public Renderer createDefaultRenderer() {
        return new RendererImageCatalog(this);
    }
}

