/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.alov.data.DataProvider;
import org.alov.data.SQLConst;
import org.alov.map.Carte;
import org.alov.map.ComplexFigure;
import org.alov.map.DataStorage;
import org.alov.map.DataStorageFast;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterRecords;
import org.alov.map.FilterTime;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.LayerGroup;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Meta;
import org.alov.map.Project;
import org.alov.map.RadioGroup;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.map.RendererDef;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.ExDate;
import org.alov.util.Log;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.TimerListener;
import org.alov.util.XmlUtils;

public abstract class Layer
implements Serializable,
TimerListener {
    public DataStorage dataStorage;
    transient DisplayContext parentMap = null;
    static final String FILTER_TIME = "TF";
    static final String FILTER_VALUE = "SF";
    public DataProvider provider = null;
    public boolean initiallyVisible = true;
    public int serverType = -1;
    public Properties connectionData;
    public Meta metadata = new Meta();
    protected FloatRectangle layerExtent = null;
    ComplexFigure loadedExtent = new ComplexFigure();
    public String id = null;
    public String datasetId = null;
    public boolean isGeocoding = false;
    private String title;
    private boolean visible = true;
    public boolean visible_always = false;
    public boolean legendVisible = true;
    public boolean legendWrapText = false;
    public String legendName = null;
    public boolean legendHideOutRange = false;
    boolean removeOutOfExtent = false;
    public boolean legendExpanded = true;
    public Shape legendSymbolShape = null;
    public int legendObjectType = 0;
    public Color legendColor = null;
    public boolean isKeyMap = false;
    private RecordsArray selection = null;
    public Vector renderers = new Vector();
    public boolean canSearch = true;
    public boolean canSelectByMouse = true;
    public boolean withinZoom = false;
    public float zmin;
    public float zmax;
    public float zoom_for_select = -1.0f;
    public boolean withinDate = false;
    public boolean timeVarying = false;
    public ExDate timeMin;
    public ExDate timeMax;
    public int drawOrder = 0;
    public int fi_description = -1;
    public String linkMain = null;
    public String linkSearch = null;
    public String linkTips = null;
    public String tipsMask = null;
    public boolean notPrepared = true;
    public Vector themes = new Vector();
    public String style = null;
    public Hashtable controlledLayers = null;
    public Vector controlledLayersUnresolved = null;
    public RadioGroup radioGroup = null;
    public boolean isDataOnServer;
    public boolean isFullLoad;
    public boolean zoomToExtentAfterCustomLoad = false;
    public String url;
    public Hashtable filters = new Hashtable();
    private Properties fieldAliases = null;
    protected boolean hasChart = false;
    private SimpleTimer reloadTimer;
    protected boolean isAnimatedZoom = false;
    private static final String _LAYERNAME = "$LAYERNAME";
    private static final String _LAYERID = "$LAYERID";
    private static final String _DATASETID = "$DATASETID";
    private static final String _PASSTHR = "$PASSTHROUGH";
    private static final String _SEARCHVAL = "$SEARCH";
    private static final String _USER = "$USER";
    private static final String _RECORDID = "$RECID";
    private static final String _BBOX_ALL = "$BBOXALL";
    private static final String _BBOX_DR = "$BBOXDR";
    private static final String _BBOX_SEL = "$BBOXSEL";
    private static final String _BBXMIN = "$BBXMIN";
    private static final String _BBXMAX = "$BBXMAX";
    private static final String _BBYMIN = "$BBYMIN";
    private static final String _BBYMAX = "$BBYMAX";
    private static final String _DRXMIN = "$DRXMIN";
    private static final String _DRXMAX = "$DRXMAX";
    private static final String _DRYMIN = "$DRYMIN";
    private static final String _DRYMAX = "$DRYMAX";
    private static final String _SELXMIN = "$SELXMIN";
    private static final String _SELXMAX = "$SELXMAX";
    private static final String _SELYMIN = "$SELYMIN";
    private static final String _SELYMAX = "$SELYMAX";
    private static final String _TSTART = "$TSTART";
    private static final String _TEND = "$TEND";
    private static final int _LOWER_CASE = 1;
    private static final int _UPPER_CASE = 2;

    public Layer() {
        this.dataStorage = new DataStorageFast();
    }

    public String getName() {
        return this.title;
    }

    public void setName(String title) {
        this.title = title;
    }

    public boolean isVisibleNow(DisplayContext dc) {
        return this.visible ? this.isOutOfRange(dc) == 0 && !this.isOutOfExtent(dc) && this.isPassResolved() && this.isTheme(dc) : false;
    }

    public boolean isBelongToLegend(String sName) {
        return this.legendName == null || this.legendName.equalsIgnoreCase(sName);
    }

    public boolean isInvisibleInLegend(DisplayContext dc) {
        return !this.isTheme(dc) || !this.legendVisible || this.metadata.loadFailed && Log.debugLevel == 0 || this.legendHideOutRange && (this.isOutOfRange(dc) != 0 || this.isOutOfExtent(dc));
    }

    public boolean isPassResolved() {
        return this.metadata.passResolved;
    }

    public void setTimeInterval(TimeInterval time) {
        if (this.filters == null) {
            return;
        }
        Enumeration e = this.filters.elements();
        while (e.hasMoreElements()) {
            FilterRecords filter = (FilterRecords)e.nextElement();
            if (!(filter instanceof FilterTime)) continue;
            ((FilterTime)filter).setTimeInterval(time);
        }
    }

    public RecordsArray getSelection() {
        return this.selection;
    }

    public void setSelection(RecordsArray recs) {
        this.selection = recs;
    }

    public int getFieldCount() {
        return this.dataStorage.getFields() == null ? 0 : this.dataStorage.getFields().length;
    }

    public int getFieldOriginalCount() {
        return this.dataStorage.fieldOriginalCount;
    }

    public FieldDef getFieldDef(int fieldIndex) {
        FieldDef[] fieldDefs = this.dataStorage.getFields();
        return fieldDefs == null || fieldIndex > fieldDefs.length ? null : fieldDefs[fieldIndex];
    }

    public FieldDef getFieldDef_(int fieldIndex) {
        FieldDef[] fieldDefs = this.dataStorage.getFields();
        return fieldDefs != null && fieldIndex < fieldDefs.length && fieldIndex >= 0 ? fieldDefs[fieldIndex] : null;
    }

    public void setFieldDef(int fieldIndex, FieldDef def) {
        FieldDef[] fieldDefs = this.dataStorage.getFields();
        if (fieldIndex >= 0 && fieldIndex < fieldDefs.length) {
            fieldDefs[fieldIndex] = def;
        }
    }

    public int getFieldIndex(String fieldName) {
        FieldDef[] fieldDefs = this.dataStorage.getFields();
        if (fieldName != null && fieldDefs != null) {
            int count = fieldDefs.length;
            if (this.fieldAliases != null) {
                fieldName = this.fieldAliases.getProperty(fieldName.toLowerCase(), fieldName);
            }
            for (int i = 0; i < count; ++i) {
                if (!fieldName.equalsIgnoreCase(fieldDefs[i].name)) continue;
                return i;
            }
        }
        return -1;
    }

    public Object getFieldValue(Record rec, int fieldIndex) {
        if (fieldIndex >= 0) {
            FieldDef[] fieldDefs = this.dataStorage.getFields();
            if (fieldIndex < this.dataStorage.fieldOriginalCount) {
                return rec.getField(fieldIndex);
            }
            if (fieldIndex < fieldDefs.length) {
                FieldDef def = fieldDefs[fieldIndex];
                if (def.field != null) {
                    return def.field.getFieldValue(rec, fieldIndex);
                }
            }
        }
        return null;
    }

    public String getFieldString(Record rec, int fieldIndex) {
        Object s = this.getFieldValue(rec, fieldIndex);
        if (s == null) {
            return "";
        }
        return s.toString();
    }

    public double getFieldDouble(Record rec, int fieldIndex) {
        Object obj = this.getFieldValue(rec, fieldIndex);
        return MapUtils.toDouble(obj);
    }

    public boolean isSomethingVisible(DisplayContext dc) {
        if (this.isVisibleNow(dc) || this.isKeyMap) {
            int count = this.renderers.size();
            for (int i = 0; i < count; ++i) {
                Renderer rend = (Renderer)this.renderers.elementAt(i);
                if (!rend.isVisible(dc)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTheme(DisplayContext dc) {
        String sTheme = this.style;
        if (this.style == null) {
            if (dc == null || this.themes == null) {
                return true;
            }
            sTheme = dc.getThematicMap();
        }
        return this.themes == null || this.themes.size() == 0 || sTheme == null || this.themes.indexOf(sTheme) >= 0;
    }

    public int isOutOfRange(DisplayContext dc) {
        TimeInterval ti;
        int isRes = 0;
        if (this.withinZoom && dc != null) {
            double d = dc.getDistance(dc.getLastExtent());
            int n = this.zmin > 0.0f && (double)this.zmin > d ? -1 : (isRes = this.zmax > 0.0f && d > (double)this.zmax ? 1 : 0);
        }
        if (isRes == 0 && this.withinDate && dc != null && (ti = dc.getTimeInterval()) != null) {
            isRes = ti.inInterval(this.timeMin, this.timeMax);
        }
        return isRes;
    }

    public boolean isOutOfExtent(DisplayContext dc) {
        boolean f = dc != null && !this.metadata.maxExtent.isZero() && !this.metadata.maxExtent.intersects(dc.getLastExtent());
        return f;
    }

    public boolean isEmpty() {
        return this.dataStorage.size() == 0;
    }

    public abstract void paintRecords(Vector var1, Renderer var2, boolean var3, DisplayContext var4, int var5);

    public abstract RecordsArray paintRecords2(Renderer var1, DisplayContext var2, int var3);

    public abstract RecordsArray findWithinRect(FloatRectangle var1, boolean var2);

    public abstract RecordsArray findWithinShape(Shape var1, boolean var2, boolean var3);

    public abstract RecordsArray findWithinCircle(FloatPoint var1, double var2, boolean var4, boolean var5);

    public void setParentMap(DisplayContext map) {
        this.parentMap = map;
    }

    public DisplayContext getMap() {
        return this.parentMap;
    }

    public void clearRenderers() {
        int count = this.renderers.size();
        for (int j = 0; j < count; ++j) {
            Renderer rend = (Renderer)this.renderers.elementAt(j);
            rend.symbols = null;
            Object var3_3 = null;
        }
        this.renderers.removeAllElements();
        this.renderers = null;
    }

    public void clear(boolean bComplete) {
        this.dataStorage.clear();
        this.metadata.memsize = 0;
        this.layerExtent = null;
        this.setSelection(null);
        this.loadedExtent = null;
        if (bComplete) {
            if (this.reloadTimer != null) {
                this.reloadTimer.stop();
            }
            this.clearRenderers();
            this.provider = null;
            this.themes = null;
            this.filters = null;
        } else {
            this.metadata.loadFailed = false;
            this.metadata.forceClearCache = true;
            this.setLoadComplete(false);
        }
        System.gc();
        this.loadedExtent = new ComplexFigure();
    }

    public void setLoadComplete(boolean b) {
        if (this.isGeocoding) {
            if (this.layerExtent != null) {
                this.metadata.maxExtent = this.layerExtent;
            }
        } else {
            this.metadata.isLoaded = b;
            if (b && this.layerExtent != null && this.metadata.maxExtent.isZero()) {
                this.metadata.maxExtent = this.layerExtent;
            }
        }
    }

    public boolean isLoadComplete() {
        return this.metadata.isLoaded;
    }

    public FloatRectangle getLayerExtent() {
        return this.layerExtent;
    }

    public void setLayerExtent(FloatRectangle ext) {
        if (this.layerExtent == null) {
            this.layerExtent = new FloatRectangle(ext);
        } else {
            this.layerExtent.setBounds(ext.x, ext.y, ext.x2, ext.y2);
        }
    }

    FloatRectangle getSelectionExtent() {
        if (this.selection != null) {
            return this.selection.getExtent();
        }
        return null;
    }

    public void addExtent(Record rec) {
        FloatRectangle recExt = rec.getRecordExtent();
        if (recExt != null) {
            if (this.layerExtent == null) {
                this.layerExtent = new FloatRectangle(recExt);
            } else {
                this.layerExtent.union(recExt);
            }
        }
    }

    public void prepareLayer() {
        int count = this.renderers.size();
        for (int i = 0; i < count; ++i) {
            Renderer rend = (Renderer)this.renderers.elementAt(i);
            try {
                rend.prepare();
                if (!rend.isPrepared) continue;
                this.notPrepared = false;
                continue;
            }
            catch (Exception e) {
                if (!(this.parentMap instanceof Carte)) continue;
                Log.addMessage(108, ((Component)((Object)this.parentMap)).getName(), this, e.getMessage());
            }
        }
        if (this.parentMap instanceof Carte) {
            ((Carte)this.parentMap).broadcastMessage(15, this.id);
            if (this.reloadTimer == null && this.metadata.reloadTimeRange > 0) {
                this.reloadTimer = new SimpleTimer(this.metadata.reloadTimeRange * 1000, this);
            }
        }
    }

    public void afterDeserialization() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean state) {
        this.setVisible(state, true);
    }

    private void setVisible(boolean state, boolean doDownload) {
        boolean b = this.visible_always || state;
        boolean dependentWasSetVisible = false;
        if (this.visible != b) {
            this.visible = b;
            if (this.controlledLayers != null) {
                Enumeration e2 = this.controlledLayers.elements();
                Enumeration e = this.controlledLayers.keys();
                while (e.hasMoreElements()) {
                    Layer lyr = (Layer)e.nextElement();
                    boolean b2 = "1".equals((String)e2.nextElement()) ? b : !b;
                    lyr.setVisible(b2, false);
                    dependentWasSetVisible = dependentWasSetVisible || b2;
                }
            }
            if (this.radioGroup != null) {
                this.radioGroup.layerVisibleChanged(this, this.visible);
            }
            if (this.parentMap instanceof Carte) {
                ((Carte)this.parentMap).broadcastMessage(101, this.id);
                if (doDownload && (b || dependentWasSetVisible)) {
                    if (this.controlledLayers != null) {
                        ((Carte)this.parentMap).extentChanged();
                    } else {
                        ((Carte)this.parentMap).downloadLayer(this.id);
                    }
                }
            }
        }
    }

    public void setExpanded(boolean state) {
        if (this.legendExpanded != state) {
            this.legendExpanded = state;
            if (this instanceof LayerGroup && this.controlledLayers != null) {
                Enumeration e = this.controlledLayers.keys();
                while (e.hasMoreElements()) {
                    Layer l = (Layer)e.nextElement();
                    l.legendVisible = state;
                    if (l.controlledLayers == null) continue;
                    l.setExpanded(state);
                }
            }
        }
    }

    public Record findAtScreenPoint(Point ppt) {
        if (this.parentMap != null && this.parentMap instanceof Carte) {
            Carte map = (Carte)this.parentMap;
            FloatPoint pt1 = map.screenToMap(new Point(ppt.x + 2, ppt.y + 2));
            FloatPoint pt2 = map.screenToMap(new Point(ppt.x - 4, ppt.y - 4));
            FloatRectangle rect = new FloatRectangle(pt2.x, pt1.y, pt1.x, pt2.y);
            RecordsArray findRec = this.findWithinRect(rect, true);
            if (MapUtils.isNotEmptyRecs(findRec)) {
                return findRec.getRecord(0);
            }
        }
        return null;
    }

    void setDepend(Project prj) {
        if (this.controlledLayers != null) {
            Enumeration e = this.controlledLayers.keys();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof String)) continue;
                String dependentId = (String)o;
                Layer lyr = prj.getLayerById(dependentId);
                if (lyr == null || lyr == this) {
                    if (this.controlledLayersUnresolved == null) {
                        this.controlledLayersUnresolved = new Vector();
                    }
                    this.controlledLayersUnresolved.addElement(dependentId);
                } else {
                    if (this instanceof LayerGroup) {
                        lyr.legendVisible = this.legendExpanded;
                    }
                    this.controlledLayers.put(lyr, this.controlledLayers.get(dependentId));
                }
                this.controlledLayers.remove(dependentId);
            }
            if (this.controlledLayers.size() == 0) {
                this.controlledLayers = null;
            }
        }
    }

    protected void readMetadata_(DataInputStream is) throws Exception {
        short id;
        while ((id = is.readShort()) != 0) {
            this.metadata.put(id, is.readUTF());
        }
        if (this instanceof LayerVector) {
            String fieldsEditable = ',' + this.metadata.getStr(312).toUpperCase() + ',';
            this.dataStorage.setObjectType(is.read());
            int count = is.readShort();
            FieldDef[] fieldDefs = this.dataStorage.initFields(count);
            for (int i = 0; i < count; ++i) {
                FieldDef def = new FieldDef();
                def.name = is.readUTF();
                def.label = this.metadata.getFieldAlias(def.name, MapUtils.language);
                def.type = is.readInt();
                def.index = i;
                def.visible = is.read() == 1;
                def.editable = fieldsEditable.indexOf(',' + def.name.toUpperCase() + ',') >= 0;
                fieldDefs[i] = def;
            }
        }
        this.resolveMetadata();
        this.prepareLayer();
    }

    public void resolveMetadata() throws AlovMapException {
        this.serverType = Meta.getSrvId(this.metadata.getVal(168));
        if (this.linkMain == null) {
            this.linkMain = this.metadata.getVal(63);
        }
        this.metadata.maxExtent.x = this.metadata.getDouble(4);
        this.metadata.maxExtent.x2 = this.metadata.getDouble(5);
        this.metadata.maxExtent.y = this.metadata.getDouble(6);
        this.metadata.maxExtent.y2 = this.metadata.getDouble(7);
        if (MapUtils.isRunFromDisk) {
            this.fieldAliases = XmlUtils.makeProperties(this.metadata.getVal(57), ",");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWebLink(String link, Object recs, String query, FloatRectangle selExt, String UserAndMagic) {
        if (Strings.isNullOrBlank(link) || !this.canSearch) {
            return null;
        }
        int count = link.length();
        boolean b = false;
        boolean b2 = false;
        StringBuffer buf = new StringBuffer();
        StringBuffer bufElement = new StringBuffer();
        StringBuffer bufField = new StringBuffer();
        int nZeroPadding = 0;
        int nCharCase = 0;
        boolean bUrlEncode = true;
        int iRound = 0;
        int recCount = 0;
        recCount = recs == null ? 0 : (recs instanceof Record ? 1 : ((RecordsArray)recs).size());
        FloatRectangle ext = this.parentMap.getLastExtent();
        TimeInterval ti = this.parentMap.getTimeInterval();
        if (selExt == null) {
            selExt = ext;
        }
        FloatRectangle extSel = this.getSelectionExtent();
        for (int m = 0; m < count; ++m) {
            char ch = link.charAt(m);
            if (b2 || ch == '[') {
                if (ch == ']' && bufField.length() > 0) {
                    int k2;
                    String sField = bufField.toString().trim();
                    if (sField.length() > 0) {
                        sField = sField.substring(1);
                        k2 = sField.lastIndexOf(44);
                        nZeroPadding = 0;
                        nCharCase = 0;
                        bUrlEncode = true;
                        while (k2 > 0) {
                            String sFormat;
                            if (k2 < sField.length() && (sFormat = sField.substring(k2 + 1, sField.length()).trim()).length() > 0) {
                                if (sFormat.equalsIgnoreCase("$u")) {
                                    nCharCase = 2;
                                } else if (sFormat.equalsIgnoreCase("$l")) {
                                    nCharCase = 1;
                                } else if (sFormat.equalsIgnoreCase("$ne")) {
                                    bUrlEncode = false;
                                } else if (sFormat.startsWith("$f")) {
                                    iRound = Strings.strToInt(sFormat.substring(2), 0);
                                } else {
                                    nZeroPadding = Strings.strToInt(sFormat, 0);
                                }
                            }
                            sField = sField.substring(0, k2);
                            k2 = sField.lastIndexOf(44);
                        }
                    }
                    if (sField.startsWith("#")) {
                        buf.append(this.parentMap.getParameter(sField.substring(1), ""));
                    } else if (sField.equalsIgnoreCase(_BBOX_ALL)) {
                        buf.append(ext.x).append(',').append(ext.y).append(',').append(ext.x2).append(',').append(ext.y2);
                    } else if (sField.equalsIgnoreCase(_BBXMIN)) {
                        buf.append(ext.x);
                    } else if (sField.equalsIgnoreCase(_BBYMIN)) {
                        buf.append(ext.y);
                    } else if (sField.equalsIgnoreCase(_BBXMAX)) {
                        buf.append(ext.x2);
                    } else if (sField.equalsIgnoreCase(_BBYMAX)) {
                        buf.append(ext.y2);
                    } else if (sField.equalsIgnoreCase(_BBOX_SEL)) {
                        buf.append(extSel.x).append(',').append(extSel.y).append(',').append(extSel.x2).append(',').append(extSel.y2);
                    } else if (sField.equalsIgnoreCase(_SELXMIN)) {
                        buf.append(extSel.x);
                    } else if (sField.equalsIgnoreCase(_SELYMIN)) {
                        buf.append(extSel.y);
                    } else if (sField.equalsIgnoreCase(_SELXMAX)) {
                        buf.append(extSel.x2);
                    } else if (sField.equalsIgnoreCase(_SELYMAX)) {
                        buf.append(extSel.y2);
                    } else if (sField.equalsIgnoreCase(_BBOX_DR)) {
                        buf.append(selExt.x).append(',').append(selExt.y).append(',').append(selExt.x2).append(',').append(selExt.y2);
                    } else if (sField.equalsIgnoreCase(_DRXMIN)) {
                        buf.append(selExt.x);
                    } else if (sField.equalsIgnoreCase(_DRYMIN)) {
                        buf.append(selExt.y);
                    } else if (sField.equalsIgnoreCase(_DRXMAX)) {
                        buf.append(selExt.x2);
                    } else if (sField.equalsIgnoreCase(_DRYMAX)) {
                        buf.append(selExt.y2);
                    } else if (sField.equalsIgnoreCase(_TSTART)) {
                        if (ti != null) {
                            buf.append(ti.date1().toString());
                        }
                    } else if (sField.equalsIgnoreCase(_TEND)) {
                        if (ti != null) {
                            buf.append(ti.date2().toString());
                        }
                    } else if (sField.equalsIgnoreCase(_LAYERNAME)) {
                        buf.append(this.title);
                    } else if (sField.equalsIgnoreCase(_LAYERID)) {
                        buf.append(this.id);
                    } else if (sField.equalsIgnoreCase(_DATASETID)) {
                        buf.append(this.datasetId);
                    } else if (sField.equalsIgnoreCase(_USER)) {
                        if (UserAndMagic != null) {
                            buf.append(UserAndMagic);
                        }
                    } else if (sField.equalsIgnoreCase(_SEARCHVAL)) {
                        if (this.serverType == 23) {
                            buf.append(ext.x).append(',').append(ext.y).append(',').append(ext.x2).append(',').append(ext.y2).append(',').append(extSel.x).append(',').append(extSel.y).append(',').append(extSel.x2).append(',').append(extSel.y2);
                        } else if (query != null) {
                            buf.append(URLEncoder.encode(query));
                        }
                    } else {
                        int kk = this.getFieldIndex(sField);
                        if (recs != null && (kk >= 0 || sField.equalsIgnoreCase(_RECORDID))) {
                            int prevRec = 0;
                            int maxInd = this.dataStorage.size() - 1;
                            DataStorage dataStorage = this.dataStorage;
                            synchronized (dataStorage) {
                                this.dataStorage.openDataStorage(true);
                                try {
                                    for (int j = 0; j < recCount; ++j) {
                                        String sValue;
                                        Record rec;
                                        if (recs instanceof Record) {
                                            rec = (Record)recs;
                                        } else {
                                            int k = ((RecordsArray)recs).get(j);
                                            this.dataStorage.skipAttribute2(k, prevRec);
                                            prevRec = k < maxInd ? k + 1 : 0;
                                            rec = this.newRecord(k);
                                            this.dataStorage.readRecAttribute(rec);
                                        }
                                        String string = sValue = sField.equalsIgnoreCase(_RECORDID) ? ((LayerVector)this).getId(rec) : this.getFieldString(rec, kk);
                                        if (iRound != 0) {
                                            sValue = Strings.doubleToStr(MapUtils.toDouble(sValue), iRound);
                                        } else {
                                            if (nCharCase == 2) {
                                                sValue = sValue.toUpperCase();
                                            }
                                            if (nCharCase == 1) {
                                                sValue = sValue.toLowerCase();
                                            }
                                        }
                                        if (bUrlEncode) {
                                            sValue = URLEncoder.encode(sValue);
                                        }
                                        k2 = sValue.length();
                                        int k3 = buf.length();
                                        buf.append(sValue);
                                        for (int l = k2; l < nZeroPadding; ++l) {
                                            buf.insert(k3, '0');
                                        }
                                        if (recCount <= 1 || j + 1 >= recCount) continue;
                                        buf.append(',');
                                    }
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    this.dataStorage.closeDataStorage();
                                }
                            }
                        }
                    }
                    b2 = false;
                    bufField.setLength(0);
                    continue;
                }
                bufField.append(ch);
                b2 = true;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public Record newRecord(int index) {
        return this.dataStorage.newRecord(index);
    }

    public void addRecord(Record rec) {
        this.addExtent(rec);
        if (this.hasChart) {
            FieldDef[] fieldDefs = this.dataStorage.getFields();
            int count = fieldDefs.length;
            for (int i = 0; i < count; ++i) {
                if (!SQLConst.isNumber(fieldDefs[i].type)) continue;
                double v = this.getFieldDouble(rec, i);
                if (fieldDefs[i].minvalue > v) {
                    fieldDefs[i].minvalue = v;
                }
                if (!(fieldDefs[i].maxvalue < v)) continue;
                fieldDefs[i].maxvalue = v;
            }
        }
        this.dataStorage.changeRecord(rec, 0);
    }

    public void deleteRecord(Record rec) {
        this.dataStorage.deleteRecord(rec);
    }

    public Renderer getRenderer(String name) {
        if (!Strings.isNullOrBlank(name)) {
            int count = this.renderers.size();
            for (int i = 0; i < count; ++i) {
                if (!name.equals(((Renderer)this.renderers.elementAt((int)i)).name)) continue;
                return (Renderer)this.renderers.elementAt(i);
            }
        }
        return null;
    }

    public Renderer createDefaultRenderer() {
        return new RendererDef(this);
    }

    public void timerTick() {
        if (this.parentMap instanceof Carte) {
            this.clear(false);
            ((Carte)this.parentMap).extentChanged();
        }
    }

    public byte[] saveToByteArray() {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(this.dataStorage);
            objOut.writeObject(this.layerExtent);
            objOut.writeObject(this.metadata);
            objOut.close();
            return out.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void loadFromByteArray(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            ObjectInputStream objIn = new ObjectInputStream(in);
            this.dataStorage = (DataStorage)objIn.readObject();
            this.layerExtent = (FloatRectangle)objIn.readObject();
            this.metadata = (Meta)objIn.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isObjectType(int value) {
        int obj = this.dataStorage.getObjectType();
        if (value == -1) {
            return obj < 1 || obj > 4;
        }
        return obj == value;
    }
}

