/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import org.alov.map.FilterRecords;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.Record;
import org.alov.util.ExDate;
import org.alov.util.TimeInterval;

public class FilterTime
extends FilterRecords {
    private int timeFieldIndex1;
    private int timeFieldIndex2;
    private int dateType;
    private TimeInterval time = null;

    public FilterTime(Layer layer) {
        this.layer = layer;
        LayerVector lyr = (LayerVector)layer;
        this.timeFieldIndex1 = layer.getFieldIndex(lyr.f_dateLow);
        this.timeFieldIndex2 = layer.getFieldIndex(lyr.f_dateHigh);
        this.dateType = lyr.dateType;
        this.state = this.dateType == 1 && this.timeFieldIndex1 >= 0 && this.timeFieldIndex2 >= 0 || this.dateType == 2 && this.timeFieldIndex1 >= 0 ? 2 : 3;
    }

    public void setTimeInterval(TimeInterval time) {
        this.time = time;
        this.state = this.time == null ? 0 : 2;
    }

    public boolean checkRecord(Record rec) {
        Object o;
        if (rec.dateInvalid || this.time == null) {
            return true;
        }
        if (rec.dateLow == null) {
            o = this.layer.getFieldValue(rec, this.timeFieldIndex1);
            try {
                rec.dateLow = ExDate.parseObject(o);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (rec.dateLow == null) {
                rec.dateInvalid = true;
                return true;
            }
        }
        if (this.dateType == 1 && rec.dateHigh == null) {
            o = this.layer.getFieldValue(rec, this.timeFieldIndex2);
            try {
                rec.dateHigh = ExDate.parseObject(o);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (rec.dateHigh == null) {
                rec.dateHigh = rec.dateLow;
            }
        }
        if (this.dateType == 2) {
            return this.time.contains(rec.dateLow);
        }
        if (this.dateType == 1) {
            return this.time.intersects(rec.dateLow, rec.dateHigh);
        }
        return true;
    }
}

