/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.DataInputStream;
import org.alov.data.Dbf;
import org.alov.util.AlovMapException;
import org.alov.util.Readers;

class ShpHeader {
    int length;
    int version;
    int type;
    int position;
    int objectNumber = 0;
    double xmin;
    double ymin;
    double xmax;
    double ymax;
    double zmin;
    double zmax;
    double mmin;
    double mmax;
    int[] tempArray = null;
    DataInputStream dataInput;
    Dbf dbf;
    boolean fixHoles;
    int fi_id;

    ShpHeader(DataInputStream in, Dbf dbf, boolean fixHoles, int fi_id) throws Exception {
        this.dataInput = in;
        this.dbf = dbf;
        this.fi_id = fi_id;
        this.fixHoles = fixHoles;
        int sign = in.readInt();
        if (sign != 9994) {
            throw new AlovMapException(321, "");
        }
        in.readInt();
        in.readInt();
        in.readInt();
        in.readInt();
        in.readInt();
        this.length = in.readInt();
        this.version = Readers.readInt(in);
        if (this.version != 1000) {
            throw new AlovMapException(322, String.valueOf(this.version));
        }
        this.type = Readers.readInt(in);
        switch (this.type) {
            case 11: {
                this.type = 1;
                break;
            }
            case 13: {
                this.type = 3;
                break;
            }
            case 15: {
                this.type = 5;
                break;
            }
            case 18: {
                this.type = 8;
            }
        }
        if (this.type != 1 && this.type != 8 && this.type != 3 && this.type != 5) {
            throw new AlovMapException(323, "Unrecognized shape type");
        }
        this.xmin = Readers.readDouble(in);
        this.ymin = Readers.readDouble(in);
        this.xmax = Readers.readDouble(in);
        this.ymax = Readers.readDouble(in);
        this.zmin = Readers.readDouble(in);
        this.zmax = Readers.readDouble(in);
        this.mmin = Readers.readDouble(in);
        this.mmax = Readers.readDouble(in);
        this.position = 50;
    }
}

