/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.FieldDef;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.Readers;
import org.alov.util.Strings;

public class Csv {
    private static String delims = "\t,;";

    protected static Record ParseCsvRecord(String rec, String encoding, int numfields) {
        String s = rec == null ? "" : rec;
        Record record = new Record(numfields);
        boolean quotation = false;
        boolean wasQuotation = false;
        for (int i = 0; s.length() > 0 && i < numfields; ++i) {
            String t;
            int k = -1;
            while (++k < s.length()) {
                char c = s.charAt(k);
                if (c == '\"') {
                    if (quotation) {
                        wasQuotation = true;
                        quotation = false;
                    } else {
                        quotation = true;
                    }
                }
                if (quotation || delims.indexOf(c) < 0) continue;
            }
            if (wasQuotation) {
                t = s.substring(1, k - 1);
                wasQuotation = false;
            } else {
                t = s.substring(0, k);
            }
            record.setField(i, Readers.Read2Unicode(t, encoding).trim());
            if (k + 1 > s.length()) break;
            s = s.substring(k + 1, s.length());
        }
        return record;
    }

    protected static void resolveCsvFields(String[] fieldNames, char[] fieldsType, LayerVector layer) {
        int i;
        String fieldsEditable;
        if (fieldNames == null) {
            return;
        }
        int fieldCount = fieldNames.length;
        String fieldsVisible = layer.metadata.getVal(307, MapUtils.language);
        if (!Strings.isNullOrBlank(fieldsVisible)) {
            fieldsVisible = ',' + fieldsVisible + ',';
        }
        if (!Strings.isNullOrBlank(fieldsEditable = layer.metadata.getVal(312, MapUtils.language))) {
            fieldsEditable = ',' + fieldsEditable.toUpperCase() + ',';
        }
        Vector<FieldDef> fields = new Vector<FieldDef>();
        for (i = 0; i < fieldCount; ++i) {
            if (Strings.isNullOrBlank(fieldNames[i])) continue;
            FieldDef fieldDef = new FieldDef();
            if (fieldsType == null) {
                fieldDef.type = 12;
            } else {
                switch (fieldsType[i]) {
                    case 'C': 
                    case 'D': 
                    case 'L': {
                        fieldDef.type = 1;
                        break;
                    }
                    case 'I': {
                        fieldDef.type = 4;
                        break;
                    }
                    case 'F': 
                    case 'N': {
                        fieldDef.type = 8;
                        break;
                    }
                    default: {
                        fieldDef.type = 0;
                    }
                }
            }
            fieldDef.index = fields.size();
            fieldDef.name = fieldNames[i];
            fieldDef.label = layer.metadata.getFieldAlias(fieldDef.name, MapUtils.language);
            fieldDef.visible = Strings.isNullOrBlank(fieldsVisible) || fieldsVisible.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
            fieldDef.editable = !Strings.isNullOrBlank(fieldsEditable) && fieldsEditable.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
            fields.addElement(fieldDef);
        }
        fieldCount = fields.size();
        layer.dataStorage.initFields(fieldCount);
        for (i = 0; i < fieldCount; ++i) {
            layer.setFieldDef(i, (FieldDef)fields.elementAt(i));
        }
        LayerVector lyr = layer;
        lyr.fi_description = lyr.getFieldIndex(lyr.f_description);
        lyr.fi_id = lyr.getFieldIndex(lyr.f_id);
        if (lyr.fi_id >= 0) {
            lyr.f_id_istext = true;
        }
        layer.prepareLayer();
    }

    public static void loadFromStream(InputStream is, LayerVector layer, String encoding) throws AlovMapException {
        layer.dataStorage.openDataStorageSave(true);
        try {
            String lineStr;
            InputStreamReader isReader = new InputStreamReader(is);
            BufferedReader reader = new BufferedReader(isReader, 2048);
            String[] fieldNames = null;
            int numfields = 0;
            while ((lineStr = reader.readLine()) != null) {
                if (Strings.isNullOrBlank(lineStr)) continue;
                StringTokenizer st = new StringTokenizer(lineStr, delims);
                numfields = st.countTokens();
                fieldNames = new String[numfields];
                int i = 0;
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (s.startsWith("\"") && s.endsWith("\"")) {
                        s = s.substring(1, s.length() - 1);
                    }
                    fieldNames[i] = s.trim();
                    ++i;
                }
                break block7;
            }
            Csv.resolveCsvFields(fieldNames, null, layer);
            int fi_xmin = -1;
            int fi_xmax = -1;
            int fi_ymin = -1;
            int fi_ymax = -1;
            int fi_x = -1;
            int fi_y = -1;
            String sNotFound = "Coordinate fields not found";
            fi_x = layer.getFieldIndex(layer.f_x);
            fi_y = layer.getFieldIndex(layer.f_y);
            if (layer.isObjectType(4) || layer.isObjectType(2)) {
                fi_xmin = layer.getFieldIndex(layer.f_xmin);
                fi_xmax = layer.getFieldIndex(layer.f_xmax);
                fi_ymin = layer.getFieldIndex(layer.f_ymin);
                fi_ymax = layer.getFieldIndex(layer.f_ymax);
                if (fi_xmin < 0 && fi_xmax < 0 && fi_ymin < 0 && fi_ymax < 0) {
                    fi_xmin = layer.getFieldIndex("xmin");
                    fi_xmax = layer.getFieldIndex("xmax");
                    fi_ymin = layer.getFieldIndex("ymin");
                    fi_ymax = layer.getFieldIndex("ymax");
                }
                if (fi_xmin < 0 || fi_xmax < 0 || fi_ymin < 0 || fi_ymax < 0) {
                    throw new AlovMapException(303, "Coordinate fields not found");
                }
                if (!layer.isObjectType(2)) {
                    layer.dataStorage.setObjectType(3);
                }
            } else {
                layer.dataStorage.setObjectType(1);
                fi_x = layer.getFieldIndex(layer.f_x);
                fi_y = layer.getFieldIndex(layer.f_y);
                if (fi_x < 0 && fi_y < 0) {
                    fi_x = layer.getFieldIndex("LONG");
                    fi_y = layer.getFieldIndex("LAT");
                }
                if (fi_x < 0 && fi_y < 0) {
                    fi_x = layer.getFieldIndex("LONGITUDE");
                    fi_y = layer.getFieldIndex("LATITUDE");
                }
                if (fi_x < 0 && fi_y < 0) {
                    fi_x = layer.getFieldIndex("X");
                    fi_y = layer.getFieldIndex("Y");
                }
                if (fi_x < 0 || fi_y < 0) {
                    throw new AlovMapException(303, "Coordinate fields not found");
                }
            }
            if (Strings.isNullOrBlank(encoding)) {
                encoding = Readers.ENCODING;
            }
            int i = 1;
            while ((lineStr = reader.readLine()) != null) {
                Record rec;
                if (Strings.isNullOrBlank(lineStr) || (rec = Csv.ParseCsvRecord(lineStr, encoding, numfields)) == null) continue;
                try {
                    Shape shp;
                    if (layer.isObjectType(3)) {
                        shp = rec.newShape(4);
                        shp.xCoords[0] = layer.getFieldDouble(rec, fi_xmin);
                        shp.yCoords[0] = layer.getFieldDouble(rec, fi_ymin);
                        shp.xCoords[1] = shp.xCoords[0];
                        shp.yCoords[1] = layer.getFieldDouble(rec, fi_ymax);
                        shp.xCoords[2] = layer.getFieldDouble(rec, fi_xmax);
                        shp.yCoords[2] = shp.yCoords[1];
                        shp.xCoords[3] = shp.xCoords[2];
                        shp.yCoords[3] = shp.yCoords[0];
                    } else if (layer.isObjectType(2)) {
                        shp = rec.newShape(2);
                        shp.xCoords[0] = layer.getFieldDouble(rec, fi_xmin);
                        shp.yCoords[0] = layer.getFieldDouble(rec, fi_ymin);
                        shp.xCoords[1] = layer.getFieldDouble(rec, fi_xmax);
                        shp.yCoords[1] = layer.getFieldDouble(rec, fi_ymax);
                    } else {
                        shp = rec.newShape(1);
                        shp.xCoords[0] = layer.getFieldDouble(rec, fi_x);
                        shp.yCoords[0] = layer.getFieldDouble(rec, fi_y);
                    }
                }
                catch (Exception e) {
                    throw new AlovMapException(106, "Coordinate field does not contains numeric value. Line#" + i + ". " + e.getMessage());
                }
                layer.addRecord(rec);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AlovMapException(106, e.getMessage());
        }
        finally {
            layer.dataStorage.closeDataStorageSave();
        }
    }
}

