/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimerListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.ImageButton;
import org.alov.viewer.TipRect;

public class Tooltip
extends ImageButton
implements CarteHostListener,
CarteListener,
ActionListener,
TimerListener {
    private Carte map;
    private boolean isTipsActive = false;
    private boolean searchInActiveOnly = true;
    private boolean showInCentroid = false;
    private boolean showWithLayerName = false;
    private TipRect tooltipInstance = null;
    private String previousTip = null;
    private int showTips = 0;
    private boolean fill = true;
    private boolean outline = true;
    private Color fillColor = Color.yellow;
    private Color outlineColor = Color.black;
    private int maxWidth = 0;
    private Font font;
    private SimpleTimer st;
    private Point ptForShow = null;
    private Point ptForSearch = null;
    private int reset = 0;
    private String sTip = null;

    public boolean isToolTipsActive() {
        return this.isTipsActive;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this) {
            this.isTipsActive = !this.isTipsActive;
            this.setDown(this.isTipsActive);
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        XmlElement el = layout.getFirstElementByName("tip");
        if (el != null) {
            this.searchInActiveOnly = XmlUtils.getBoolean("active_only", el, true);
            this.showWithLayerName = XmlUtils.getBoolean("layername", el, false);
            this.showInCentroid = XmlUtils.getBoolean("centroid", el, false);
            this.fill = XmlUtils.getBoolean("filled", el, true);
            this.fillColor = XmlUtils.getColor("fill", el, Color.yellow);
            this.outline = XmlUtils.getBoolean("outlined", el, true);
            this.outlineColor = XmlUtils.getColor("outline", el, Color.black);
            this.maxWidth = XmlUtils.getInt("width", el, 0);
            if (this.maxWidth < 10) {
                this.maxWidth = 0;
            }
            this.font = XmlUtils.getFont("font", el, MapUtils.defaultPlainFont);
        } else {
            this.font = MapUtils.defaultPlainFont;
        }
        this.map = host.getMapByName(layout);
        this.map.mapListeners.addElement(this);
        this.addActionListener(this);
        super.setParameters(host, layout);
        if (XmlUtils.getBoolean("startup", layout, false)) {
            this.isTipsActive = true;
            this.setDown(true);
        }
        this.st = new SimpleTimer(500L, this);
    }

    public void stop() {
    }

    public void mouseMapPressed(MouseEvent e) {
    }

    public void mouseMapReleased(FloatRectangle selRect, MouseEvent e) {
    }

    public void mouseMapMoved(MouseEvent e) {
        Point ppt;
        FloatPoint pt;
        if ((this.map.getTool() == 5 || this.map.getTool() == 6) && (pt = this.map.screenToMap(ppt = e.getPoint())) != null && this.isTipsActive) {
            this.ptForSearch = ppt;
            if (this.reset != 1) {
                this.reset = 0;
            }
            this.showTips = 11;
            if (this.tooltipInstance != null && this.showTips > 10) {
                this.sTip = null;
                this.tooltipInstance.dispose();
                this.tooltipInstance = null;
            }
        }
    }

    public void afterMapDraw(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerTick() {
        if (!this.map.isProjectLoaded()) {
            return;
        }
        Record rec = null;
        Layer lyr = null;
        if (this.reset == 1 && this.ptForSearch != null) {
            if (this.searchInActiveOnly) {
                lyr = this.map.getActiveLayer();
                if (lyr != null && lyr.canSearch && lyr.isVisibleNow(this.map)) {
                    this.sTip = null;
                    rec = lyr.findAtScreenPoint(this.ptForSearch);
                    if (rec != null) {
                        if (Strings.isNullOrBlank(lyr.tipsMask)) {
                            this.sTip = lyr.getFieldString(rec, lyr.fi_description);
                            if (Strings.isNullOrBlank(this.sTip)) {
                                this.sTip = null;
                            } else if (this.showWithLayerName) {
                                this.sTip = this.sTip + " [" + lyr.getName() + "]";
                            }
                        } else {
                            this.sTip = lyr.getWebLink(lyr.tipsMask, rec, null, new FloatRectangle(this.ptForSearch.x, this.ptForSearch.y, this.ptForSearch.x, this.ptForSearch.y), null);
                        }
                    }
                }
            } else {
                Vector levels = this.map.getProject().renderers;
                int levelCount = levels.size() - 1;
                Vector<Layer> itWasAlready = new Vector<Layer>();
                try {
                    this.sTip = null;
                    for (int i = levelCount; i >= 0; --i) {
                        int rendCount;
                        Vector level = (Vector)levels.elementAt(i);
                        for (int j = rendCount = level.size() - 1; j >= 0; --j) {
                            Renderer rend = null;
                            try {
                                rend = (Renderer)level.elementAt(j);
                                lyr = rend.getLayer();
                                if (!lyr.canSearch || !rend.enabled || itWasAlready.indexOf(lyr) >= 0 || !lyr.isVisibleNow(this.map) || !rend.isRendererVisible(this.map)) continue;
                                rec = lyr.findAtScreenPoint(this.ptForSearch);
                                if (rec != null) {
                                    if (Strings.isNullOrBlank(lyr.tipsMask)) {
                                        this.sTip = lyr.getFieldString(rec, lyr.fi_description);
                                        if (this.showWithLayerName && !Strings.isNullOrBlank(this.sTip)) {
                                            this.sTip = this.sTip + " [" + lyr.getName() + "]";
                                        }
                                    } else {
                                        this.sTip = lyr.getWebLink(lyr.tipsMask, rec, null, new FloatRectangle(this.ptForSearch.x, this.ptForSearch.y, this.ptForSearch.x, this.ptForSearch.y), null);
                                    }
                                    if (Strings.isNullOrBlank(this.sTip)) {
                                        this.sTip = null;
                                    } else {
                                        j = -1;
                                        i = -1;
                                    }
                                }
                                itWasAlready.addElement(lyr);
                                continue;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                }
                finally {
                    itWasAlready.removeAllElements();
                    itWasAlready = null;
                }
            }
            this.ptForShow = new Point(this.ptForSearch);
            this.ptForSearch = null;
            this.reset = 0;
        } else {
            ++this.reset;
        }
        if (!(this.tooltipInstance == null || this.sTip != null && this.sTip.equals(this.previousTip) && this.showTips <= 10)) {
            if (this.showTips > 10) {
                this.sTip = null;
            }
            this.tooltipInstance.dispose();
            this.tooltipInstance = null;
        }
        if (this.sTip != null) {
            if (this.tooltipInstance == null) {
                Graphics g = this.map.getGraphics();
                if (g != null) {
                    try {
                        if (this.showInCentroid && rec != null) {
                            this.ptForShow = new Point(this.map.mapToScreen(rec.getRecordExtent().getCentre()));
                        }
                        this.tooltipInstance = new TipRect(this.sTip, this.font, this.map, this.ptForShow, this.fill, this.outline, this.fillColor, this.outlineColor, this.maxWidth);
                        this.tooltipInstance.paint(g);
                        this.previousTip = this.sTip;
                    }
                    finally {
                        g.dispose();
                    }
                }
                this.showTips = 0;
            }
            this.previousTip = this.sTip;
            ++this.showTips;
        }
    }
}

