/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import org.alov.data.SQLConst;
import org.alov.viewer.GridCellEventListener;

public class LightGrid
extends ScrollPane
implements AdjustmentListener {
    private static final int DEFAULT_COLUMN_WIDTH = 40;
    private static final int DEFAULT_ROW_HEIGHT = 17;
    public int rowHeight = 17;
    public static final String _GRID = "lightgrid";
    private static final byte HEADER = 0;
    private static final byte SELECTED = 1;
    private static final byte NORMAL = 2;
    private static final int MIN_COL_SIZE = 10;
    private static final int EPS = 5;
    protected String[][] cells = null;
    protected int[] colWidths = null;
    protected boolean[] colSort = null;
    public int[] colType = null;
    protected int[] rowHeights = null;
    protected int[] colX = null;
    protected int[] rowY = null;
    private GridCellEventListener gridCellEventListener = null;
    private boolean dontRefresh = false;
    private boolean needUpdate;
    private GridPanel panel;
    private int topVisibleRow = 0;
    private int bottomVisibleRow = 0;
    public boolean colSizing = false;
    private int col = -1;
    private Point lastPressed = null;
    private Cursor oldCursor = null;
    protected boolean[] rowWasEdited = null;
    protected boolean wasEdited = false;
    protected Vector cols = null;
    protected int lastCurrRow = 0;
    public int colCount = 0;
    public int rowCount = 0;
    public int currRow = 1;
    public ColorSelector colorSelector = new DefaultColorSelector();

    public LightGrid() {
        super(1);
        this.setName(_GRID);
        this.setBackground(SystemColor.window);
        this.panel = new GridPanel(this);
        this.add(this.panel);
        Adjustable a = this.getVAdjustable();
        a.setUnitIncrement(17);
        a.setBlockIncrement(85);
        a.addAdjustmentListener(this);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        int v = e.getValue();
        Adjustable a = (Adjustable)e.getSource();
        double r = (double)v * 1.0 / (double)this.rowHeight;
        int k = v / this.rowHeight;
        if (r > (double)k * 1.0) {
            a.setValue((k + 1) * this.rowHeight);
        }
    }

    public String getCell(int col, int row) {
        if (col >= this.colCount || row >= this.rowCount || col < 0 || row < 0) {
            return null;
        }
        return this.cells[row][col];
    }

    public void setCell(int col, int row, String value) {
        if (col < this.colCount && row < this.rowCount && col >= 0 && row >= 0) {
            this.cells[row][col] = value;
        }
    }

    public GridCellEventListener getGridCellEventListener() {
        return this.gridCellEventListener;
    }

    public void setGridCellEventListener(GridCellEventListener listener) {
        this.gridCellEventListener = listener;
    }

    public int getColWidth(int index) {
        if (index >= this.colCount || index < 0) {
            return 0;
        }
        return this.colWidths[index];
    }

    public int getRowHeight(int index) {
        if (index >= this.rowCount || index < 0) {
            return 0;
        }
        return this.rowHeights[index];
    }

    public void setColumnWidth(int index, int width) {
        if (index >= this.colCount || index < 0) {
            return;
        }
        this.colWidths[index] = width;
        this.updated();
    }

    public void setRowHeight(int index, int height) {
        if (index >= this.rowCount || index < 0) {
            return;
        }
        this.rowHeights[index] = height;
        this.updated();
    }

    public void firstRecord() {
        Adjustable a = this.getVAdjustable();
        this.setScrollPosition(new Point(0, a.getMinimum()));
        this.currRow = 0;
        this.cellClick();
        this.updated();
    }

    public void lastRecord() {
        Adjustable a = this.getVAdjustable();
        this.setScrollPosition(new Point(0, a.getMaximum()));
        this.currRow = this.rowCount - 1;
        this.cellClick();
        this.updated();
    }

    public void next() {
        if (this.currRow < this.rowCount - 1) {
            this.setCurrRow(this.currRow + 1);
            this.cellClick();
        }
    }

    public void previous() {
        if (this.currRow > 1) {
            this.setCurrRow(this.currRow - 1);
            this.cellClick();
        }
    }

    private void cellClick() {
        GridCellEventListener el = this.getGridCellEventListener();
        if (el != null) {
            el.gridCellClicked(new Point(0, this.currRow), null);
        }
    }

    public void setCurrRow(int r) {
        if (this.currRow != r) {
            this.currRow = r;
            Adjustable a = this.getVAdjustable();
            int v = a.getValue();
            if (this.currRow < this.topVisibleRow) {
                a.setValue(v - this.rowHeight);
            } else if (this.currRow > this.bottomVisibleRow) {
                a.setValue(v + this.rowHeight);
            }
            this.updated();
        }
    }

    protected String[] getGridRow(int index) {
        if (this.cells != null) {
            String[] row = new String[this.colCount - 1];
            for (int k = 0; k < this.colCount - 1; ++k) {
                row[k] = this.getCell(k, index);
            }
            return row;
        }
        return null;
    }

    protected void setGridRow(String[] row) {
        if (this.cells != null && this.lastCurrRow > 0) {
            this.wasEdited = true;
            this.rowWasEdited[this.lastCurrRow] = true;
            for (int k = 0; k < this.colCount - 1; ++k) {
                this.setCell(k, this.lastCurrRow, row[k]);
            }
        }
    }

    protected void setGridColumn(String[] row) {
        if (this.cells != null && this.lastCurrRow > 0) {
            this.wasEdited = true;
            for (int k = 0; k < this.colCount - 1; ++k) {
                if (this.getCell(k, this.currRow).equalsIgnoreCase(row[k])) continue;
                for (int i = 1; i < this.rowCount; ++i) {
                    this.setCell(k, i, row[k]);
                }
            }
            for (int i = 0; i < this.rowWasEdited.length; ++i) {
                this.rowWasEdited[i] = true;
            }
        }
    }

    public void sort(int L, int R, int Col, boolean bDescent, Compare strat) {
        int I;
        do {
            I = L;
            int J = R;
            int P2 = (L + R) / 2;
            do {
                if (bDescent) {
                    while (strat.compare(this.getCell(Col, P2), this.getCell(Col, I)) < 0) {
                        ++I;
                    }
                    while (strat.compare(this.getCell(Col, P2), this.getCell(Col, J)) > 0) {
                        --J;
                    }
                } else {
                    while (strat.compare(this.getCell(Col, I), this.getCell(Col, P2)) < 0) {
                        ++I;
                    }
                    while (strat.compare(this.getCell(Col, J), this.getCell(Col, P2)) > 0) {
                        --J;
                    }
                }
                if (I > J) continue;
                for (int k = 0; k < this.colCount; ++k) {
                    String tmpStr = this.getCell(k, I);
                    this.setCell(k, I, this.getCell(k, J));
                    this.setCell(k, J, tmpStr);
                }
                if (P2 == I) {
                    P2 = J;
                } else if (P2 == J) {
                    P2 = I;
                }
                ++I;
                --J;
            } while (I <= J);
            if (L < J) {
                this.sort(L, J, Col, bDescent, strat);
            }
            L = I;
        } while (I < R);
    }

    public void beginUpdate() {
        this.dontRefresh = true;
        this.needUpdate = false;
    }

    public void endUpdate() {
        this.dontRefresh = false;
        if (this.needUpdate) {
            this.updateColRowXY();
            this.updateAll();
        }
    }

    private void updated() {
        if (this.dontRefresh) {
            this.needUpdate = true;
        } else {
            this.updateAll();
        }
    }

    public void updateAll() {
        int w = this.colCount > 0 ? this.colX[this.colCount - 1] + this.colWidths[this.colCount - 1] : 0;
        int h = this.rowCount > 0 ? this.rowY[this.rowCount - 1] + this.rowHeights[this.rowCount - 1] : 0;
        this.panel.setSize(w, h);
        this.doLayout();
        this.panel.repaint();
    }

    public boolean setDimension(int w, int h, int defaultHeight) {
        int i;
        if (w < 0) {
            w = 0;
        }
        if (h < 0) {
            h = 0;
        }
        if (this.colCount == w && this.rowCount == h) {
            return false;
        }
        if (this.cols == null) {
            this.cols = new Vector();
        }
        this.colSort = new boolean[w];
        String[][] newCells = new String[h][];
        for (int i2 = 0; i2 < h; ++i2) {
            newCells[i2] = new String[w];
        }
        int toCopyW = w < this.colCount ? w : this.colCount;
        int toCopyH = h < this.rowCount ? h : this.rowCount;
        for (int i3 = 0; i3 < h; ++i3) {
            int pos = 0;
            if (i3 >= toCopyH) continue;
            System.arraycopy(this.cells[i3], 0, newCells[i3], 0, toCopyW);
            pos = toCopyW;
        }
        this.rowHeight = defaultHeight > 0 ? defaultHeight : 17;
        Adjustable a = this.getVAdjustable();
        a.setUnitIncrement(this.rowHeight);
        if (h != this.rowCount) {
            int[] newRowHeights = new int[h];
            if (toCopyH > 0) {
                System.arraycopy(this.rowHeights, 0, newRowHeights, 0, toCopyH);
            }
            for (i = toCopyH; i < h; ++i) {
                newRowHeights[i] = this.rowHeight;
            }
            this.rowHeights = newRowHeights;
        }
        if (w != this.colCount) {
            int[] newColWidths = new int[w];
            if (toCopyW > 0) {
                System.arraycopy(this.colWidths, 0, newColWidths, 0, toCopyW);
            }
            for (i = toCopyW; i < w; ++i) {
                newColWidths[i] = 40;
            }
            this.colWidths = newColWidths;
        }
        this.colCount = w;
        this.rowCount = h;
        this.cells = newCells;
        this.updateColRowXY();
        this.setScrollPosition(0, 0);
        this.currRow = 1;
        this.updated();
        return true;
    }

    public void updateColRowXY() {
        int i;
        int w = this.colCount;
        int h = this.rowCount;
        int[] xs = this.colX;
        int[] ys = this.rowY;
        if (xs == null || xs.length != w) {
            xs = new int[w];
        }
        if (ys == null || ys.length != h) {
            ys = new int[h];
        }
        if (w > 0) {
            xs[0] = 0;
        }
        if (h > 0) {
            ys[0] = 0;
        }
        for (i = 1; i < w; ++i) {
            xs[i] = xs[i - 1] + this.colWidths[i - 1];
        }
        for (i = 1; i < h; ++i) {
            ys[i] = ys[i - 1] + this.rowHeights[i - 1];
        }
        this.colX = xs;
        this.rowY = ys;
    }

    public Rectangle getVisibleArea() {
        int i;
        Point sp = this.getScrollPosition();
        Insets insets = this.getInsets();
        Dimension d = this.getSize();
        d.width -= insets.left + insets.right;
        d.height -= insets.top + insets.bottom;
        int w = this.colCount;
        int h = this.rowCount;
        int[] xs = this.colX;
        int[] ys = this.rowY;
        int[] ws = this.colWidths;
        int[] hs = this.rowHeights;
        int xoff = sp.x;
        int yoff = sp.y;
        int xoff2 = xoff + d.width - 1;
        int yoff2 = yoff + d.height - 1;
        int x1 = -1;
        int x2 = -2;
        int y1 = -1;
        int y2 = -2;
        for (i = 0; i < w; ++i) {
            if (xs[i] <= xoff2 && xs[i] + ws[i] >= xoff) {
                if (x1 < 0) {
                    x1 = i;
                }
                x2 = i;
                continue;
            }
            if (x1 >= 0) break;
        }
        for (i = 0; i < h; ++i) {
            if (ys[i] <= yoff2 && ys[i] + hs[i] > yoff) {
                if (y1 < 0) {
                    y1 = i;
                }
                y2 = i;
                continue;
            }
            if (y1 >= 0) break;
        }
        this.topVisibleRow = y1 + 1;
        this.bottomVisibleRow = y2;
        return new Rectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
    }

    public Point getCellAt(Point pt) {
        int x = pt.x;
        int cx = -1;
        int w = this.colCount;
        for (int i = 0; i < w; ++i) {
            int colx = this.colX[i];
            if (x < colx || x >= colx + this.colWidths[i]) continue;
            cx = i;
            break;
        }
        if (cx < 0) {
            return null;
        }
        int cy = -1;
        int y = pt.y;
        int h = this.rowCount;
        Point sp = this.getScrollPosition();
        if (h > 0 && y - sp.y < this.rowHeights[0]) {
            cy = 0;
        } else {
            for (int i = 0; i < h; ++i) {
                int coly = this.rowY[i];
                if (y < coly || y >= coly + this.rowHeights[i]) continue;
                cy = i;
                break;
            }
        }
        if (cy < 0) {
            return null;
        }
        return new Point(cx, cy);
    }

    protected void drawCell2(Rectangle rect, Graphics g, String s, byte mode, int row, int column) {
        g.setColor(this.colorSelector.getCellColor(row, column, mode == 0, mode == 1));
        if (mode == 0) {
            int rx = rect.x;
            int ry = rect.y;
            int rw = rect.width;
            int rh = rect.height;
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(rx + rw - 2, ry, rx + rw - 2, ry + rh - 2);
            g.drawLine(rx, ry + rh - 2, rx + rw - 2, ry + rh - 2);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(rx, ry, rx + rw - 1, ry);
            g.drawLine(rx, ry, rx, ry + rh - 1);
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(rx + rw - 1, ry, rx + rw - 1, ry + rh - 1);
            g.drawLine(rx, ry + rh - 1, rx + rw - 1, ry + rh - 1);
        } else {
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(this.getForeground());
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
        g.setColor(this.colorSelector.getFontColor(row, column, mode == 0, mode == 1));
        Font f = g.getFont();
        int y = rect.y + (rect.height + f.getSize()) / 2 - 2;
        if (s != null) {
            g.drawString(s, rect.x + 2, y);
        }
    }

    protected void setUnEdited() {
        this.wasEdited = false;
        this.rowWasEdited = new boolean[this.rowCount];
    }

    public void addColDef(String label, int colType, boolean editable, int index) {
        ColDef cd = new ColDef(label, colType, editable, index);
        this.cols.addElement(cd);
    }

    protected int getColDefIndex(int colNumber) {
        ColDef cd = (ColDef)this.cols.get(colNumber);
        return cd.index;
    }

    protected boolean getColDefEditable(int colNumber) {
        ColDef cd = (ColDef)this.cols.get(colNumber);
        return cd.editable;
    }

    private class ColDef {
        String label;
        int colType;
        boolean editable;
        int index;

        public ColDef(String label, int colType, boolean editable, int index) {
            this.label = label;
            this.colType = colType;
            this.editable = editable;
            this.index = index;
        }
    }

    private class DefaultColorSelector
    implements ColorSelector {
        private DefaultColorSelector() {
        }

        public Color getCellColor(int row, int column, boolean header, boolean selected) {
            return header ? SystemColor.control : (selected ? SystemColor.activeCaption : LightGrid.this.getBackground());
        }

        public Color getFontColor(int row, int column, boolean header, boolean selected) {
            return selected ? SystemColor.activeCaptionText : LightGrid.this.getForeground();
        }
    }

    public static interface ColorSelector {
        public Color getCellColor(int var1, int var2, boolean var3, boolean var4);

        public Color getFontColor(int var1, int var2, boolean var3, boolean var4);
    }

    private class GridPanel
    extends Canvas
    implements MouseListener,
    KeyListener,
    MouseMotionListener {
        private LightGrid parentGrid = null;

        GridPanel(LightGrid parentGrid) {
            this.parentGrid = parentGrid;
            this.addMouseListener(this);
            this.addKeyListener(this);
            this.addMouseMotionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaint() {
            Graphics g = this.getGraphics();
            if (g != null) {
                try {
                    this.paint(g);
                }
                finally {
                    g.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            LightGrid parent = this.parentGrid;
            if (parent.cells == null) {
                return;
            }
            Rectangle visible = parent.getVisibleArea();
            if (visible == null) {
                return;
            }
            int x1 = visible.x;
            int y1 = visible.y;
            int x2 = x1 + visible.width - 1;
            int y2 = y1 + visible.height - 1;
            if (x1 < 0 || y1 < 0 || x2 < 0 || y2 < 0) {
                return;
            }
            Rectangle rect = new Rectangle();
            int areaXFrom = parent.colX[x1];
            int areaXTo = parent.colX[x2] + parent.getColWidth(x2);
            int areaYFrom = parent.rowY[y1];
            int areaW = areaXTo - areaXFrom;
            int areaYTo = parent.rowY[y2] + parent.getRowHeight(y2);
            int areaH = areaYTo - areaYFrom;
            Image img = this.createImage(areaW, areaH);
            if (img == null) {
                return;
            }
            Graphics g2 = img.getGraphics();
            try {
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, areaW, areaH);
                int oldCurrRow = LightGrid.this.currRow;
                if (LightGrid.this.currRow <= y1) {
                    LightGrid.this.currRow = y1 + 1;
                } else if (LightGrid.this.currRow > y2 && y2 > 0) {
                    LightGrid.this.currRow = y2;
                }
                for (int i = x1; i <= x2; ++i) {
                    int colX = parent.colX[i] - areaXFrom;
                    int colW = parent.getColWidth(i);
                    g2.setClip(null);
                    g2.clipRect(colX, 0, colW, areaH);
                    for (int j = y1; j <= y2; ++j) {
                        rect.setBounds(colX, parent.rowY[j] - areaYFrom, colW, parent.getRowHeight(j));
                        LightGrid.this.drawCell2(rect, g2, parent.cells[j][i], j == LightGrid.this.currRow ? (byte)1 : 2, j, i);
                    }
                }
                Point sp = parent.getScrollPosition();
                int yoff = sp.y;
                Adjustable a = LightGrid.this.getVAdjustable();
                int v = a.getValue();
                for (int i = x1; i <= x2; ++i) {
                    int colX = parent.colX[i] - areaXFrom;
                    int colW = parent.getColWidth(i);
                    g2.setClip(null);
                    g2.clipRect(colX, yoff - areaYFrom, colW, parent.getRowHeight(0));
                    rect.setBounds(colX, yoff - areaYFrom, colW, parent.getRowHeight(0));
                    g2.setColor(this.getBackground());
                    g2.fillRect(colX, yoff - areaYFrom, colW, parent.getRowHeight(0));
                    LightGrid.this.drawCell2(rect, g2, LightGrid.this.cells[0][i], (byte)0, 0, i);
                }
                g.setClip(null);
                g.setColor(this.getBackground());
                Dimension size = this.getSize();
                g.fillRect(0, 0, size.width, size.height);
                g.drawImage(img, areaXFrom, areaYFrom, null);
                img.flush();
                if (LightGrid.this.currRow != oldCurrRow) {
                    LightGrid.this.cellClick();
                }
            }
            finally {
                g2.dispose();
            }
        }

        public Dimension getPreferredSize() {
            LightGrid parent = this.parentGrid;
            int w = parent.colCount;
            int h = parent.rowCount;
            if (h <= 0 || h <= 0) {
                return new Dimension(0, 0);
            }
            return new Dimension(parent.colX[--w] + parent.getColWidth(w), parent.rowY[--h] + parent.getRowHeight(h));
        }

        protected void CheckMousePos(MouseEvent e) {
            boolean resizeOn;
            LightGrid.this.lastPressed = e.getPoint();
            Point mousePos = LightGrid.this.getCellAt(LightGrid.this.lastPressed);
            boolean bl = resizeOn = null != mousePos && 0 == mousePos.y;
            if (resizeOn) {
                LightGrid.this.col = mousePos.x;
                if (((LightGrid)LightGrid.this).lastPressed.x - LightGrid.this.colX[LightGrid.this.col] <= 5) {
                    --LightGrid.this.col;
                } else if (LightGrid.this.colX[LightGrid.this.col] + LightGrid.this.colWidths[LightGrid.this.col] - ((LightGrid)LightGrid.this).lastPressed.x > 5) {
                    LightGrid.this.col = -1;
                    LightGrid.this.lastPressed = null;
                    resizeOn = false;
                }
            } else {
                LightGrid.this.lastPressed = null;
                LightGrid.this.col = -1;
            }
            if (resizeOn) {
                if (null == LightGrid.this.oldCursor) {
                    LightGrid.this.oldCursor = this.getCursor();
                    this.setCursor(new Cursor(10));
                }
            } else if (null != LightGrid.this.oldCursor) {
                this.setCursor(LightGrid.this.oldCursor);
                LightGrid.this.oldCursor = null;
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (LightGrid.this.dontRefresh) {
                return;
            }
            Point p = this.parentGrid.getCellAt(e.getPoint());
            if (p != null) {
                GridCellEventListener el = this.parentGrid.getGridCellEventListener();
                if (p.y == 0) {
                    this.parentGrid.beginUpdate();
                    if (SQLConst.isNumber(this.parentGrid.colType[p.x])) {
                        this.parentGrid.sort(1, this.parentGrid.rowCount - 1, p.x, this.parentGrid.colSort[p.x], new CompareNumber());
                    } else {
                        this.parentGrid.sort(1, this.parentGrid.rowCount - 1, p.x, this.parentGrid.colSort[p.x], new CompareString());
                    }
                    this.parentGrid.endUpdate();
                    this.parentGrid.updateAll();
                    boolean bl = this.parentGrid.colSort[p.x] = !this.parentGrid.colSort[p.x];
                }
                if (p.y > 0) {
                    this.parentGrid.setCurrRow(p.y);
                }
                if (el != null) {
                    el.gridCellClicked(p, e);
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            if (LightGrid.this.colSizing && 16 == e.getModifiers()) {
                this.CheckMousePos(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (null != LightGrid.this.oldCursor) {
                this.setCursor(LightGrid.this.oldCursor);
            }
            if (LightGrid.this.colSizing && 16 == e.getModifiers() && 0 <= LightGrid.this.col && null != LightGrid.this.lastPressed) {
                int delta = e.getPoint().x - ((LightGrid)LightGrid.this).lastPressed.x;
                if (0 < LightGrid.this.col && 0 > delta && -delta >= LightGrid.this.colWidths[LightGrid.this.col] - 10) {
                    delta = -(LightGrid.this.colWidths[LightGrid.this.col] - 10);
                }
                int n = LightGrid.this.col++;
                LightGrid.this.colWidths[n] = LightGrid.this.colWidths[n] + delta;
                int i = LightGrid.this.col;
                while (i < LightGrid.this.colCount) {
                    int n2 = i++;
                    LightGrid.this.colX[n2] = LightGrid.this.colX[n2] + delta;
                }
                LightGrid.this.col = -1;
                LightGrid.this.lastPressed = null;
                this.repaint();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            if (null != LightGrid.this.oldCursor) {
                this.setCursor(LightGrid.this.oldCursor);
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (LightGrid.this.colSizing) {
                this.CheckMousePos(e);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (LightGrid.this.dontRefresh) {
                return;
            }
            int k = e.getKeyCode();
            if (k == 40 || k == 38) {
                int r = this.parentGrid.currRow;
                if (r > 0) {
                    if (k == 38 && r > 1) {
                        --r;
                    } else if (k == 40 && r < this.parentGrid.rowCount - 1) {
                        ++r;
                    }
                }
                this.parentGrid.setCurrRow(r);
                GridCellEventListener el = this.parentGrid.getGridCellEventListener();
                if (el != null) {
                    el.gridCellClicked(new Point(0, r), e);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class CompareNumber
    implements Compare {
        private CompareNumber() {
        }

        public int compare(String s1, String s2) {
            Float f1 = new Float(Float.parseFloat(s1));
            Float f2 = new Float(Float.parseFloat(s2));
            return f1.compareTo(f2);
        }
    }

    private class CompareString
    implements Compare {
        private CompareString() {
        }

        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }

    public static interface Compare {
        public int compare(String var1, String var2);
    }
}

