/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.DisplayContext;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.Projection;
import org.alov.map.Renderer;
import org.alov.map.RendererChart;
import org.alov.map.RendererDef;
import org.alov.map.RendererDot;
import org.alov.map.RendererGrad;
import org.alov.map.RendererLabel;
import org.alov.map.Shape;
import org.alov.map.StatusListener;
import org.alov.map.Symbol;
import org.alov.tm.MultiAnimation;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.LayerControlItem;
import org.alov.viewer.LayerCtlImpl;

public class LayerCtl
extends ScrollPane
implements CarteHostListener,
StatusListener {
    private CarteHost host;
    private LayerCtlImpl impl = new LayerCtlImpl(this);
    private static final double[] ptCoords = new double[]{0.0, 0.0};
    private static final double[] lineCoords = new double[]{-6.0, -6.0, -2.0, 6.0, 2.0, -6.0, 6.0, 6.0};
    private static final double[] polygonCoords = new double[]{-5.0, -8.0, -3.0, -4.0, -8.0, -1.0, -3.0, 2.0, -5.0, 8.0, 4.0, 5.0, 8.0, 8.0, 8.0, -8.0, 4.0, -7.0};
    private static final Shape shpPoint = new Shape(ptCoords);
    private static final Shape shpLine = new Shape(lineCoords);
    private static final Shape shpPolygon = new Shape(polygonCoords);

    LayerCtl() {
        this.add(this.impl);
    }

    private Dimension minSize() {
        Insets insets = this.getInsets();
        Dimension d = new Dimension(this.impl.getPreferredSize());
        int w = this.getVScrollbarWidth();
        d.width += insets.right + insets.left;
        d.height += insets.top + insets.bottom;
        return d;
    }

    void setLayers(Vector v) {
        this.impl.setLayers(v);
    }

    void setMap(Carte m) {
        this.impl.setMap(m);
    }

    void setWidth(int width) {
        this.impl.legendWidth = width;
        this.impl.minSize = new Dimension(this.impl.legendWidth, 10);
    }

    void clear() {
        this.impl.clear();
    }

    void selectItem(String layerId) {
        this.impl.selectItem(layerId);
    }

    Layer getSelected() {
        return this.impl.getSelected();
    }

    public static BufferedImage paintLayers(Vector layers, DisplayContext dc, Color bgColor, int width, int height) {
        return LayerCtlImpl.paintLayers(layers, dc, bgColor, width, height);
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.host = host;
        this.impl.selectionColor = XmlUtils.getColor("select_clr", layout, this.impl.selectionColor);
        this.impl.disabledColor = XmlUtils.getColor("disabled_clr", layout, SystemColor.textInactiveText);
        this.impl.failureColor = XmlUtils.getColor("err_color", layout, SystemColor.textInactiveText);
        this.impl.networkColor = XmlUtils.getColor("net_color", layout, this.impl.networkColor);
        this.impl.drawSeparator = XmlUtils.getBoolean("separator", layout, false);
        this.impl.drawSelection = XmlUtils.getBoolean("selection", layout, true);
        this.impl.compactSingleRend = XmlUtils.getBoolean("compact", layout, false);
        this.impl.fontBold = XmlUtils.getFont("font_bold", layout, MapUtils.defaultBoldFont);
        this.impl.fontPlain = XmlUtils.getFont("font_plain", layout, MapUtils.defaultPlainFont);
        this.impl.imageClock = host.getImage(XmlUtils.getString("image_clock", layout, null));
        this.impl.imageZoomIn = host.getImage(XmlUtils.getString("image_zoomin", layout, null));
        this.impl.imageZoomOut = host.getImage(XmlUtils.getString("image_zoomout", layout, null));
        this.impl.imageNetwork = host.getImage(XmlUtils.getString("image_network", layout, null));
        this.impl.imageOutExt = host.getImage(XmlUtils.getString("image_outext", layout, null));
        this.impl.imageKey = host.getImage(XmlUtils.getString("image_key", layout, null));
        this.impl.imageChecked = host.getImage(XmlUtils.getString("image_checked", layout, null));
        this.impl.imageUncheck = host.getImage(XmlUtils.getString("image_uncheck", layout, null));
        String sync = XmlUtils.getString("sync_with", layout, null);
        if (sync != null) {
            StringTokenizer st = new StringTokenizer(sync, " ,;");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                this.impl.sync_with.addElement(tok);
            }
        }
        this.clear();
        Carte map = host.getMapByName(layout);
        map.statusListeners.addElement(this);
        this.setMap(map);
    }

    public void stop() {
    }

    public void afterProjectLoaded(boolean bSuccess) {
        if (bSuccess) {
            Project project = this.impl.map.getProject();
            if (project != null) {
                this.impl.setLayers(project.layers);
                this.impl.selectItem(project.startLayer);
            }
            int c = this.impl.sync_with.size();
            for (int i = 0; i < c; ++i) {
                String tok = (String)this.impl.sync_with.elementAt(i);
                Component cmp = this.host.findComponent(tok);
                if (!(cmp instanceof LayerCtl)) continue;
                this.impl.sync_with.setElementAt(cmp, i);
            }
        }
    }

    public void notifyStatus(int code, Object obj) {
        if (code == 106 || code == 108 || code == 109 || code == 107) {
            this.impl.mapUpdated();
        } else if (code == 11 && obj == null || code == -8) {
            if (this.impl.items != null) {
                int count = this.impl.items.length;
                for (int i = 0; i < count; ++i) {
                    LayerControlItem lci = this.impl.items[i];
                    Layer lyr = lci.getLayer();
                    if (lyr.metadata.networkActivity || lci.animation == null) continue;
                    MultiAnimation.stopAnimation(lci.animation);
                    lci.animation = null;
                }
            }
            this.impl.mapUpdated();
        } else if (code == 111 || code == 116) {
            String sId = this.impl.map.getActiveLayer().id;
            Project project = this.impl.map.getProject();
            this.impl.setLayers(project.layers);
            this.impl.selectItem(sId);
        } else if (code == 101 && obj != null && obj instanceof String) {
            if (this.impl.sync_with.size() > 0) {
                this.impl.synchronyzeLegends((String)obj);
            }
            this.impl.mapUpdated();
        } else if (code == 118 && obj != null) {
            this.impl.changeLayerVisibility((Object[])obj);
            if (this.impl.map != null) {
                this.impl.map.updateMap();
            }
            this.impl.repaint();
        }
    }

    public static void paintSample(Graphics g, Rectangle rect, Renderer rend) {
        if (rend instanceof RendererGrad || rend instanceof RendererDef || rend instanceof RendererDot) {
            Shape shp = null;
            Color clr = g.getColor();
            Layer layer = rend.getLayer();
            Projection prj = new Projection();
            int count = rend.getSymbolCount();
            int curY = 0;
            for (int i = 0; i < count; ++i) {
                Symbol sym = rend.getSymbol(i);
                if (!sym.legendVisible) continue;
                int objectType = 1;
                if (!sym.drawMarker) {
                    int n = objectType = layer.isObjectType(-1) ? layer.legendObjectType : layer.dataStorage.getObjectType();
                }
                if (layer.legendSymbolShape != null) {
                    shp = layer.legendSymbolShape;
                    if (layer.legendObjectType > 0) {
                        objectType = layer.legendObjectType;
                    }
                } else {
                    switch (objectType) {
                        case 1: {
                            shp = shpPoint;
                            break;
                        }
                        case 2: {
                            shp = shpLine;
                            break;
                        }
                        case 3: {
                            shp = shpPolygon;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                int symHeight = sym.sampleSize.width;
                int totHeight = Math.max(symHeight, sym.sampleSize.height);
                prj.shift.x = rect.x + symHeight / 2;
                prj.shift.y = rect.y + totHeight / 2 + curY;
                Shape.paintShape(shp, g, prj, sym, objectType);
                g.setColor(clr);
                MapUtils.drawString(g, sym.label, rect.x + symHeight + 4, rect.y + curY, rect.width - symHeight - 4, totHeight, layer.legendWrapText);
                curY += totHeight;
            }
        } else if (rend instanceof RendererChart) {
            RendererChart rend2 = (RendererChart)rend;
            rend2.paintSampleChart(g, rect);
        } else if (rend instanceof RendererLabel) {
            int x = rect.x;
            int y = rect.y;
            int count = rend.getSymbolCount();
            int curY = 0;
            Font prevFont = g.getFont();
            for (int i = 0; i < count; ++i) {
                Symbol sym = rend.getSymbol(i);
                if (!sym.legendVisible || sym.sampleFont == null) continue;
                String s = sym.label;
                g.setFont(sym.sampleFont);
                int symHeight = sym.sampleSize.height;
                if (sym.outline) {
                    g.setColor(sym.outlineColor);
                    g.drawString(s, rect.x + 11, rect.y + symHeight + curY + 1);
                }
                g.setColor(sym.fillColor);
                g.drawString(s, rect.x + 10, rect.y + symHeight + curY);
                curY += symHeight;
            }
            g.setFont(prevFont);
        }
    }
}

