/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import org.alov.map.Carte;

class FrameStatus
extends Frame
implements ActionListener {
    protected Carte map = null;
    Button btnClose;
    Button btnHelp;
    TextArea taMain = new TextArea();

    public FrameStatus(Carte map) {
        this.map = map;
        this.setTitle(map.getResource("LOG"));
        Label lbl = new Label(map.getResource_("CopyClip"));
        this.btnClose = new Button(map.getResource("Close"));
        this.btnHelp = new Button(map.getResource("Explanation of error codes"));
        Panel buttonsPanel = new Panel();
        buttonsPanel.add(lbl);
        buttonsPanel.add(this.btnHelp);
        buttonsPanel.add(this.btnClose);
        this.add((Component)this.taMain, "Center");
        this.addWindowListener(new WindowEventHandler());
        this.add((Component)buttonsPanel, "South");
        this.btnHelp.addActionListener(this);
        this.btnClose.addActionListener(this);
        this.pack();
        Font fnt = this.getFont();
        lbl.setFont(new Font(fnt.getName(), fnt.getStyle(), fnt.getSize() - 2));
        int w = 620;
        int h = 400;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((d.width - w) / 2, (d.height - h) / 2, w, h);
    }

    public void load(Vector status) {
        int count = status.size();
        this.taMain.setRows(count);
        this.taMain.setText("");
        for (int i = 0; i < count; ++i) {
            this.taMain.append((String)status.elementAt(i) + '\n');
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o == this.btnClose) {
            this.dispose();
        } else if (o == this.btnHelp) {
            int k1;
            int pos = this.taMain.getCaretPosition();
            String s = this.taMain.getText();
            int k2 = s.indexOf("ERROR#", k1 = s.lastIndexOf(10, pos)) - 2;
            if (k2 < 1) {
                k2 = s.indexOf("WARNING#", k1);
            }
            s = k2 > 0 && k2 > k1 ? s.substring(k2 + 7, k2 + 11).trim() : "";
            this.map.showURL("TMJavaResources/errors.html" + s);
        }
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            FrameStatus.this.dispose();
        }
    }
}

