/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.StatusListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class Animation
extends Canvas
implements Runnable,
ImageObserver,
StatusListener,
CarteHostListener {
    private Image image;
    private boolean stop = true;
    private boolean running = false;
    private boolean isStill = true;
    private int width;
    private int height;
    private int delay = 300;
    private boolean isStretched = false;
    private boolean isTiled = false;
    private int proxyOperCount = 0;

    public void setImage(Image img, int w, int h) {
        this.image = img;
        this.width = w;
        this.height = h;
    }

    public void showImage() {
        this.delay = 1000;
        this.showAnimation();
        this.isStill = true;
    }

    public void showAnimation() {
        if (!this.running) {
            this.isStill = false;
            this.running = true;
            this.stop = false;
            new Thread((Runnable)this, "Animation update thread").start();
            this.setVisible(true);
        }
    }

    public void hideAnimation() {
        this.running = false;
        this.stop = true;
        this.setVisible(false);
    }

    public void paint(Graphics g) {
        if (this.running) {
            this.paintImage(g);
        }
    }

    private void paintImage(Graphics g) {
        if (g != null && this.image != null) {
            Dimension d = this.getSize();
            int w = this.image.getWidth(null);
            int h = this.image.getHeight(null);
            if (w > 0 && h > 0) {
                if (this.isTiled) {
                    for (int yCurrent = 0; yCurrent < d.height; yCurrent += h) {
                        for (int xCurrent = 0; xCurrent < d.width; xCurrent += w) {
                            g.drawImage(this.image, xCurrent, yCurrent, this);
                        }
                    }
                } else if (this.isStretched) {
                    g.drawImage(this.image, 0, 0, d.width, d.height, 0, 0, w, h, this);
                } else {
                    int x = (d.width - w) / 2;
                    int y = (d.height - h) / 2;
                    g.drawImage(this.image, x, y, null);
                }
                this.stop = this.isStill;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            Graphics g = this.getGraphics();
            if (g != null) {
                try {
                    this.paintImage(g);
                }
                finally {
                    g.dispose();
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.repaint();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return (infoflags & 0x20) == 0;
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.isTiled = XmlUtils.getBoolean("tiled", layout, false);
        this.isStretched = XmlUtils.getBoolean("stretched", layout, false);
    }

    public void stop() {
    }

    public void afterProjectLoaded(boolean bSuccess) {
    }

    public void notifyStatus(int code, Object obj) {
        if (obj == null) {
            if (code == 10) {
                ++this.proxyOperCount;
                this.showAnimation();
            } else if (code == 11) {
                --this.proxyOperCount;
                if (this.proxyOperCount <= 0) {
                    this.hideAnimation();
                    this.proxyOperCount = 0;
                }
            }
        }
    }
}

