/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.alov.map.FloatRectangle;
import org.alov.util.LangDriver;
import org.alov.util.Strings;

public class Readers {
    public static String ENCODING = "";
    public static LangDriver langDriver = null;

    private Readers() {
    }

    public static Color readColor(InputStream is) throws IOException {
        return new Color(is.read(), is.read(), is.read());
    }

    public static long readLong(InputStream is) throws IOException {
        return Readers.readInt(is) | Readers.readInt(is) << 32;
    }

    public static double readDouble(InputStream is) throws IOException {
        return Double.longBitsToDouble((long)is.read() & 0xFFL | ((long)is.read() & 0xFFL) << 8 | ((long)is.read() & 0xFFL) << 16 | ((long)is.read() & 0xFFL) << 24 | ((long)is.read() & 0xFFL) << 32 | ((long)is.read() & 0xFFL) << 40 | ((long)is.read() & 0xFFL) << 48 | ((long)is.read() & 0xFFL) << 56);
    }

    public static float readFloat(InputStream is) throws IOException {
        return Float.intBitsToFloat(Readers.readInt(is));
    }

    public static int readInt(InputStream is) throws IOException {
        return is.read() + (is.read() << 8) + (is.read() << 16) + (is.read() << 24);
    }

    public static int readShort(InputStream is) throws IOException {
        return is.read() + (is.read() << 8);
    }

    public static FloatRectangle readRectangleLittle(InputStream is) throws IOException {
        return new FloatRectangle(Readers.readDouble(is), Readers.readDouble(is), Readers.readDouble(is), Readers.readDouble(is));
    }

    public static FloatRectangle readRect(InputStream in) throws IOException {
        return new FloatRectangle(Readers.readFloat(in), Readers.readFloat(in), Readers.readFloat(in), Readers.readFloat(in));
    }

    public static String readUTFCond(DataInputStream is) throws IOException {
        if (is.read() != 0) {
            return is.readUTF();
        }
        return null;
    }

    public static String Read2Unicode(String s, String encoding) {
        if (s == null) {
            return "";
        }
        if (Strings.isNullOrBlank(encoding)) {
            return langDriver == null ? s : langDriver.read2Unicode(s);
        }
        try {
            int len = s.length();
            byte[] bytes = new byte[s.length()];
            for (int i = 0; i < len; ++i) {
                bytes[i] = (byte)s.charAt(i);
            }
            s = new String(bytes, encoding);
            return s;
        }
        catch (Exception e) {
            return s;
        }
    }
}

