/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class LittleEndianOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    protected void incCount(int value) {
        int temp = this.written + value;
        if (temp < 0) {
            temp = Integer.MAX_VALUE;
        }
        this.written = temp;
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
        this.incCount(1);
    }

    public final void writeByte(int v) throws IOException {
        this.out.write(v);
        this.incCount(1);
    }

    public final void writeShort(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        this.incCount(2);
    }

    public final void writeChar(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        this.incCount(2);
    }

    public final void writeInt(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 24 & 0xFF);
        this.incCount(4);
    }

    public final void writeLong(long v) throws IOException {
        OutputStream out = this.out;
        out.write((int)(v >>> 0) & 0xFF);
        out.write((int)(v >>> 8) & 0xFF);
        out.write((int)(v >>> 16) & 0xFF);
        out.write((int)(v >>> 24) & 0xFF);
        out.write((int)(v >>> 32) & 0xFF);
        out.write((int)(v >>> 40) & 0xFF);
        out.write((int)(v >>> 48) & 0xFF);
        out.write((int)(v >>> 56) & 0xFF);
        this.incCount(8);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeBytes(String s) throws IOException {
        OutputStream out = this.out;
        int len = s.length();
        int i = 0;
        while (i < len) {
            out.write((byte)s.charAt(i));
            ++i;
        }
        this.incCount(len);
    }

    public final void writeChars(String s) throws IOException {
        OutputStream out = this.out;
        int len = s.length();
        int i = 0;
        while (i < len) {
            char v = s.charAt(i);
            out.write(v >>> 0 & 0xFF);
            out.write(v >>> 8 & 0xFF);
            ++i;
        }
        this.incCount(len * 2);
    }

    public final void writeUTF(String str) throws IOException {
        LittleEndianOutputStream.writeUTF(str, this);
    }

    static int writeUTF(String str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        int i = 0;
        while (i < strlen) {
            c = charr[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            c = charr[i2];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 0 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 12 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 0 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
            }
            ++i2;
        }
        out.write(bytearr);
        return utflen + 2;
    }

    public final int size() {
        return this.written;
    }
}

