/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.awt.geom.Rectangle2D;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    private static void swapByteArray(byte[] b, int off, int len) {
        int c = len / 2;
        int i = 0;
        while (i < c) {
            int n = i + off;
            b[n] = (byte)(b[n] ^ b[off + len - 1 - i]);
            int n2 = off + len - 1 - i;
            b[n2] = (byte)(b[n2] ^ b[i + off]);
            int n3 = i + off;
            b[n3] = (byte)(b[n3] ^ b[off + len - 1 - i]);
            ++i;
        }
    }

    public final int read(byte[] b) throws IOException {
        return this.in.read(b, 0, b.length);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    private final void readFullyUsingOrder(byte[] b, int off, int len, boolean isLittleOrder) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = this.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        if (isLittleOrder) {
            LittleEndianInputStream.swapByteArray(b, off, len);
        }
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.readFullyUsingOrder(b, off, len, true);
    }

    public final int skipBytes(int n) throws IOException {
        InputStream in = this.in;
        int total = 0;
        int cur = 0;
        while (total < n && (cur = (int)in.skip(n - total)) > 0) {
            total += cur;
        }
        return total;
    }

    public final boolean readBoolean() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public final byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public final int readUnsignedByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public final short readShort() throws IOException {
        int ch2;
        InputStream in = this.in;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 0) + (ch2 << 8));
    }

    public final int readUnsignedShort() throws IOException {
        int ch2;
        InputStream in = this.in;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 0) + (ch2 << 8);
    }

    public final char readChar() throws IOException {
        int ch2;
        InputStream in = this.in;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 0) + (ch2 << 8));
    }

    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        InputStream in = this.in;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 0) + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
    }

    public final long readLong() throws IOException {
        InputStream in = this.in;
        int i1 = this.readInt();
        int i2 = this.readInt();
        return ((long)i2 << 32) + ((long)i1 & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        byte[] b = new byte[8];
        this.readFullyUsingOrder(b, 0, 8, false);
        return Double.longBitsToDouble((long)b[0] & 0xFFL | ((long)b[1] & 0xFFL) << 8 | ((long)b[2] & 0xFFL) << 16 | ((long)b[3] & 0xFFL) << 24 | ((long)b[4] & 0xFFL) << 32 | ((long)b[5] & 0xFFL) << 40 | ((long)b[6] & 0xFFL) << 48 | ((long)b[7] & 0xFFL) << 56);
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("Method readLine() does not suported.");
    }

    public final String readUTF() throws IOException {
        throw new UnsupportedOperationException("Method readUTF() does not suported.");
    }

    public Rectangle2D readRectangle() throws IOException {
        double xmin = this.readDouble();
        double ymin = this.readDouble();
        return new Rectangle2D.Double(xmin, ymin, this.readDouble() - xmin, this.readDouble() - ymin);
    }
}

