/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.alov.util.IntRange;

public class IntRangeSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    private List ranges = new ArrayList();

    private void internalAdd(IntRange range) {
        this.ranges.add(range);
    }

    public IntRange getRange(int index) {
        return (IntRange)this.ranges.get(index);
    }

    public int getRangeCount() {
        return this.ranges.size();
    }

    private void improveRange(int index) {
        IntRange next;
        IntRange prev = index <= 0 ? null : (IntRange)this.ranges.get(index - 1);
        IntRange current = index < 0 ? null : (IntRange)this.ranges.get(index);
        IntRange intRange = next = index >= this.ranges.size() - 1 ? null : (IntRange)this.ranges.get(index + 1);
        if (current != null) {
            if (next != null && current.add(next)) {
                this.ranges.remove(next);
            }
            if (prev != null && prev.add(current)) {
                this.ranges.remove(current);
            }
        }
    }

    public boolean add(Object o) {
        if (o instanceof Integer) {
            int value = (Integer)o;
            boolean result = true;
            Iterator iter = this.ranges.iterator();
            while (iter.hasNext()) {
                IntRange range = (IntRange)iter.next();
                if (!range.includes(value)) continue;
                result = false;
                break;
            }
            if (result) {
                boolean added = false;
                int index = -1;
                iter = this.ranges.iterator();
                while (iter.hasNext()) {
                    ++index;
                    IntRange range = (IntRange)iter.next();
                    if (!range.add(value)) continue;
                    added = true;
                    break;
                }
                if (added) {
                    this.improveRange(index);
                } else {
                    this.internalAdd(new IntRange(value, value));
                    Collections.sort(this.ranges);
                }
            }
            return result;
        }
        throw new UnsupportedOperationException();
    }

    public int size() {
        int result = 0;
        Iterator iter = this.ranges.iterator();
        while (iter.hasNext()) {
            IntRange range = (IntRange)iter.next();
            result += range.size();
        }
        return result;
    }

    public Iterator iterator() {
        return new IntRangeSetItr();
    }

    public String toString() {
        return this.ranges.toString();
    }

    public class IntRangeSetItr
    implements Iterator {
        int value;
        int index = -1;
        IntRange currentRange;
        boolean nextCalled = false;

        public IntRangeSetItr() {
            this.nextRange();
        }

        private void nextRange() {
            ++this.index;
            if (this.index >= IntRangeSet.this.getRangeCount()) {
                throw new NoSuchElementException();
            }
            this.currentRange = IntRangeSet.this.getRange(this.index);
            this.value = this.currentRange.getMinValue();
        }

        public void remove() {
            if (!this.nextCalled) {
                throw new IllegalStateException();
            }
            int lastValue = this.value - 1;
            if (this.currentRange.getMaxValue() == lastValue) {
                this.currentRange.setMaxValue(lastValue - 1);
            } else if (this.currentRange.getMinValue() == lastValue) {
                this.currentRange.setMinValue(lastValue + 1);
            } else {
                IntRange newRange = new IntRange(lastValue + 1, this.currentRange.getMaxValue());
                this.currentRange.setMaxValue(lastValue - 1);
                IntRangeSet.this.ranges.add(IntRangeSet.this.ranges.indexOf(this.currentRange) + 1, newRange);
            }
            if (this.currentRange.size() < 1) {
                IntRangeSet.this.ranges.remove(this.currentRange);
            }
        }

        public boolean hasNext() {
            return this.index < IntRangeSet.this.getRangeCount() - 1 || this.value <= this.currentRange.getMaxValue();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Integer result = null;
            if (!this.currentRange.includes(this.value)) {
                this.nextRange();
            }
            result = new Integer(this.value);
            ++this.value;
            this.nextCalled = true;
            return result;
        }
    }
}

