/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

public final class IntRange
implements Comparable {
    private int minValue;
    private int maxValue;

    public IntRange(int min, int max) {
        this.minValue = min;
        this.maxValue = max;
    }

    public int size() {
        return this.maxValue - this.minValue + 1;
    }

    public boolean includes(int value) {
        return value >= this.minValue && value <= this.maxValue;
    }

    public boolean add(int value) {
        boolean result = false;
        if (this.minValue - value == 1) {
            result = true;
            this.minValue = value;
        } else if (value - this.maxValue == 1) {
            result = true;
            this.maxValue = value;
        }
        return result;
    }

    public boolean add(IntRange range) {
        boolean result;
        boolean bl = result = range.minValue >= this.minValue - 1 && range.minValue <= this.maxValue + 1 || range.maxValue >= this.minValue - 1 && range.maxValue <= this.maxValue + 1;
        if (result) {
            this.minValue = Math.min(this.minValue, range.minValue);
            this.maxValue = Math.max(this.maxValue, range.maxValue);
        }
        return result;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int compareTo(Object o) {
        if (!(o instanceof IntRange)) {
            throw new ClassCastException();
        }
        IntRange obj = (IntRange)o;
        return this.minValue - obj.minValue;
    }

    public String toString() {
        return "(" + this.minValue + "..." + this.maxValue + ")";
    }
}

