/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.Serializable;
import java.util.Vector;
import org.alov.data.SQLConst;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.FieldDef;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.Project;
import org.alov.map.Record;
import org.alov.map.StatusListener;
import org.alov.tm.Chart;
import org.alov.tm.GraphObj;
import org.alov.tm.Series;
import org.alov.tm.TimeBar;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class TimeGraph
extends Panel
implements CarteHostListener,
StatusListener,
TextListener,
ItemListener,
ActionListener {
    GraphObj graph = null;
    Chart chart = new Chart();
    Series series1 = new Series(Color.red, 1);
    Series series2 = new Series(Color.green, Color.black, Color.red, 2);
    Choice chLayers = new Choice();
    Choice chFields = new Choice();
    TextField tfIntervals = new TextField();
    Choice cbSmooth = new Choice();
    Panel pnlTop = new Panel();
    Panel pnlTop2 = new Panel();
    Panel pnlTop3 = new Panel();
    CarteHost host = null;
    Carte map = null;
    Project project = null;
    private String datePickerName = "picker";
    TimeBar datePicker = null;
    int intervals = 100;
    int smooth = 0;
    private Layer layerSelection = null;
    int fieldIndex = -1;
    private static final int FIELDS_RESERVED = 2;
    private Color colorControls = SystemColor.control;
    private Color colorControlText = SystemColor.controlText;
    private Color colorLabels = Color.black;
    private Color colorGraphLabels = Color.black;
    private Color colorGraphRules = Color.gray;
    private Color colorStartBar = Color.green;
    private Color colorEndBar = Color.red;
    private Vector layerList = new Vector();
    private boolean isInitialized = false;

    private void updateLayerList() {
        if (this.project == null) {
            return;
        }
        int selection = -1;
        int layerCount = this.project.getLayerCount();
        this.chLayers.removeAll();
        this.layerList.removeAllElements();
        for (int i = 0; i < layerCount; ++i) {
            Layer layer = this.project.getLayerByIndex(i);
            if (!(layer instanceof LayerVector) || ((LayerVector)layer).dateType == 0 || !layer.timeVarying || !layer.legendVisible) continue;
            this.layerList.addElement(layer);
            this.chLayers.add(layer.getName());
            if (this.layerSelection == null || this.layerSelection != layer) continue;
            selection = this.layerList.size() - 1;
        }
        if (selection >= 0) {
            this.chLayers.select(selection);
        } else {
            if (this.layerList.size() > 0) {
                this.chLayers.select(0);
            }
            this.chLayersChanged();
        }
    }

    private void initializeControls() {
        this.chLayers.setBackground(this.colorControls);
        this.chLayers.setForeground(this.colorControlText);
        this.chFields.setBackground(this.colorControls);
        this.chFields.setForeground(this.colorControlText);
        this.tfIntervals.setBackground(this.colorControls);
        this.tfIntervals.setForeground(this.colorControlText);
        this.cbSmooth.setBackground(this.colorControls);
        this.cbSmooth.setForeground(this.colorControlText);
        this.tfIntervals.setText(String.valueOf(this.intervals));
        for (int i = 0; i < 5; ++i) {
            this.cbSmooth.add(String.valueOf(i * 2 + 1));
        }
        this.pnlTop.setLayout(new GridLayout(1, 2));
        this.pnlTop3.setLayout(new GridLayout(1, 2));
        Label lbl = new Label("Layers:");
        lbl.setAlignment(2);
        lbl.setForeground(this.colorLabels);
        this.pnlTop3.add(lbl);
        this.pnlTop3.add(this.chLayers);
        this.pnlTop.add(this.pnlTop3);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        this.pnlTop2.setLayout(gridbag);
        lbl = new Label(" Fields:");
        lbl.setAlignment(2);
        lbl.setForeground(this.colorLabels);
        c.weightx = 1.0;
        c.fill = 1;
        gridbag.setConstraints(lbl, c);
        this.pnlTop2.add(lbl);
        gridbag.setConstraints(this.chFields, c);
        this.pnlTop2.add(this.chFields);
        lbl = new Label(" Intervals:");
        lbl.setAlignment(2);
        lbl.setForeground(this.colorLabels);
        gridbag.setConstraints(lbl, c);
        this.pnlTop2.add(lbl);
        gridbag.setConstraints(this.tfIntervals, c);
        this.pnlTop2.add(this.tfIntervals);
        lbl = new Label(" Moving Avrg:");
        lbl.setAlignment(2);
        lbl.setForeground(this.colorLabels);
        gridbag.setConstraints(lbl, c);
        this.pnlTop2.add(lbl);
        c.gridwidth = 0;
        gridbag.setConstraints(this.cbSmooth, c);
        this.pnlTop2.add(this.cbSmooth);
        this.pnlTop.add(this.pnlTop2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlTop, "North");
        this.chart.seriesList.addElement(this.series1);
        this.chart.seriesList.addElement(this.series2);
        this.add((Component)this.chart, "Center");
        this.chLayers.addItemListener(this);
        this.chFields.addItemListener(this);
        this.tfIntervals.addTextListener(this);
        this.cbSmooth.addItemListener(this);
        this.isInitialized = true;
    }

    void chLayersChanged() {
        int layerIndex = this.chLayers.getSelectedIndex();
        Layer lyr = layerIndex >= 0 ? (Layer)this.layerList.elementAt(layerIndex) : null;
        this.layerSelection = lyr;
        this.chFields.removeAll();
        if (lyr != null) {
            this.chFields.addItem("Count");
            this.chFields.addItem("Transitions");
            int fieldCount = lyr.getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                FieldDef def = lyr.getFieldDef(i);
                if (!SQLConst.isNumber(def.type)) continue;
                this.chFields.addItem(def.name);
            }
            if (fieldCount > 0) {
                if (this.fieldIndex >= 0 && this.fieldIndex < this.chFields.getItemCount()) {
                    this.chFields.select(this.fieldIndex);
                } else {
                    this.chFields.select(0);
                }
            }
        }
        this.pnlTop3.doLayout();
        this.pnlTop2.doLayout();
        this.pnlTop.doLayout();
        this.doLayout();
        this.chFieldsChanged();
    }

    void chFieldsChanged() {
        this.fieldIndex = this.chFields.getSelectedIndex();
        this.processGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processGraph() {
        this.graph = new GraphObj();
        Chart chart = this.chart;
        synchronized (chart) {
            this.series1.clear();
            this.series2.clear();
        }
        if (this.layerSelection != null && this.fieldIndex >= 0 && this.project.startDate != null && this.project.endDate != null) {
            double dateMin = this.project.startDate.getDays();
            double dateMax = this.project.endDate.getDays();
            double interval = (dateMax - dateMin) / (double)((float)this.intervals * 1.0f);
            if (interval > 0.5) {
                this.graph.graphType = this.fieldIndex == 1 ? 2 : 1;
                Layer layer = this.layerSelection;
                int fi_date_low = layer.getFieldIndex(layer.metadata.getVal(53));
                int fi_date_high = layer.getFieldIndex(layer.metadata.getVal(54));
                if (fi_date_low < 0 && fi_date_high < 0) {
                    fi_date_low = layer.getFieldIndex(layer.metadata.getVal(52));
                }
                if (fi_date_low >= 0) {
                    double current = dateMin;
                    for (int k = 0; k < this.intervals; ++k) {
                        this.graph.add(current, current + interval);
                        current += interval;
                    }
                    this.graph.add(current, current);
                    Serializable serializable = layer.dataStorage;
                    synchronized (serializable) {
                        layer.dataStorage.openDataStorage(true);
                        try {
                            int recordCount = layer.dataStorage.size();
                            for (int i = 0; i < recordCount; ++i) {
                                Record rec = layer.newRecord(i);
                                layer.dataStorage.readRecAttribute(rec);
                                ExDate dateLow = null;
                                ExDate dateHigh = null;
                                try {
                                    Object o = layer.getFieldValue(rec, fi_date_low);
                                    String os = String.valueOf(o);
                                    dateLow = ExDate.parseObject(o);
                                }
                                catch (Exception e) {
                                    dateLow = this.project.startDate;
                                }
                                if (dateLow != null) {
                                    if (fi_date_high >= 0) {
                                        try {
                                            dateHigh = ExDate.parseObject(layer.getFieldValue(rec, fi_date_high));
                                        }
                                        catch (Exception e) {
                                            dateHigh = this.project.endDate;
                                        }
                                    } else {
                                        dateHigh = null;
                                    }
                                    if (dateHigh == null) {
                                        dateHigh = dateLow;
                                    }
                                    double dateStart = dateLow.getDays();
                                    double dateEnd = dateHigh.getDays();
                                    if (this.fieldIndex < 2) {
                                        this.graph.addValue(dateStart, dateEnd, 1);
                                    } else {
                                        String o = layer.getFieldString(rec, layer.getFieldIndex(this.chFields.getSelectedItem()));
                                        int data = Strings.strToInt(o, 0);
                                        this.graph.addValue(dateStart, dateEnd, data);
                                    }
                                }
                                rec = null;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            layer.dataStorage.closeDataStorage();
                        }
                    }
                    this.graph.resetSmooth(this.smooth);
                    serializable = this.chart;
                    synchronized (serializable) {
                        if (this.fieldIndex == 1) {
                            this.graph.drawGraph(this.series2, this.chart);
                        } else {
                            this.graph.drawGraph(this.series1, this.chart);
                        }
                    }
                }
            }
        }
        this.chart.repaint();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.doLayout();
        this.doLayout();
        this.doLayout();
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.setVisible(false);
        this.map = host.getMapByName(layout);
        this.map.statusListeners.addElement(this);
        this.host = host;
        this.datePickerName = XmlUtils.getString("picker", layout, this.datePickerName);
        this.colorControls = XmlUtils.getColor("controlcolor", layout, this.colorControls);
        this.colorControlText = XmlUtils.getColor("controltextcolor", layout, this.colorControlText);
        this.colorLabels = XmlUtils.getColor("controllabelcolor", layout, this.colorLabels);
        this.colorGraphLabels = XmlUtils.getColor("labelcolor", layout, this.colorGraphLabels);
        this.colorGraphRules = XmlUtils.getColor("rulecolor", layout, this.colorGraphRules);
        this.chart.doubleBuffering = XmlUtils.getBoolean("doublebuffering", layout, false);
        this.colorStartBar = XmlUtils.getColor("startbarcolor", layout, this.colorStartBar);
        this.colorEndBar = XmlUtils.getColor("endbarcolor", layout, this.colorEndBar);
        this.series2 = new Series(this.colorStartBar, Color.black, this.colorEndBar, 2);
        this.chart.colorLabels = this.colorGraphLabels;
        this.chart.colorRules = this.colorGraphRules;
    }

    public void stop() {
    }

    public void textValueChanged(TextEvent e) {
        String s;
        int n;
        Object o = e.getSource();
        if (o == this.tfIntervals && (n = Strings.strToInt(s = this.tfIntervals.getText(), 1)) > 0 && n < 2000) {
            this.intervals = n;
            this.processGraph();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        int n;
        Object o = e.getSource();
        if (o == this.chLayers) {
            this.chLayersChanged();
        } else if (o == this.chFields) {
            this.chFieldsChanged();
        } else if (o == this.cbSmooth && (n = this.cbSmooth.getSelectedIndex()) >= 0 && n < 1000) {
            this.smooth = n;
            this.processGraph();
        }
    }

    public void afterProjectLoaded(boolean bSuccess) {
        if (bSuccess) {
            this.datePicker = (TimeBar)this.host.findComponent(this.datePickerName);
            if (this.datePicker != null) {
                this.datePicker.addActionListener(this);
                this.chart.picker = this.datePicker;
            }
            this.project = this.map.getProject();
            if (this.project.isTimeEnabled) {
                this.initializeControls();
            }
        }
    }

    public void notifyStatus(int code, Object obj) {
        if (code == 15) {
            if (this.isInitialized) {
                this.updateLayerList();
                this.setVisible(this.project.isTimeEnabled && this.layerList.size() > 0);
            } else {
                this.setVisible(false);
            }
            this.host.refreshLayout();
            this.doLayout();
            this.pnlTop.doLayout();
            this.pnlTop3.doLayout();
            this.pnlTop2.doLayout();
        } else if (code == 11 && obj == null) {
            this.processGraph();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (this.datePicker != null && o == this.datePicker) {
            TimeInterval ti = this.datePicker.getVisibleArea();
            this.chart.setDates(ti.date1().getDays(), ti.date2().getDays());
            this.chart.repaint();
        }
    }
}

