/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.AWTEventMulticaster;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.Domain;
import org.alov.map.Project;
import org.alov.map.StatusListener;
import org.alov.tm.ScaleLabel;
import org.alov.util.ExDate;
import org.alov.util.TimeInterval;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class TimeBar
extends Panel
implements CarteHostListener,
ActionListener,
StatusListener {
    public static final int DL_UNKNOWN = -1;
    public static final int DL_SEC = 0;
    public static final int DL_MIN = 1;
    public static final int DL_HALF_HOUR = 2;
    public static final int DL_HOUR = 3;
    public static final int DL_HALF_DAY = 4;
    public static final int DL_DAY = 5;
    private static final int DL_HALF_MONTH = 6;
    public static final int DL_MONTH = 7;
    public static final int DL_HALF_YEAR = 8;
    public static final int DL_YEAR = 9;
    public static final int EVENT_SLIDER = 1;
    public static final int EVENT_SCALE = 2;
    private double scaleLength = 0.5;
    private double dateScale = 1.0;
    private double dateMin = 1000000.0;
    private double dateMax = 1000001.0;
    private double curMin = 1000000.25;
    private double curMax = 1000000.75;
    private double scaleOrigin = 1000000.25;
    private double scaleWidth = 100.0;
    private Scale scale = new Scale();
    private Slider slider = new Slider();
    private PickerPanel panel = new PickerPanel();
    private Panel rightPanel = null;
    private ActionListener actListener = null;
    private TimeInterval timeInterval = null;
    private Button btnZoomFull = new Button("<->");
    private Button btnZoomIn = new Button("+");
    private Button btnZoomOut = new Button("-");
    private Button btnZoomCurrent = new Button(">-<");
    private Button btnCenterLeft = new Button("<");
    private Button btnCenterRight = new Button(">");
    private Label lblFull = new Label();
    private Label lblCurrent = new Label();
    private boolean scaleCalculated = false;
    private boolean labelsVis = true;
    private boolean buttonsVis = true;
    private Carte map = null;
    private boolean lastValid = false;
    private double lastOrigin = 0.0;
    private double lastLength = 0.0;

    public TimeBar() {
        this.setBackground(Color.white);
    }

    private void addComp() {
        try {
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GridBagConstraints c = new GridBagConstraints();
            c.weighty = 1.0;
            c.fill = 1;
            if (this.buttonsVis) {
                Panel leftPanel = new Panel();
                leftPanel.setLayout(new GridLayout(2, 3));
                leftPanel.add(this.btnZoomFull);
                leftPanel.add(this.btnZoomIn);
                leftPanel.add(this.btnZoomOut);
                leftPanel.add(this.btnZoomCurrent);
                leftPanel.add(this.btnCenterLeft);
                leftPanel.add(this.btnCenterRight);
                this.btnZoomFull.addActionListener(this);
                this.btnZoomIn.addActionListener(this);
                this.btnZoomOut.addActionListener(this);
                this.btnZoomCurrent.addActionListener(this);
                this.btnCenterLeft.addActionListener(this);
                this.btnCenterRight.addActionListener(this);
                gbl.setConstraints(leftPanel, c);
                this.add(leftPanel);
            }
            c.weightx = 1.0;
            gbl.setConstraints(this.panel, c);
            this.add(this.panel);
            if (this.labelsVis) {
                c.weightx = 0.5;
                c.gridwidth = 0;
                this.rightPanel = new Panel();
                this.rightPanel.setLayout(new GridLayout(2, 1));
                this.rightPanel.add(this.lblFull);
                this.rightPanel.add(this.lblCurrent);
                gbl.setConstraints(this.rightPanel, c);
                this.add(this.rightPanel);
            }
            this.setBoundaries(new ExDate(0.0), new ExDate(1.0));
            this.setCurrent(new ExDate(0.25), new ExDate(0.5), true);
            this.zoomFull();
            this.panel.updateAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        this.panel.updateAll();
    }

    public void setBoundaries(Object min, Object max) {
        double d1 = ExDate.parseObject(min).getDays();
        double d2 = ExDate.parseObject(max).getDays();
        if (d2 <= d1) {
            return;
        }
        this.dateMin = d1;
        this.dateMax = d2;
        boolean moved = false;
        if (this.curMin < this.dateMin) {
            this.curMin = this.dateMin;
            moved = true;
        }
        if (this.curMax > this.dateMax) {
            this.curMax = this.dateMax;
            moved = true;
        }
        if (moved) {
            this.sliderMoved(true);
        }
        if (this.scaleOrigin + this.scaleLength > this.dateMax) {
            this.scaleOrigin = this.dateMax - this.scaleLength;
        }
        if (this.scaleOrigin < this.dateMin) {
            this.scaleOrigin = this.dateMin;
            this.scaleLength = this.dateMax - this.dateMin;
        }
        this.lblFull.setText("Full: " + min + " - " + max);
        this.panel.updateAll();
    }

    public void setCurrent(Object min, Object max, boolean zoomTo) {
        double d1 = ExDate.parseObject(min).getDays();
        double d2 = ExDate.parseObject(max).getDays();
        if (d2 <= d1) {
            return;
        }
        if (d1 < this.dateMin) {
            d1 = this.dateMin;
        }
        if (d2 > this.dateMax) {
            d2 = this.dateMax;
        }
        this.curMin = d1;
        this.curMax = d2;
        this.sliderMoved(true);
        if (zoomTo) {
            double d = (this.curMax - this.curMin) * 0.1;
            this.setScale(this.curMin - d, this.curMax - this.curMin + d + d);
        }
    }

    public void zoomFull() {
        this.setScale(this.dateMin, this.dateMax - this.dateMin);
    }

    public void addActionListener(ActionListener l) {
        this.actListener = AWTEventMulticaster.add(this.actListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actListener = AWTEventMulticaster.remove(this.actListener, l);
    }

    public TimeInterval getTimeInterval(boolean rounded) {
        if (this.timeInterval == null) {
            if (rounded) {
                double delta = this.scale.getDeltaForLevel(this.scale.displayLevel);
                ExDate min = this.roundTo(this.curMin, this.scale.displayLevel);
                ExDate max = this.roundTo(this.curMax, this.scale.displayLevel);
                this.timeInterval = new TimeInterval(min, max);
            } else {
                this.timeInterval = new TimeInterval(new ExDate(this.curMin), new ExDate(this.curMax));
            }
        }
        return this.timeInterval;
    }

    public int getDisplayLevel() {
        return this.scale.displayLevel;
    }

    public TimeInterval getVisibleArea() {
        return new TimeInterval(new ExDate(this.scaleOrigin), new ExDate(this.scaleOrigin + this.scaleLength));
    }

    private ExDate roundTo(double value, int level) {
        long[] ymdhms = ExDate.getYMDHMS(value);
        switch (level) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                ymdhms[5] = 0L;
                break;
            }
            case 3: 
            case 4: {
                ymdhms[5] = 0L;
                ymdhms[4] = 0L;
                break;
            }
            case 5: 
            case 6: {
                ymdhms[5] = 0L;
                ymdhms[4] = 0L;
                ymdhms[3] = 0L;
                break;
            }
            case 7: 
            case 8: {
                ymdhms[5] = 0L;
                ymdhms[4] = 0L;
                ymdhms[3] = 0L;
                ymdhms[2] = 1L;
                break;
            }
            default: {
                ymdhms[5] = 0L;
                ymdhms[4] = 0L;
                ymdhms[3] = 0L;
                ymdhms[2] = 1L;
                ymdhms[1] = 1L;
            }
        }
        ExDate result = new ExDate(ymdhms[0], ymdhms[1], ymdhms[2], ymdhms[3], ymdhms[4], ymdhms[5]);
        return result;
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = 32;
        dim.width = 400;
        return dim;
    }

    private void scaleMoved() {
        if (this.actListener != null) {
            this.actListener.actionPerformed(new ActionEvent(this, 2, null));
        }
    }

    private void sliderMoved(boolean bAction) {
        this.timeInterval = null;
        TimeInterval newInterval = this.getTimeInterval(false);
        this.lblCurrent.setText("Sel: " + newInterval.date1() + " - " + newInterval.date2());
        if (this.actListener != null && bAction) {
            this.actListener.actionPerformed(new ActionEvent(this, 1, "adjust"));
        }
        if (this.map != null && bAction) {
            this.map.setTimeInterval(newInterval);
        }
    }

    public void setScale(double origin, double length) {
        if (origin < this.dateMin) {
            origin = this.dateMin;
            if (origin + length > this.dateMax) {
                length = this.dateMax - origin;
            }
        } else if (origin + length > this.dateMax && (origin = this.dateMax - length) < this.dateMin) {
            origin = this.dateMin;
            length = this.dateMax - this.dateMin;
        }
        this.scaleOrigin = origin;
        this.scaleLength = length;
        this.dateScale = this.scaleLength / this.scaleWidth;
        this.scaleCalculated = false;
        this.panel.updateAll();
        if (!this.lastValid || this.lastOrigin != this.scaleOrigin || this.lastLength != this.scaleLength) {
            this.lastValid = true;
            this.lastOrigin = this.scaleOrigin;
            this.lastLength = this.scaleLength;
            this.scaleMoved();
        }
    }

    public int getScaleWidth() {
        return this.scale.getSize().width;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.doLayout();
        this.doLayout();
        this.doLayout();
    }

    private void setScaleLength(double len) {
        double center = (this.curMin + this.curMax) / 2.0;
        this.setScale(center - len / 2.0, len);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.btnZoomFull) {
            this.zoomFull();
        } else if (o == this.btnZoomIn) {
            this.scale.recalcDisplayLevel = false;
            this.setScaleLength(this.scale.getNewScaleLength(true));
        } else if (o == this.btnZoomOut) {
            this.scale.recalcDisplayLevel = false;
            this.setScaleLength(this.scale.getNewScaleLength(false));
        } else if (o == this.btnZoomCurrent) {
            double d = 0.0;
            this.setScale(this.curMin - d, this.curMax - this.curMin + d + d);
        } else if (o == this.btnCenterLeft) {
            double origin = this.curMin - this.scaleLength / 2.0;
            this.setScale(origin, this.scaleLength);
        } else if (o == this.btnCenterRight) {
            double origin = this.curMax - this.scaleLength / 2.0;
            this.setScale(origin, this.scaleLength);
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.setVisible(false);
        if (layout != null) {
            this.buttonsVis = XmlUtils.getBoolean("buttons", layout, true);
            this.labelsVis = XmlUtils.getBoolean("labels", layout, true);
            this.slider.gripColor = this.getBackground();
            Color c = XmlUtils.getColor("ScaleColor", layout, null);
            if (c != null) {
                this.scale.setBackground(c);
            }
            if ((c = XmlUtils.getColor("SliderColor", layout, null)) != null) {
                this.slider.setBackground(c);
            }
        }
        this.addComp();
        if (host != null) {
            this.map = host.getMapByName(layout);
            this.map.statusListeners.addElement(this);
        } else {
            this.map = null;
        }
    }

    public void stop() {
    }

    public void updateSlider() {
        this.panel.updateSlider();
    }

    public void afterProjectLoaded(boolean bSuccess) {
        Project project = this.map.getProject();
        if (project.isTimeEnabled) {
            this.setBoundaries(project.startDate, project.endDate);
            Domain d = null;
            if (project.startExtentName != null) {
                d = (Domain)project.domains.get(project.startExtentName);
            }
            if (d != null) {
                this.setCurrent(d.minDate, d.maxDate, true);
            } else {
                this.setCurrent(project.startDate, project.endDate, true);
            }
            if (!this.buttonsVis) {
                this.zoomFull();
            }
        }
        this.setVisible(project.isTimeEnabled);
    }

    public void notifyStatus(int code, Object obj) {
        if (code == 102) {
            Domain d = (Domain)this.map.getProject().domains.get((String)obj);
            Project project = this.map.getProject();
            if (d != null && project.isTimeEnabled) {
                this.setCurrent(d.minDate, d.maxDate, true);
            }
        }
    }

    private double dateAt(double pixel) {
        return this.scaleOrigin + this.scaleLength / this.scaleWidth * (pixel -= 24.0);
    }

    private double pixelOf(double date) {
        return (date - this.scaleOrigin) * this.scaleWidth / this.scaleLength + 24.0;
    }

    private class PickerPanel
    extends Panel {
        PickerPanel() {
            this.setLayout(null);
            TimeBar.this.scale.setBackground(new Color(208, 208, 238));
            TimeBar.this.slider.setBackground(new Color(255, 192, 222));
            this.enableEvents(16L);
            this.add(TimeBar.this.scale);
            this.add(TimeBar.this.slider);
        }

        protected void processMouseEvent(MouseEvent e) {
            Point pt = e.getPoint();
            switch (e.getID()) {
                case 501: {
                    int x = pt.x;
                    double date = TimeBar.this.dateAt(x);
                    if (date < TimeBar.this.curMin) {
                        if (date < TimeBar.this.dateMin) {
                            date = TimeBar.this.dateMin;
                        }
                        TimeBar.this.curMin = date;
                        this.updateSlider();
                        TimeBar.this.sliderMoved(true);
                        break;
                    }
                    if (!(date > TimeBar.this.curMax)) break;
                    if (date > TimeBar.this.dateMax) {
                        date = TimeBar.this.dateMax;
                    }
                    TimeBar.this.curMax = date;
                    this.updateSlider();
                    TimeBar.this.sliderMoved(true);
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            TimeBar.this.scale.setBounds(0, 0, w, h / 2);
            TimeBar.this.slider.setBounds(2, h / 2 + 8, w - 4, h - 4);
            double x1 = TimeBar.this.pixelOf(TimeBar.this.curMin);
            double x2 = TimeBar.this.pixelOf(TimeBar.this.curMax);
            if (x1 < -500.0) {
                x1 = -500.0;
            }
            if (x2 > 5000.0) {
                x2 = 5000.0;
            }
            TimeBar.this.slider.setBounds((int)x1, h / 2 + 2, (int)(x2 - x1), h / 2 - 4);
        }

        void updateAll() {
            this.updateSlider();
            TimeBar.this.scale.updateScale();
        }

        void updateSlider() {
            this.setSlider(TimeBar.this.pixelOf(TimeBar.this.curMin), TimeBar.this.pixelOf(TimeBar.this.curMax));
        }

        void setSlider(double x1, double x2) {
            if (x1 < -500.0) {
                x1 = -500.0;
            }
            if (x2 > 5000.0) {
                x2 = 5000.0;
            }
            if (x2 - x1 < 2.0) {
                x2 += 2.0;
                x1 -= 2.0;
            }
            Rectangle rect = TimeBar.this.slider.getBounds();
            rect.x = (int)Math.floor(x1);
            rect.width = (int)(Math.floor(x2) - Math.floor(x1)) + 1;
            TimeBar.this.slider.setBounds(rect);
        }
    }

    protected class Slider
    extends Panel {
        private static final int DRAG_LEFT = 1;
        private static final int DRAG_RIGHT = 2;
        private static final int DRAG_CENTER = 3;
        private int gripSize = 10;
        private boolean dragging = false;
        private int dragType;
        private int dragPos;
        private double dragDate;
        private double dragMin;
        private double dragMax;
        private Color gripColor = Color.red;

        Slider() {
            this.enableEvents(48L);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            Point pt = e.getPoint();
            switch (e.getID()) {
                case 506: {
                    if (!this.dragging) {
                        return;
                    }
                    Rectangle rect = this.getBounds();
                    int dx = pt.x + rect.x - this.dragPos;
                    double oldMin = TimeBar.this.curMin;
                    double oldMax = TimeBar.this.curMax;
                    double delta = TimeBar.this.dateScale * (double)dx;
                    float minDelta = 1.1574074E-4f;
                    switch (this.dragType) {
                        case 1: {
                            TimeBar.this.curMin = this.dragMin + delta;
                            if (TimeBar.this.curMin < TimeBar.this.dateMin) {
                                TimeBar.this.curMin = TimeBar.this.dateMin;
                                break;
                            }
                            if (!(TimeBar.this.curMin > TimeBar.this.curMax - (double)minDelta)) break;
                            TimeBar.this.curMin = TimeBar.this.curMax - (double)minDelta;
                            break;
                        }
                        case 3: {
                            TimeBar.this.curMin = this.dragMin + delta;
                            TimeBar.this.curMax = this.dragMax + delta;
                            if (TimeBar.this.curMin < TimeBar.this.dateMin) {
                                TimeBar.this.curMin = TimeBar.this.dateMin;
                                TimeBar.this.curMax = TimeBar.this.curMin + (this.dragMax - this.dragMin);
                                break;
                            }
                            if (!(TimeBar.this.curMax > TimeBar.this.dateMax)) break;
                            TimeBar.this.curMax = TimeBar.this.dateMax;
                            TimeBar.this.curMin = TimeBar.this.curMax - (this.dragMax - this.dragMin);
                            break;
                        }
                        case 2: {
                            TimeBar.this.curMax = this.dragMax + delta;
                            if (TimeBar.this.curMax > TimeBar.this.dateMax) {
                                TimeBar.this.curMax = TimeBar.this.dateMax;
                                break;
                            }
                            if (!(TimeBar.this.curMax < TimeBar.this.curMin + (double)minDelta)) break;
                            TimeBar.this.curMax = TimeBar.this.curMin + (double)minDelta;
                        }
                    }
                    if (TimeBar.this.curMin == oldMin && TimeBar.this.curMax == oldMax) break;
                    double x1 = TimeBar.this.pixelOf(TimeBar.this.curMin);
                    double x2 = TimeBar.this.pixelOf(TimeBar.this.curMax);
                    if (x2 - x1 < 2.0) {
                        x2 += 1.0;
                        x1 -= 1.0;
                    }
                    TimeBar.this.panel.setSlider(x1, x2);
                    TimeBar.this.sliderMoved(false);
                }
            }
        }

        protected void processMouseEvent(MouseEvent e) {
            Point pt = e.getPoint();
            switch (e.getID()) {
                case 501: {
                    Dimension size = this.getSize();
                    int x = pt.x;
                    Rectangle rect = this.getBounds();
                    this.dragDate = TimeBar.this.dateAt(rect.x + x);
                    this.dragPos = rect.x + x;
                    this.dragMin = TimeBar.this.curMin;
                    this.dragMax = TimeBar.this.curMax;
                    this.dragType = x < this.gripSize ? 1 : (x > size.width - this.gripSize ? 2 : 3);
                    this.dragging = true;
                    break;
                }
                case 502: {
                    this.dragging = false;
                    TimeBar.this.sliderMoved(true);
                }
            }
        }

        public void paint(Graphics g) {
            Rectangle rect = this.getBounds();
            g.setColor(this.gripColor);
            int[] xc = new int[]{1, this.gripSize, this.gripSize};
            int[] yc = new int[]{(rect.height - 1) / 2, 1, rect.height - 2};
            g.fillPolygon(xc, yc, 3);
            int[] xc2 = new int[]{rect.width, rect.width - this.gripSize, rect.width - this.gripSize};
            g.fillPolygon(xc2, yc, 3);
        }
    }

    protected class Scale
    extends Panel {
        static final int margin = 24;
        private boolean dragging = false;
        private int dragPos;
        private Vector labels = new Vector();
        private static final double MIN_SEC = 2.3148148148148147E-5;
        private static final double MIN_MIN = 0.002083333333333333;
        private static final double MIN_HOUR = 0.125;
        private static final double MIN_DAY = 2.0;
        private static final double MIN_MONTH = 62.0;
        private static final double MIN_YEAR = 730.0;
        boolean recalcDisplayLevel = true;
        private int displayLevel = -1;
        private String unitsString = "";
        private static final int FORMAT_NONE = -1;
        private static final int FORMAT_HH_MM = 1;
        private static final int FORMAT_DD_MMM = 2;
        private static final int FORMAT_MMM = 3;
        private static final int FORMAT_SS = 4;
        private static final int FORMAT_DD = 5;
        private static final int FORMAT_YYYY = 6;
        private static final int FORMAT_HH = 7;
        private final String[] MONTH_NAMES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

        Scale() {
            this.enableEvents(48L);
        }

        public void setBounds(int x, int y, int w, int h) {
            int w2 = w - 48;
            TimeBar.this.scaleWidth = w2;
            if (w > 0) {
                TimeBar.this.dateScale = TimeBar.this.scaleLength / (double)w2;
            } else {
                TimeBar.this.dateScale = 1.0;
            }
            super.setBounds(x, y, w, h);
        }

        public void paint(Graphics g) {
            if (!TimeBar.this.scaleCalculated) {
                this.calculateScale();
            }
            double leftDate = TimeBar.this.dateAt(0.0);
            double rightDate = TimeBar.this.dateAt(TimeBar.this.scaleWidth);
            FontMetrics fm = g.getFontMetrics();
            g.setColor(Color.gray);
            g.drawString(this.unitsString, (int)((TimeBar.this.scaleWidth - (double)fm.stringWidth(this.unitsString)) / 2.0), fm.getHeight());
            g.setColor(Color.black);
            for (int i = 0; i < this.labels.size(); ++i) {
                ScaleLabel lbl = (ScaleLabel)this.labels.elementAt(i);
                if (lbl.location >= leftDate) {
                    int x = (int)TimeBar.this.pixelOf(lbl.location);
                    if (lbl.text != null) {
                        int x2 = x - fm.stringWidth(lbl.text) / 2;
                        g.drawString(lbl.text, x2, 10);
                        g.drawLine(x, 12, x, 20);
                        continue;
                    }
                    g.drawLine(x, 16, x, 20);
                    continue;
                }
                if (lbl.location > rightDate) break;
            }
        }

        public void updateScale() {
            this.calculateScale();
            this.repaint();
        }

        private int findDisplayLevel(double range) {
            if (range < 0.002083333333333333) {
                return 0;
            }
            if (range < 0.062499999999999986) {
                return 1;
            }
            if (range < 0.125) {
                return 2;
            }
            if (range < 1.5) {
                return 3;
            }
            if (range < 2.0) {
                return 4;
            }
            if (range < 30.0) {
                return 5;
            }
            if (range < 62.0) {
                return 6;
            }
            if (range < 372.0) {
                return 7;
            }
            if (range < 730.0) {
                return 8;
            }
            double d1 = range / this.getDeltaForLevel(9);
            return 9 + (int)Math.floor(Math.log(d1) / Math.log(10.0));
        }

        private double roundTo(double initial, double d) {
            initial = Math.ceil(initial) != initial ? Math.floor(initial / d) + 1.0 : Math.floor(initial / d);
            return initial * d;
        }

        private double log10(double d) {
            return Math.log(d) / Math.log(10.0);
        }

        private String formatNumber(long n) {
            if (n < 10L && n >= 0L) {
                return "0" + n;
            }
            return "" + n;
        }

        private String monthToStr(long n) {
            try {
                return this.MONTH_NAMES[(int)n - 1];
            }
            catch (Exception e) {
                return null;
            }
        }

        private String formatDateTime(long y, long m, long d, long h, long min, long s, int format) {
            String result;
            switch (format) {
                case 1: {
                    result = this.formatNumber(h) + ":" + this.formatNumber(min);
                    break;
                }
                case 2: {
                    result = this.formatNumber(d) + " " + this.monthToStr(m);
                    break;
                }
                case 3: {
                    result = this.monthToStr(m);
                    break;
                }
                case 4: {
                    result = this.formatNumber(s);
                    break;
                }
                case 5: {
                    result = this.formatNumber(d);
                    break;
                }
                case 6: {
                    result = String.valueOf(y);
                    break;
                }
                case 7: {
                    result = String.valueOf(h);
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }

        double getDeltaForLevel(int level) {
            if (level > 9) {
                double power = Math.exp(Math.log(10.0) * (double)(level - 9));
                return this.getDeltaForLevel(9) * power;
            }
            switch (level) {
                case 9: {
                    return 365.25;
                }
                case 8: {
                    return 182.625;
                }
                case 7: {
                    return 31.0;
                }
                case 6: {
                    return 15.0;
                }
                case 5: {
                    return 1.0;
                }
                case 4: {
                    return 0.5;
                }
                case 3: {
                    return 0.08333333333333333;
                }
                case 2: {
                    return 0.020833333333333332;
                }
                case 1: {
                    return 6.944444444444444E-4;
                }
                case 0: {
                    return 1.1574074074074073E-5;
                }
            }
            return 1.0;
        }

        double getNewScaleLength(boolean zoomIn) {
            if (zoomIn) {
                if (this.displayLevel > 0) {
                    --this.displayLevel;
                }
            } else {
                double curDelta = this.getDeltaForLevel(this.displayLevel + 1);
                if (curDelta > TimeBar.this.dateMax - TimeBar.this.dateMin) {
                    return curDelta;
                }
                ++this.displayLevel;
            }
            return this.getDeltaForLevel(this.displayLevel + 1);
        }

        void calculateScale() {
            double dd;
            this.labels.removeAllElements();
            int formatY = 6;
            int formatM = -1;
            int formatD = -1;
            int formatH = -1;
            int formatMin = -1;
            int formatS = -1;
            long delta = 0L;
            double ymin = TimeBar.this.dateAt(-500.0);
            double ymax = TimeBar.this.dateAt(TimeBar.this.scaleWidth + 500.0);
            if (ymin < TimeBar.this.dateMin) {
                ymin = TimeBar.this.dateMin;
            }
            if (ymax > TimeBar.this.dateMax) {
                ymax = TimeBar.this.dateMax;
            }
            double dateRange = TimeBar.this.dateAt(TimeBar.this.scaleWidth - 24.0) - TimeBar.this.dateAt(24.0);
            if (this.displayLevel == -1 || this.recalcDisplayLevel) {
                this.displayLevel = this.findDisplayLevel(dateRange);
            }
            this.recalcDisplayLevel = true;
            if (dateRange < 1.736111111111111E-4) {
                formatMin = 1;
                formatH = 1;
                formatD = 2;
                formatM = 3;
                formatS = 4;
            } else if (dateRange < 0.006944444444444444) {
                formatMin = 1;
                formatD = 2;
                formatM = 3;
                formatH = 1;
            } else if (dateRange < 0.003472222222222222) {
                formatMin = 1;
                formatH = 1;
                formatD = 2;
                formatM = 3;
            } else if (dateRange < 0.041666666666666664) {
                formatH = 1;
                formatD = 2;
                formatM = 3;
            } else if (dateRange < 0.5) {
                formatH = 1;
                formatD = 2;
                formatM = 3;
            } else if (dateRange < 2.0) {
                formatD = 2;
                formatM = 3;
            } else if (dateRange < 40.0) {
                formatM = 3;
                formatD = 5;
            } else if (dateRange < 60.0) {
                formatM = 3;
            } else if (dateRange < 730.0) {
                formatM = 3;
            }
            if (this.displayLevel >= 9) {
                Graphics g = this.getGraphics();
                if (g == null) {
                    return;
                }
                long i = g.getFontMetrics().stringWidth(ExDate.toString((ymin + ymax) / 2.0));
                g.dispose();
                double dyMin = TimeBar.this.dateAt((double)i + 30.0) - TimeBar.this.dateAt(0.0);
                delta = Math.round(dyMin / 365.0);
                if (delta == 0L) {
                    ++delta;
                } else {
                    double r = Math.ceil(this.log10(delta));
                    delta = i = Math.round(Math.exp(Math.log(10.0) * r));
                }
            }
            long[] ymdhms = ExDate.getYMDHMS((ymin + ymax) / 2.0);
            long py = ymdhms[0];
            long pm = ymdhms[1];
            long pd = ymdhms[2];
            long ph = ymdhms[3];
            long pmin = ymdhms[4];
            switch (this.displayLevel) {
                case 0: {
                    this.unitsString = "S E C O N D S" + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 6) + " " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 3) + " " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 5) + ", " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 1);
                    break;
                }
                case 1: 
                case 2: {
                    this.unitsString = "M I N U T E S of " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 6) + " " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 3) + " " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 5) + ", " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 7) + " hour(s)";
                    break;
                }
                case 3: 
                case 4: {
                    this.unitsString = "H O U R S of " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 6) + " " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 3) + " " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 5);
                    break;
                }
                case 5: 
                case 6: {
                    this.unitsString = "D A Y S of " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 6) + " " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 3);
                    break;
                }
                case 7: 
                case 8: {
                    this.unitsString = "M O N T H S of " + this.formatDateTime(py, pm, pd, ph, pmin, 0L, 6);
                    break;
                }
                default: {
                    this.unitsString = "Y E A R S";
                }
            }
            ymdhms = ExDate.getYMDHMS(ymin);
            py = ymdhms[0];
            pm = ymdhms[1];
            pd = ymdhms[2];
            ph = ymdhms[3];
            pmin = ymdhms[4];
            if (dateRange > 730.0) {
                py = (long)Math.floor(this.roundTo(py, delta));
            }
            long psec = 0L;
            if (this.displayLevel >= 3) {
                pmin = 0L;
            }
            if (this.displayLevel >= 5) {
                ph = 0L;
            }
            if (this.displayLevel >= 7) {
                pd = 1L;
            }
            if (this.displayLevel >= 9) {
                pm = 1L;
            }
            double curDate = ExDate.encode(py, pm, pd, ph, pmin, psec);
            curDate += 1.1574074074074074E-6;
            long ny = py;
            long nm = pm;
            long nd = pd;
            long nh = ph;
            long nmin = pmin;
            long nsec = psec;
            long smallDelta = delta;
            if (this.displayLevel >= 9 && (dd = dateRange / (this.getDeltaForLevel(9) * (double)delta)) < 4.0 && (smallDelta = delta / 4L) <= 0L) {
                smallDelta = 1L;
            }
            boolean first = true;
            while (curDate <= ymax) {
                ScaleLabel scaleLabel = new ScaleLabel();
                ymdhms = ExDate.getYMDHMS(curDate);
                ny = ymdhms[0];
                nm = ymdhms[1];
                nd = ymdhms[2];
                nh = ymdhms[3];
                nmin = ymdhms[4];
                nsec = ymdhms[5];
                if (first) {
                    first = false;
                    py = ny - 1L;
                    pm = nm - 1L;
                    pd = nd - 1L;
                    ph = nh - 1L;
                    pmin = nmin - 1L;
                    psec = nsec - 1L;
                }
                int fff = ny != py ? formatY : (nm != pm ? formatM : (nd != pd ? formatD : (nh != ph ? formatH : (nmin != pmin ? formatMin : (nsec != psec ? formatS : -1)))));
                py = ny;
                pm = nm;
                pd = nd;
                ph = nh;
                pmin = nmin;
                psec = nsec;
                this.labels.addElement(scaleLabel);
                scaleLabel.location = curDate;
                scaleLabel.text = null;
                if (fff == -1) {
                    switch (this.displayLevel) {
                        case 7: 
                        case 8: {
                            if (pm % 4L != 1L) break;
                            fff = 3;
                            break;
                        }
                        case 5: 
                        case 6: {
                            if (pd % 10L != 0L) break;
                            fff = 5;
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (ph % 6L != 0L) break;
                            fff = 7;
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (pmin % 15L != 0L) break;
                            fff = 1;
                            break;
                        }
                        case 0: {
                            if (psec % 15L != 0L) break;
                            scaleLabel.text = String.valueOf(psec);
                        }
                    }
                }
                if (scaleLabel.text == null) {
                    scaleLabel.text = this.formatDateTime(py, pm, pd, ph, pmin, psec, fff);
                }
                if (this.displayLevel < 9) {
                    switch (this.displayLevel) {
                        case 7: 
                        case 8: {
                            if (++nm > 12L) {
                                ++ny;
                                nm = 1L;
                            }
                            curDate = ExDate.encode(ny, nm, nd, nh, nmin, nsec);
                            break;
                        }
                        case 5: 
                        case 6: {
                            curDate += 1.0;
                            break;
                        }
                        case 3: 
                        case 4: {
                            curDate += 0.041666666666666664;
                            break;
                        }
                        case 1: 
                        case 2: {
                            curDate += 6.944444444444444E-4;
                            break;
                        }
                        case 0: {
                            curDate += 1.1574074074074073E-5;
                        }
                    }
                    continue;
                }
                curDate = ExDate.encode(ny += smallDelta, nm, nd, nh, nmin, nsec);
            }
            TimeBar.this.scaleCalculated = true;
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            Point pt = e.getPoint();
            switch (e.getID()) {
                case 506: {
                    if (!this.dragging) {
                        return;
                    }
                    int delta = -pt.x + this.dragPos;
                    this.dragPos = pt.x;
                    double date = TimeBar.this.dateAt(delta + 24);
                    if (date < TimeBar.this.dateMin) {
                        date = TimeBar.this.dateMin;
                    }
                    if (date + TimeBar.this.scaleLength > TimeBar.this.dateMax) {
                        date = TimeBar.this.dateMax - TimeBar.this.scaleLength;
                    }
                    if (TimeBar.this.scaleOrigin == date) break;
                    TimeBar.this.scaleOrigin = date;
                    TimeBar.this.panel.updateSlider();
                    this.repaint();
                    TimeBar.this.scaleMoved();
                }
            }
        }

        protected void processMouseEvent(MouseEvent e) {
            switch (e.getID()) {
                case 501: {
                    Dimension size = this.getSize();
                    Point pt = e.getPoint();
                    this.dragPos = pt.x;
                    this.dragging = true;
                    break;
                }
                case 502: {
                    this.dragging = false;
                    this.recalcDisplayLevel = false;
                    this.updateScale();
                }
            }
        }
    }
}

