/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.ClientLog;
import org.alov.map.FloatRectangle;
import org.alov.map.MapUtils;
import org.alov.util.Log;
import org.alov.util.XmlElement;

public class ClientReporter
implements Runnable,
CarteHostListener,
CarteListener {
    private static final String PAR_SERVLETURL = "report_servlet";
    private static final String DEF_SERVLETURL = "tmv";
    private String initialServletURL = null;
    private String servletURL = null;
    private boolean terminate = false;
    private int iUnsuccess = 0;
    private Thread thread = null;
    private long randomID = (int)(System.currentTimeMillis() & Integer.MAX_VALUE);
    private Carte map = null;
    private String docBase = null;
    private int clickCount = 0;
    private boolean bFirstTime = true;
    private String lastError = null;

    public void setParameters(CarteHost host, XmlElement layout) {
        this.map = host.getMapByName(layout);
        this.map.mapListeners.addElement(this);
        this.servletURL = MapUtils.getRealPath(DEF_SERVLETURL) + "?request=report&";
        this.iUnsuccess = 0;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.terminate = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void setDocumentBase(String docBase) {
        this.docBase = URLEncoder.encode(docBase);
    }

    private void sendInfo() throws Exception {
        String addr = this.servletURL;
        if (this.bFirstTime) {
            String pid = this.map.getParameter("pid", null);
            addr = addr + "id=" + this.randomID + "&tms=" + pid + "&ver=" + URLEncoder.encode("TMJava v2.2.25") + "&url=" + this.docBase;
            this.bFirstTime = false;
        } else {
            String error = null;
            ClientLog cl = (ClientLog)Log.getInstance();
            if (cl == null || this.terminate) {
                return;
            }
            Vector messages = cl.getStatus();
            int count = messages.size();
            for (int i = count - 1; i >= 0; --i) {
                String msg = (String)messages.elementAt(i);
                if (msg.indexOf("ERROR#") < 0) continue;
                error = msg;
                break;
            }
            addr = addr + "id=" + this.randomID + "&cnt=" + this.clickCount;
            if (error != null && !error.equals(this.lastError)) {
                this.lastError = error;
                error = URLEncoder.encode(error);
                addr = addr + "&err=" + error;
            }
            this.clickCount = 0;
        }
        try {
            HttpURLConnection uc = (HttpURLConnection)new URL(addr).openConnection();
            uc.connect();
            if (404 == uc.getResponseCode()) {
                ++this.iUnsuccess;
            }
            boolean bl = this.terminate = this.iUnsuccess > 10;
            if (!this.terminate) {
                uc.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        while (!this.terminate) {
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.terminate) break;
            try {
                this.sendInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void mouseMapPressed(MouseEvent e) {
        ++this.clickCount;
    }

    public void mouseMapReleased(FloatRectangle selRect, MouseEvent e) {
    }

    public void mouseMapMoved(MouseEvent e) {
    }

    public void afterMapDraw(Graphics g) {
    }
}

