/*
 * Decompiled with CFR 0.152.
 */
package org.alov.tm;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.RecordsArray;
import org.alov.map.StatusListener;
import org.alov.tm.AnimationFrame;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class ButtonsCh
implements CarteHostListener,
KeyListener,
ActionListener,
ItemListener,
CarteListener,
StatusListener {
    private Carte map;
    private CarteHost host;
    private Label lbl_search = null;
    private Label lbl_layername = null;
    private Label lbl_fieldname = null;
    private String searchLayer = null;
    private String magicURL = null;
    private String magicFrame = null;
    boolean isUpdateWhenTimeChanges = false;
    boolean isUpdateWhenExtentChanges = false;
    private static final String BTN_ANIME = "btn_anime";
    private static final String CHB_LAYER_CONTROL_PREFIX = "Control_Visibility_Of_Layer_";

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof Component) {
            TextField tf;
            String sName = ((Component)o).getName();
            if (sName.equalsIgnoreCase("btn_copyright")) {
                Layer lyr = this.map.getActiveLayer();
                this.map.showURL("http://www.timemap.net/clearinghouse/html/search_results_detail.php?datasetid=" + lyr.datasetId);
            } else if (sName.equalsIgnoreCase(BTN_ANIME)) {
                AnimationFrame.showFrame();
            } else if (sName.equalsIgnoreCase("btn_selrect")) {
                this.map.setTool((byte)8);
            } else if (sName.equalsIgnoreCase("btn_selpoint")) {
                this.map.setTool((byte)9);
            } else if (sName.equalsIgnoreCase("btn_searchlayer") && (tf = (TextField)this.host.findComponent("txt_searchlayer")) != null) {
                this.map.searchAttribute(this.searchLayer, tf.getText(), 2);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Checkbox chb;
        Object o = e.getSource();
        if (o instanceof Checkbox && 0 == (chb = (Checkbox)o).getName().indexOf(CHB_LAYER_CONTROL_PREFIX)) {
            Layer layer = this.map.getProject().getLayerById(chb.getName().substring(CHB_LAYER_CONTROL_PREFIX.length()));
            layer.setVisible(chb.getState());
            this.map.updateMap();
        }
    }

    public void keyPressed(KeyEvent e) {
        Container cont;
        TextField tf;
        int key = e.getKeyCode();
        if (key == 10 && (tf = (TextField)MapUtils.findComp(cont = (Container)((Object)this.host), "txt_searchlayer")) != null) {
            this.map.searchAttribute(this.searchLayer, tf.getText(), 2);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.searchLayer = XmlUtils.getString("searchlayer", layout, null);
        this.magicURL = XmlUtils.getString("magicURL", layout, "invis.html");
        this.magicFrame = XmlUtils.getString("magicFrame", layout, "utilFrame");
        this.isUpdateWhenTimeChanges = XmlUtils.getBoolean("updatewhentimechanges", layout, false);
        this.isUpdateWhenExtentChanges = XmlUtils.getBoolean("updatewhenextentchanges", layout, false);
        this.map = host.getMapByName(layout);
        this.map.mapListeners.addElement(this);
        this.map.statusListeners.addElement(this);
        this.host = host;
    }

    public void stop() {
    }

    public void mouseMapPressed(MouseEvent e) {
    }

    public void mouseMapReleased(FloatRectangle selRect, MouseEvent e) {
        if (this.map.getTool() == 8) {
            this.host.showURL(this.magicURL + "?xmin=" + selRect.x + "&ymin=" + selRect.y + "&xmax=" + selRect.x2 + "&ymax=" + selRect.y2, this.magicFrame);
        } else if (this.map.getTool() == 9) {
            Point pt1 = e.getPoint();
            FloatPoint pt_0 = this.map.screenToMap(pt1);
            Layer lyr = this.map.getActiveLayer();
            if (lyr instanceof LayerVector) {
                RecordsArray recs = lyr.findWithinRect(selRect, true);
                String sUrl = this.magicURL + "?x=" + pt_0.x + "&y=" + pt_0.y + (MapUtils.isNotEmptyRecs(recs) ? "&sel=" + ((LayerVector)lyr).getId(recs.getRecord(0)) : "");
                this.host.showURL(sUrl, this.magicFrame);
            }
        }
    }

    public void mouseMapMoved(MouseEvent e) {
    }

    public void afterMapDraw(Graphics g) {
    }

    public void afterProjectLoaded(boolean bSuccess) {
        Container cont = (Container)((Object)this.host);
        Project project = this.map.getProject();
        int layerCount = project.getLayerCount();
        Layer layer = null;
        Checkbox chbLayerControl = null;
        for (int i = 0; i < layerCount; ++i) {
            layer = project.getLayerByIndex(i);
            chbLayerControl = (Checkbox)MapUtils.findComp(cont, CHB_LAYER_CONTROL_PREFIX + layer.id);
            if (null == chbLayerControl) continue;
            chbLayerControl.addItemListener(this);
            chbLayerControl.setState(layer.isVisible());
            if (!Strings.isNullOrBlank(chbLayerControl.getLabel())) continue;
            chbLayerControl.setLabel(layer.getName());
        }
        MapUtils.addActionListener(this, cont, "btn_copyright");
        if (bSuccess) {
            MapUtils.addActionListener(this, cont, "btn_selrect");
            MapUtils.addActionListener(this, cont, "btn_selpoint");
            MapUtils.addActionListener(this, cont, "btn_searchlayer");
            if (this.map.getProject().isTimeEnabled) {
                MapUtils.addActionListener(this, cont, BTN_ANIME);
            } else {
                Component comp = MapUtils.findComp(cont, BTN_ANIME);
                if (comp != null) {
                    comp.setVisible(false);
                }
            }
            this.lbl_search = (Label)MapUtils.findComp(cont, "srch_label");
            if (this.lbl_search != null) {
                this.lbl_search.setAlignment(2);
            }
            this.lbl_layername = (Label)MapUtils.findComp(cont, "layername_label");
            this.lbl_fieldname = (Label)MapUtils.findComp(cont, "fieldname_label");
            TextField tf = (TextField)MapUtils.findComp(cont, "txt_searchlayer");
            if (tf != null) {
                tf.addKeyListener(this);
            }
        }
    }

    public void notifyStatus(int code, Object obj) {
        if (code == 107 || code == 11 && obj == null) {
            Layer lyr = this.map.getActiveLayer();
            if (lyr != null) {
                String link;
                String string = link = lyr.linkSearch != null ? lyr.linkSearch : this.map.getProject().linkSearch;
                if (this.lbl_search != null) {
                    this.lbl_search.setText(lyr.getName() + "  " + (!lyr.canSearch || lyr.fi_description < 0 && Strings.isNullOrBlank(link) ? "Not searchable" : (lyr.fi_description >= 0 ? lyr.getFieldDef((int)lyr.fi_description).name : "")));
                }
                if (this.lbl_layername != null) {
                    this.lbl_layername.setText(lyr.getName());
                }
                if (this.lbl_fieldname != null) {
                    if (lyr.fi_description >= 0) {
                        this.lbl_fieldname.setText(lyr.getFieldDef((int)lyr.fi_description).name);
                    } else {
                        this.lbl_fieldname.setText("");
                    }
                }
            } else {
                if (this.lbl_search != null) {
                    this.lbl_search.setText("");
                }
                if (this.lbl_layername != null) {
                    this.lbl_layername.setText("");
                }
                if (this.lbl_fieldname != null) {
                    this.lbl_fieldname.setText("");
                }
            }
        } else if (code == 108 && this.isUpdateWhenTimeChanges) {
            TimeInterval tin = (TimeInterval)obj;
            this.host.showURL(this.magicURL + "?tmin=" + tin.date1().toString() + "&tmax=" + tin.date2().toString(), this.magicFrame);
        } else if (code == 109 && this.isUpdateWhenExtentChanges) {
            FloatRectangle selRect = this.map.getExtent();
            this.host.showURL(this.magicURL + "?xmin=" + selRect.x + "&ymin=" + selRect.y + "&xmax=" + selRect.x2 + "&ymax=" + selRect.y2, this.magicFrame);
        }
    }
}

