/*
 * Decompiled with CFR 0.152.
 */
package org.alov.serv.wfs;

import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.alov.ogcfilter.ComparisonOperation;
import org.alov.ogcfilter.Expression;
import org.alov.ogcfilter.Filter;
import org.alov.ogcfilter.LogicalOperation;
import org.alov.ogcfilter.OgcOperation;
import org.alov.serv.wfs.Brackets;
import org.alov.serv.wfs.ConstValue;
import org.alov.serv.wfs.FieldRef;
import org.alov.serv.wfs.Operation;
import org.alov.serv.wfs.ParsedExpression;

public class SQLParser {
    private SQLParser() {
    }

    static ParsedExpression parse(String s) throws IOException {
        ParsedExpression expr = SQLParser.parse(s, null);
        return expr;
    }

    private static OgcOperation getOperation(Object obj1, Operation o, Object obj2) {
        OgcOperation op;
        switch (o.op) {
            case 5: {
                op = new LogicalOperation(100);
                break;
            }
            case 4: {
                op = new LogicalOperation(101);
                break;
            }
            case 10: {
                op = new ComparisonOperation(200);
                break;
            }
            case 9: {
                op = new ComparisonOperation(205);
                break;
            }
            case 7: {
                op = new ComparisonOperation(203);
                break;
            }
            case 8: {
                op = new ComparisonOperation(204);
                break;
            }
            case 6: {
                op = new ComparisonOperation(202);
                break;
            }
            case 12: {
                op = new ComparisonOperation(206);
                break;
            }
            case 11: {
                op = new ComparisonOperation(201);
                break;
            }
            default: {
                return null;
            }
        }
        if (op instanceof LogicalOperation) {
            OgcOperation op1 = SQLParser.getOperation(obj1);
            OgcOperation op2 = SQLParser.getOperation(obj2);
            if (op1 != null && op2 != null) {
                op.operations.add(op1);
                op.operations.add(op2);
                return op;
            }
            return null;
        }
        if (op instanceof ComparisonOperation) {
            Expression ex1 = SQLParser.getExpression(obj1);
            Expression ex2 = SQLParser.getExpression(obj2);
            if (ex1 != null && ex2 != null) {
                ((ComparisonOperation)op).firstExpression = ex1;
                ((ComparisonOperation)op).secondExpression = ex2;
                return op;
            }
        }
        return null;
    }

    private static Expression getExpression(Object obj) {
        List expr;
        int first;
        if (obj instanceof Brackets) {
            obj = ((Brackets)obj).getValue();
        }
        if (obj instanceof List && ((List)obj).size() == 1 && ((List)obj).get(0) instanceof Brackets) {
            obj = ((Brackets)((List)obj).get(0)).getValue();
        }
        if ((first = SQLParser.findLowerOperation(expr = (List)obj)) > 0) {
            Expression result;
            Operation op = (Operation)expr.get(first);
            switch (op.op) {
                case 0: {
                    result = new Expression(1);
                    break;
                }
                case 1: {
                    result = new Expression(2);
                    break;
                }
                case 2: {
                    result = new Expression(3);
                    break;
                }
                case 3: {
                    result = new Expression(4);
                    break;
                }
                default: {
                    return null;
                }
            }
            result.expressions.add(SQLParser.getExpression(new Vector(expr.subList(0, first))));
            result.expressions.add(SQLParser.getExpression(new Vector(expr.subList(first + 1, expr.size()))));
            return result;
        }
        if (expr.size() == 1) {
            Object o = expr.get(0);
            if (o instanceof FieldRef) {
                Expression result = new Expression(5);
                result.propertyName = ((FieldRef)o).fieldName;
                return result;
            }
            if (o instanceof ConstValue) {
                Expression result = new Expression(6);
                result.literal = ((ConstValue)o).getValue().toString();
                return result;
            }
        }
        return null;
    }

    private static int findLowerOperation(List expr) {
        int c = -1;
        int prior = 100;
        for (int i = 0; i < expr.size(); ++i) {
            Object obj = expr.get(i);
            if (!(obj instanceof Operation) || Operation.PRIORITIES[((Operation)obj).op] >= prior) continue;
            prior = Operation.PRIORITIES[((Operation)obj).op];
            c = i;
        }
        return c;
    }

    private static OgcOperation getOperation(Object obj) {
        if (obj instanceof Brackets) {
            obj = ((Brackets)obj).getValue();
        }
        if (obj instanceof List && ((List)obj).size() == 1 && ((List)obj).get(0) instanceof Brackets) {
            obj = ((Brackets)((List)obj).get(0)).getValue();
        }
        List expr = (List)obj;
        int first = SQLParser.findLowerOperation(expr);
        OgcOperation resultOperation = null;
        if (first >= 0) {
            resultOperation = SQLParser.getOperation(new Vector(expr.subList(0, first)), (Operation)expr.get(first), new Vector(expr.subList(first + 1, expr.size())));
        }
        return resultOperation;
    }

    static Filter getFilter(ParsedExpression expr) {
        Filter result = new Filter();
        result.operation = SQLParser.getOperation(expr.expr);
        return result;
    }

    static Filter getFilter(String expression) throws IOException {
        return SQLParser.getFilter(SQLParser.parse(expression));
    }

    private static ParsedExpression parse(String s, Map refs) throws IOException {
        if (refs == null) {
            refs = new Hashtable<String, FieldRef>();
        }
        Vector<Object> resultList = new Vector<Object>();
        StringReader reader = new StringReader(s);
        boolean stop = false;
        boolean dontReadChar = false;
        int intChar = 0;
        while (!stop) {
            char ch;
            if (!dontReadChar) {
                intChar = reader.read();
            } else {
                dontReadChar = false;
            }
            if (intChar < 0) {
                stop = true;
                ch = ' ';
            } else {
                ch = (char)intChar;
            }
            if (ch == '+' || ch == '-' || ch == '/' || ch == '*') {
                int opcode = 0;
                switch (ch) {
                    case '+': {
                        opcode = 0;
                        break;
                    }
                    case '-': {
                        opcode = 1;
                        break;
                    }
                    case '/': {
                        opcode = 3;
                        break;
                    }
                    case '*': {
                        opcode = 2;
                        break;
                    }
                }
                Operation operation = new Operation(opcode);
                resultList.add(operation);
                continue;
            }
            if (ch == '=') {
                Operation op = new Operation(10);
                resultList.add(op);
                continue;
            }
            if (ch == '<') {
                int opcode = 6;
                intChar = reader.read();
                if (intChar >= 0) {
                    ch = (char)intChar;
                    if (ch == '=') {
                        opcode = 8;
                    } else if (ch == '>') {
                        opcode = 11;
                    } else {
                        dontReadChar = true;
                    }
                } else {
                    dontReadChar = true;
                }
                Operation operation = new Operation(opcode);
                resultList.add(operation);
                continue;
            }
            if (ch == '>') {
                int opcode = 7;
                intChar = reader.read();
                if (intChar >= 0) {
                    ch = (char)intChar;
                    if (ch == '=') {
                        opcode = 9;
                    } else {
                        dontReadChar = true;
                    }
                } else {
                    dontReadChar = true;
                }
                Operation operation = new Operation(opcode);
                resultList.add(operation);
                continue;
            }
            if (Character.isLetter(ch)) {
                Operation op;
                String name;
                dontReadChar = true;
                StringBuffer buf = new StringBuffer();
                while (Character.isLetter(ch) || Character.isDigit(ch) || ch == '_') {
                    buf.append(ch);
                    intChar = reader.read();
                    if (intChar < 0) break;
                    ch = (char)intChar;
                }
                if ("or".equalsIgnoreCase(name = buf.toString())) {
                    op = new Operation(4);
                    resultList.add(op);
                    continue;
                }
                if ("and".equalsIgnoreCase(name)) {
                    op = new Operation(5);
                    resultList.add(op);
                    continue;
                }
                if ("null".equalsIgnoreCase(name)) {
                    resultList.add(new ConstValue(null));
                    continue;
                }
                if ("like".equalsIgnoreCase(name)) {
                    op = new Operation(12);
                    resultList.add(op);
                    continue;
                }
                FieldRef ref = (FieldRef)refs.get(name);
                if (ref == null) {
                    ref = new FieldRef(buf.toString());
                    refs.put(name, ref);
                }
                resultList.add(ref);
                continue;
            }
            if (ch == '\'') {
                boolean backSlash = false;
                StringBuffer buf = new StringBuffer();
                while (true) {
                    if ((intChar = reader.read()) < 0) {
                        dontReadChar = true;
                        break;
                    }
                    ch = (char)intChar;
                    if (backSlash) {
                        buf.append(ch);
                        backSlash = false;
                        continue;
                    }
                    if (ch == '\'') break;
                    if (ch == '\\') {
                        backSlash = true;
                        continue;
                    }
                    buf.append(ch);
                }
                resultList.add(new ConstValue(buf.toString()));
                continue;
            }
            if (ch == '(') {
                int recursion = 1;
                StringBuffer buf = new StringBuffer();
                while (true) {
                    if ((intChar = reader.read()) < 0) {
                        dontReadChar = true;
                        break;
                    }
                    ch = (char)intChar;
                    if (ch == ')' && --recursion == 0) break;
                    buf.append(ch);
                    if (ch != 40) continue;
                    ++recursion;
                }
                ParsedExpression expr2 = SQLParser.parse(buf.toString(), refs);
                Brackets brackets = new Brackets(expr2.expr);
                resultList.add(brackets);
                continue;
            }
            if (!Character.isDigit(ch)) continue;
            dontReadChar = true;
            StringBuffer buf = new StringBuffer();
            buf.append(ch);
            boolean wasPoint = false;
            while ((intChar = reader.read()) >= 0 && (Character.isDigit(ch = (char)intChar) || ch == '.' && !wasPoint)) {
                buf.append(ch);
                if (ch != 46) continue;
                wasPoint = true;
            }
            if (wasPoint) {
                resultList.add(new ConstValue(Double.valueOf(buf.toString())));
                continue;
            }
            resultList.add(new ConstValue(Integer.valueOf(buf.toString())));
        }
        if (resultList.size() > 0) {
            Object o = resultList.get(0);
            if (o instanceof Operation) {
                Operation op = (Operation)o;
                if (op.op == 0 || op.op == 1) {
                    resultList.add(0, new ConstValue(new Double(0.0)));
                }
            }
            ParsedExpression expr = new ParsedExpression(SQLParser.preprocess(resultList), refs);
            return expr;
        }
        return null;
    }

    private static List preprocess(List expr) {
        int i;
        int count = expr.size();
        if (count <= 2) {
            return expr;
        }
        Vector<Object> result = new Vector<Object>();
        int written = -1;
        int priority = -1;
        boolean first = true;
        boolean searching = false;
        int firstValueIndex = -1;
        int lastValueIndex = -1;
        for (i = 0; i < count; ++i) {
            Object obj = expr.get(i);
            if (obj instanceof Operation) {
                Operation op = (Operation)obj;
                int opPriority = Operation.PRIORITIES[op.op];
                if (searching) {
                    if (opPriority > priority) continue;
                    List internalExpr = new Vector(lastValueIndex - firstValueIndex + 1);
                    for (int j = firstValueIndex; j <= lastValueIndex; ++j) {
                        internalExpr.add(expr.get(j));
                    }
                    internalExpr = SQLParser.preprocess(internalExpr);
                    Brackets brackets = new Brackets(internalExpr);
                    result.add(brackets);
                    result.add(op);
                    written = i;
                    searching = false;
                    continue;
                }
                if (first) {
                    priority = opPriority;
                    first = false;
                }
                if (opPriority > priority) {
                    searching = true;
                    continue;
                }
                for (int j = written + 1; j <= i; ++j) {
                    result.add(expr.get(j));
                }
                written = i;
                continue;
            }
            if (!searching) {
                firstValueIndex = i;
                continue;
            }
            lastValueIndex = i;
        }
        if (searching) {
            List internalExpr = new Vector(count - firstValueIndex);
            for (int i2 = firstValueIndex; i2 < count; ++i2) {
                internalExpr.add(expr.get(i2));
            }
            internalExpr = SQLParser.preprocess(internalExpr);
            Brackets brackets = new Brackets(internalExpr);
            result.add(brackets);
        } else {
            for (i = written + 1; i < count; ++i) {
                result.add(expr.get(i));
            }
        }
        return result;
    }
}

