/*
 * Decompiled with CFR 0.152.
 */
package org.alov.serv.wfs;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.data.DataProvider;
import org.alov.data.Gml;
import org.alov.map.FieldDef;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.ogcfilter.ComparisonOperation;
import org.alov.ogcfilter.Expression;
import org.alov.ogcfilter.Filter;
import org.alov.ogcfilter.OgcOperation;
import org.alov.ogcfilter.SpatialOperation;
import org.alov.serv.OGC_WFS;
import org.alov.serv.UOCache;
import org.alov.serv.UserInfo;
import org.alov.serv.Utils;
import org.alov.serv.Writers;
import org.alov.serv.wfs.SQLParser;
import org.alov.serv.wfs.WfsQuery;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class DataProviderWFS
extends DataProvider {
    private int recordSent = 0;

    public DataProviderWFS(Layer layer) {
        super(layer);
    }

    public String loadComplete() throws AlovMapException {
        String sWarnings = "";
        try {
            String dsId = ((LayerVector)this.layer).tableName;
            URL url = new URL(this.layer.connectionData.getProperty("url") + "?request=DescribeFeatureType&version=1.0.0&typeName=" + dsId);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setRequestMethod("GET");
            InputStream in = con.getInputStream();
            BufferedInputStream bin = new BufferedInputStream(in, 4096);
            XmlElement root = XmlUtils.parseStream(bin, "");
            bin.close();
            in.close();
            Vector<FieldDef> fields = new Vector<FieldDef>();
            String fieldsVisible = this.layer.metadata.getVal(307);
            if (!root.getNodeName().equalsIgnoreCase("schema")) {
                throw new Exception("Invalid WFS output format. XMLSchema required");
            }
            Vector v = root.getElementsByTagName("element");
            String s = "";
            for (int i = 0; i < v.size(); ++i) {
                XmlElement el = (XmlElement)v.elementAt(i);
                s = XmlUtils.getString("name", el, "");
                if (!s.equalsIgnoreCase(dsId)) continue;
                s = DataProviderWFS.withoutNamespace(XmlUtils.getString("type", el, ""));
                break;
            }
            Vector cls = root.getElementsByTagName("complexType");
            XmlElement type = null;
            for (int y = 0; y < cls.size(); ++y) {
                XmlElement el = (XmlElement)cls.elementAt(y);
                String n = XmlUtils.getString("name", el, "");
                if (!n.equalsIgnoreCase(s)) continue;
                type = el;
                if (n.equals(s)) break;
            }
            if (type == null) {
                throw new Exception("Element type " + s + " not found.");
            }
            XmlElement el = type.getFirstElementByName("complexContent");
            if (el == null) {
                throw new Exception("extension element missing.");
            }
            el = el.getFirstElementByName("extension");
            if (el == null) {
                throw new Exception("sequence element missing.");
            }
            el = el.getFirstElementByName("sequence");
            v = el.getElementsByTagName("element");
            for (int i = 0; i < v.size(); ++i) {
                String sType;
                XmlElement el2 = (XmlElement)v.elementAt(i);
                String sName = XmlUtils.getString("name", el2, "");
                if (sName.equalsIgnoreCase(((LayerVector)this.layer).f_geoblob) || !Strings.isNullOrBlank(sType = XmlUtils.getString("type", el2, "")) || (el2 = el2.getFirstElementByName("simpleType")) == null || (el2 = el2.getFirstElementByName("restriction")) == null) continue;
                String sBase = XmlUtils.getString("base", el2, "");
                int t = 12;
                if (sBase.equalsIgnoreCase("integer")) {
                    t = 4;
                } else if (sBase.equalsIgnoreCase("float")) {
                    t = 6;
                }
                FieldDef def = new FieldDef();
                def.name = sName;
                def.type = t;
                def.index = fields.size();
                fields.add(def);
            }
            int fieldCount = fields.size();
            this.layer.dataStorage.initFields(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                FieldDef def = (FieldDef)fields.elementAt(i);
                def.visible = Strings.isNullOrBlank(fieldsVisible) || fieldsVisible.indexOf(def.name.toUpperCase() + ',') >= 0;
                this.layer.setFieldDef(i, def);
                if (!def.name.equalsIgnoreCase(((LayerVector)this.layer).f_description)) continue;
                this.layer.fi_description = def.index;
            }
            if (fieldCount == 0) {
                throw new AlovMapException(303, dsId + ": None field to download. Not found in table " + ((LayerVector)this.layer).tableName);
            }
        }
        catch (Exception e) {
            sWarnings = e.getMessage();
            e.printStackTrace();
        }
        return sWarnings;
    }

    private static String withoutNamespace(String s) {
        int i = s.indexOf(58);
        return i > 0 ? s.substring(i + 1) : s;
    }

    public void writeGeoStream(Object objUser, FloatRectangle rect, String sParams, DataOutputStream oss) throws AlovMapException {
        OgcOperation op;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(20480);
        DataOutputStream os = new DataOutputStream(bos);
        int recSent = 0;
        String lastId = "";
        String sQuery = Utils.getParam((String)sParams, (String)"q", null);
        String reqType = Utils.getParam((String)sParams, (String)"t", (String)"s");
        UserInfo user = (UserInfo)objUser;
        UOCache cache = user.cache;
        LayerVector lyr = (LayerVector)this.layer;
        Filter filter = null;
        if (sQuery != null) {
            if (reqType.equals("s")) {
                filter = new Filter();
                op = new ComparisonOperation(206);
                filter.operation = op;
                ((ComparisonOperation)op).wildCard = (char)37;
                ((ComparisonOperation)op).escapeChar = (char)42;
                ((ComparisonOperation)op).singleChar = (char)63;
                ((ComparisonOperation)op).firstExpression = new Expression(5);
                ((ComparisonOperation)op).secondExpression = new Expression(6);
                ((ComparisonOperation)op).firstExpression.propertyName = lyr.f_description;
                ((ComparisonOperation)op).secondExpression.literal = sQuery;
            } else if (reqType.equals("query")) {
                try {
                    filter = SQLParser.getFilter(SQLParser.parse(sQuery));
                }
                catch (IOException e) {
                    throw new AlovMapException(305, "Invalid query:" + sQuery);
                }
            } else {
                filter = new Filter();
                StringTokenizer tok = new StringTokenizer(sQuery, ",");
                while (tok.hasMoreTokens()) {
                    String id = tok.nextToken();
                    filter.featureIDs.add(id);
                }
            }
        } else if (rect != null) {
            filter = new Filter();
            op = new SpatialOperation(310, null);
            op.bbox = rect;
            op.propertyName = Strings.isNullOrBlank(lyr.f_geoblob) ? "GEOBLOB" : lyr.f_geoblob;
            filter.operation = op;
        }
        if (!(this.layer.isFullLoad || Strings.isNullOrBlank(sQuery) && (rect == null || rect.isZero()))) {
            try {
                WfsQuery wfsQuery = new WfsQuery();
                int fieldCount = this.layer.getFieldCount();
                for (int j = 0; j < fieldCount; ++j) {
                    wfsQuery.properties.add(this.layer.getFieldDef((int)j).name);
                }
                if (filter != null) {
                    wfsQuery.filter = filter;
                }
                wfsQuery.dsId = lyr.tableName;
                XmlElement gml = OGC_WFS.queryWFS((String)this.layer.connectionData.getProperty("url"), (WfsQuery)wfsQuery);
                Gml.parseGML(gml, lyr);
                this.layer.dataStorage.setObjectType(Gml.objectType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.layer.dataStorage.openDataStorage(true);
        try {
            int count = this.layer.dataStorage.size();
            int fieldCount = this.layer.getFieldCount();
            int shpType = this.layer.dataStorage.getObjectType();
            for (int i = 0; i < count; ++i) {
                Shape shp;
                Record rec = lyr.newRecord(i);
                this.layer.dataStorage.readRecCoords(rec, null);
                this.layer.dataStorage.readRecAttribute(rec);
                String sRecId = lyr.getId(rec);
                if (!rec.isNotSent || !cache.put(sRecId)) continue;
                lastId = sRecId;
                os.writeUTF(lastId);
                if (shpType == 1) {
                    shp = rec.getShape(0);
                    os.write(255);
                    os.writeFloat((float)shp.xCoords[0]);
                    os.writeFloat((float)shp.yCoords[0]);
                } else {
                    os.write(shpType - 1);
                    Writers.writeInt4((OutputStream)os, (int)0);
                    int len = rec.getShapeCount();
                    Writers.writeInt4((OutputStream)os, (int)len);
                    for (int j = 0; j < len; ++j) {
                        shp = rec.getShape(j);
                        int ptCount = shp.xCoords.length;
                        Writers.writeInt4((OutputStream)os, (int)ptCount);
                        for (int k = 0; k < ptCount; ++k) {
                            Writers.writeFloat((OutputStream)os, (float)((float)shp.xCoords[k]));
                            Writers.writeFloat((OutputStream)os, (float)((float)shp.yCoords[k]));
                        }
                    }
                }
                for (int j = 0; j < fieldCount; ++j) {
                    Object obj = rec.getField(j);
                    int t = this.layer.getFieldDef((int)j).type;
                    switch (t) {
                        case 4: {
                            obj = Integer.valueOf((String)obj);
                            break;
                        }
                        case 6: {
                            obj = Float.valueOf((String)obj);
                            break;
                        }
                    }
                    Writers.writeObject((DataOutputStream)os, (Object)obj, (int)t);
                }
                ++recSent;
                rec.isNotSent = false;
            }
            if (recSent > 0) {
                os.writeUTF(lastId);
                this.recordSent += recSent;
                os.write(0);
                byte[] bytes = bos.toByteArray();
                int sizePacket = bytes.length;
                Writers.writeInt4((OutputStream)oss, (int)0);
                Writers.writeInt4((OutputStream)oss, (int)(sizePacket + 4));
                Writers.writeInt4((OutputStream)oss, (int)recSent);
                oss.write(bytes, 0, sizePacket);
            } else {
                Writers.writeInt4((OutputStream)oss, (int)0);
                Writers.writeInt4((OutputStream)oss, (int)0);
            }
        }
        catch (IOException e) {
            throw new AlovMapException(209, "Dataset #" + this.layer.datasetId + "  " + this.layer.metadata.getStr(8) + ". " + "Can't write data to output stream.\n" + e.getMessage());
        }
        finally {
            this.layer.dataStorage.closeDataStorage();
        }
    }
}

