/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.projections.Operation;

public class UTM_ZGS_Operation
extends Operation {
    private double zoneWidth;
    private double lambdaI;
    protected double k0 = 0.0;
    protected double phi0 = 0.0;
    protected double M0 = 0.0;
    protected double FE = 0.0;
    protected double FN = 0.0;

    public boolean prepare() {
        if (null != this.properties) {
            String value = null;
            value = this.properties.getProperty("8805");
            if (null == value) {
                return false;
            }
            this.k0 = Double.valueOf(value);
            value = this.properties.getProperty("8801");
            if (null != value) {
                this.phi0 = this.toRadians(Double.valueOf(value));
            }
            this.M0 = this.a * ((1.0 - this.es / 4.0 - 3.0 * this.es * this.es / 64.0 - 5.0 * this.es * this.es * this.es / 256.0) * this.phi0 - (3.0 * this.es / 8.0 + 3.0 * this.es * this.es / 32.0 + 45.0 * this.es * this.es * this.es / 1024.0) * Math.sin(2.0 * this.phi0) + (15.0 * this.es * this.es / 256.0 + 45.0 * this.es * this.es * this.es / 1024.0) * Math.sin(4.0 * this.phi0) - 35.0 * this.es * this.es * this.es / 3072.0 * Math.sin(6.0 * this.phi0));
            value = this.properties.getProperty("8806");
            if (null != value) {
                this.FE = Double.valueOf(value);
            }
            if (null != (value = this.properties.getProperty("8807"))) {
                this.FN = Double.valueOf(value);
            }
            if (null == (value = this.properties.getProperty("8831"))) {
                return false;
            }
            this.zoneWidth = this.toRadians(Double.valueOf(value));
            value = this.properties.getProperty("8830");
            if (null == value) {
                return false;
            }
            this.lambdaI = this.toRadians(Double.valueOf(value));
            return true;
        }
        return false;
    }

    public FloatPoint transform(double x, double y) {
        double lambda = this.toRadians(0.0 > x ? x + 360.0 : x);
        long zone = Math.round((lambda + this.lambdaI + this.zoneWidth) / this.zoneWidth);
        double lambda0 = (double)zone * this.zoneWidth - (this.lambdaI + this.zoneWidth / 2.0);
        double phi = this.toRadians(y);
        double sinPhi = Math.sin(phi);
        double sin2Phi = Math.sin(2.0 * phi);
        double sin4Phi = Math.sin(4.0 * phi);
        double sin6Phi = Math.sin(6.0 * phi);
        double cosPhi = Math.cos(phi);
        double tanPhi = Math.tan(phi);
        double T = tanPhi * tanPhi;
        double C = this.es * cosPhi * cosPhi / (1.0 - this.es);
        double A = (lambda - lambda0) * cosPhi;
        double A2 = A * A;
        double nu = this.a / Math.sqrt(1.0 - this.es * sinPhi * sinPhi);
        double M = this.a * ((1.0 - this.es / 4.0 - 3.0 * this.es * this.es / 64.0 - 5.0 * this.es * this.es * this.es / 256.0) * phi - (3.0 * this.es / 8.0 + 3.0 * this.es * this.es / 32.0 + 45.0 * this.es * this.es * this.es / 1024.0) * sin2Phi + (15.0 * this.es * this.es / 256.0 + 45.0 * this.es * this.es * this.es / 1024.0) * sin4Phi - 35.0 * this.es * this.es * this.es / 3072.0 * sin6Phi);
        double easting = this.FE + this.k0 * nu * (A + (1.0 - T + C) * A * A2 / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * this.e1s) * A * A2 * A2 / 120.0);
        double northing = this.FN + this.k0 * (M - this.M0 + nu * tanPhi * ((1.0 + (5.0 - T + 9.0 * C + 4.0 * C * C + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * this.esp) * A2 / 30.0) * A2 / 12.0) * A2 / 2.0));
        return new FloatPoint(easting, northing);
    }

    public FloatPoint inverseTransform(double x, double y, long zone) {
        double easting = x;
        double northing = y;
        double lambda0 = (double)zone * this.zoneWidth - (this.lambdaI + this.zoneWidth / 2.0);
        double M1 = this.M0 + (northing - this.FN) / this.k0;
        double mu1 = M1 / (this.a * (1.0 - this.es / 4.0 - 3.0 * this.es * this.es / 64.0 - 5.0 * this.es * this.es * this.es / 256.0));
        double phi1 = mu1 + (3.0 * this.e1 / 2.0 - 27.0 * this.e1s * this.e1 / 32.0) * Math.sin(2.0 * mu1) + (21.0 * this.e1s / 16.0 - 55.0 * this.e1s * this.e1s / 32.0) * Math.sin(4.0 * mu1) + 151.0 * this.e1s * this.e1 / 96.0 * Math.sin(6.0 * mu1) + 1097.0 * this.e1s * this.e1s / 512.0 * Math.sin(8.0 * mu1);
        double sinPhi1 = Math.sin(phi1);
        double cosPhi1 = Math.cos(phi1);
        double tanPhi1 = sinPhi1 / cosPhi1;
        double nu1 = this.a / Math.sqrt(1.0 - this.es * sinPhi1 * sinPhi1);
        double rho1 = this.a * (1.0 - this.es) / Math.pow(1.0 - this.es * sinPhi1 * sinPhi1, 1.5);
        double T1 = tanPhi1 * tanPhi1;
        double C1 = this.esp * cosPhi1 * cosPhi1;
        double D = (easting - this.FE) / nu1 / this.k0;
        double phi = phi1 - nu1 * tanPhi1 / rho1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * this.esp) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * this.esp - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0);
        double lambda = lambda0 + (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * this.esp + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / cosPhi1;
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }

    public FloatPoint inverseTransform(double x, double y) {
        String value = this.properties.getProperty("ZONE");
        if (null == value) {
            return null;
        }
        long zone = Long.valueOf(value);
        return this.inverseTransform(x, y, zone);
    }
}

