/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.projections.Operation;

public class StereographicOperation
extends Operation {
    protected double lambda0 = 0.0;
    protected double phi0 = 0.0;
    protected double FE = 0.0;
    protected double FN = 0.0;
    protected double Stereo_Ra = 0.0;
    protected boolean Stereo_At_Pole = false;

    public boolean prepare() {
        String value = this.properties.getProperty("8802");
        if (null != value) {
            this.lambda0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8801"))) {
            this.phi0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8806"))) {
            this.FE = Double.valueOf(value);
        }
        if (null != (value = this.properties.getProperty("8807"))) {
            this.FN = Double.valueOf(value);
        }
        this.Stereo_Ra = this.a * (1.0 - this.es / 6.0 - 17.0 * this.es * this.es / 360.0 - 67.0 * this.es * this.es * this.es / 3024.0);
        this.Stereo_At_Pole = Math.abs(Math.abs(this.phi0) - 1.5707963267948966) < 1.0E-10;
        return true;
    }

    public FloatPoint transform(double x, double y) {
        double Northing;
        double Easting;
        double phi = this.toRadians(y);
        double lambda = this.toRadians(x);
        double num = 0.0;
        double Ra_k = 0.0;
        double dlam = lambda - this.lambda0;
        if (dlam > Math.PI) {
            dlam -= Math.PI * 2;
        } else if (dlam < -Math.PI) {
            dlam += Math.PI * 2;
        }
        double g = 1.0 + Math.sin(this.phi0) * Math.sin(phi) + Math.cos(this.phi0) * Math.cos(phi) * Math.cos(dlam);
        if (Math.abs(g) <= 1.0E-10) {
            return null;
        }
        if (this.Stereo_At_Pole) {
            if (Math.abs(Math.abs(phi) - 1.5707963267948966) < 1.0E-10) {
                Easting = this.FE;
                Northing = this.FN;
            } else if (this.phi0 > 0.0) {
                num = 2.0 * this.Stereo_Ra * Math.tan(0.7853981633974483 - phi / 2.0);
                Easting = this.FE + num * Math.sin(dlam);
                Northing = this.FN + -num * Math.cos(dlam);
            } else {
                num = 2.0 * this.Stereo_Ra * Math.tan(0.7853981633974483 + phi / 2.0);
                Easting = this.FE + num * Math.sin(dlam);
                Northing = this.FN + num * Math.cos(dlam);
            }
        } else {
            if (Math.abs(this.phi0) <= 1.0E-10) {
                double k = 2.0 / (1.0 + Math.cos(phi) * Math.cos(dlam));
                Ra_k = this.Stereo_Ra * k;
                Northing = this.FN + Ra_k * Math.sin(phi);
            } else {
                double k = 2.0 / g;
                Ra_k = this.Stereo_Ra * k;
                Northing = this.FN + Ra_k * (Math.cos(this.phi0) * Math.sin(phi) - Math.sin(this.phi0) * Math.cos(phi) * Math.cos(dlam));
            }
            Easting = this.FE + Ra_k * Math.cos(phi) * Math.sin(dlam);
        }
        return new FloatPoint(Easting, Northing);
    }

    public FloatPoint inverseTransform(double Easting, double Northing) {
        double lambda;
        double phi;
        double dx = Easting - this.FE;
        double dy = Northing - this.FN;
        double rho = Math.sqrt(dx * dx + dy * dy);
        if (Math.abs(rho) <= 1.0E-10) {
            phi = this.phi0;
            lambda = this.lambda0;
        } else {
            double c = 2.0 * Math.atan(rho / (2.0 * this.Stereo_Ra));
            double sin_c = Math.sin(c);
            double cos_c = Math.cos(c);
            double dy_sin_c = dy * sin_c;
            lambda = this.Stereo_At_Pole ? (this.phi0 > 0.0 ? this.lambda0 + Math.atan2(dx, -dy) : this.lambda0 + Math.atan2(dx, dy)) : this.lambda0 + Math.atan2(dx * sin_c, rho * Math.cos(this.phi0) * cos_c - dy_sin_c * Math.sin(this.phi0));
            phi = Math.asin(cos_c * Math.sin(this.phi0) + dy_sin_c * Math.cos(this.phi0) / rho);
        }
        if (Math.abs(phi) < 2.2E-8) {
            phi = 0.0;
        }
        if (phi > 1.5707963267948966) {
            phi = 1.5707963267948966;
        } else if (phi < -1.5707963267948966) {
            phi = -1.5707963267948966;
        }
        if (lambda > Math.PI) {
            lambda = lambda - Math.PI < 3.5E-6 ? Math.PI : (lambda -= Math.PI * 2);
        }
        if (lambda < -Math.PI) {
            lambda = Math.abs(lambda + Math.PI) < 3.5E-6 ? -Math.PI : (lambda += Math.PI * 2);
        }
        if (Math.abs(lambda) < 2.0E-7) {
            lambda = 0.0;
        }
        if (lambda > Math.PI) {
            lambda = Math.PI;
        } else if (lambda < -Math.PI) {
            lambda = -Math.PI;
        }
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }
}

