/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.alov.projections.AlbersEqualAreaConicOperation;
import org.alov.projections.AzimuthalEquidistantOperation;
import org.alov.projections.AzimuthalOrthographicOperation;
import org.alov.projections.CylindricalEqualAreaOperation;
import org.alov.projections.Eckert6Operation;
import org.alov.projections.InvertOperation;
import org.alov.projections.LCC1SPOperation;
import org.alov.projections.LCC2SPOperation;
import org.alov.projections.MercatorOperation;
import org.alov.projections.MollweideOperation;
import org.alov.projections.Operation;
import org.alov.projections.PairOperation;
import org.alov.projections.StereographicOperation;
import org.alov.projections.UTMOperation;
import org.alov.projections.UTM_ZGS_Operation;
import org.alov.util.Log;
import org.alov.util.Strings;
import org.alov.util.XmlUtils;

public class OperationFactory {
    public static final byte DBMS_ACCESS = 1;
    public static final byte DBMS_MYSQL = 2;
    protected static byte serverDBMS = (byte)2;
    protected Connection connection = null;
    static final double EPS = 1.0E-5;
    static final int MAX_ITER_COUNT = 100000;
    public static final String ALOV_AZIMUTAL_ORTHOG = "AzimuthalOrthographic";
    public static final String ALOV_ALBERS_EQUAL_AREA_CONIC = "AlbersEqualAreaConic";
    public static final String ALOV_CYLINDRICAL_EQUAL_AREA = "CylindricalEqualArea";
    public static final String ALOV_AZIMUTHAL_EQUIDISTANT = "AzimuthalEquidistant";
    public static final String ALOV_ECKERT6 = "Eckert6";
    public static final String ALOV_STEREOGRAPHIC = "AzimuthalStereographic";
    public static final String ALOV_MOLLWEIDE = "Mollweide";
    public static final String ALOV_LAMBERT_CONFORMAL2SP = "LambertConformalConic2SP";
    public static final String ALOV_UTM = "UTM";
    public static final String ALOV_MERCATOR = "Mercator";
    public static final int EPSG_WGS84 = 4326;
    public static final int EPSG_LCC1SP = 9801;
    public static final int EPSG_LCC2SP = 9802;
    public static final int EPSG_UTM = 9807;
    public static final int EPSG_UTM_SO = 9808;
    public static final int EPSG_UTM_ZGS = 9824;
    public static final String EPSG = "EPSG";
    public static final String EPSG4326 = "EPSG:4326";
    public static final String PHI_0 = "8801";
    public static final String LAMBDA_0 = "8802";
    public static final String K_0 = "8805";
    public static final String FALSE_EASTING = "8806";
    public static final String FALSE_NORTHING = "8807";
    public static final String PHI_F = "8821";
    public static final String LAMBDA_F = "8822";
    public static final String PHI_1 = "8823";
    public static final String PHI_2 = "8824";
    public static final String FE_0 = "8826";
    public static final String FN_0 = "8827";
    public static final String LAMBDA_I = "8830";
    public static final String ZONE_WIDTH = "8831";
    private static final String COORD_OP_CODE_FIELD = "COORD_OP_CODE";
    private static final String COORD_OP_METHOD_CODE_FIELD = "COORD_OP_METHOD_CODE";
    private static final String DATUM_CODE_FIELD = "DATUM_CODE";
    private static final String ELLIPSOID_CODE_FIELD = "ELLIPSOID_CODE";
    private static final String PRIME_MERIDIAN_CODE_FIELD = "PRIME_MERIDIAN_CODE";
    private static final String PARAMETER_CODE_FIELD = "PARAMETER_CODE";
    private static final String PARAMETER_VALUE_FIELD = "PARAMETER_VALUE";
    public static final String SEMI_MAJOR_AXIS_FIELD = "SEMI_MAJOR_AXIS";
    public static final String SEMI_MINOR_AXIS_FIELD = "SEMI_MINOR_AXIS";
    public static final String INV_FLATTENING_FIELD = "INV_FLATTENING";
    public static final String GREENWICH_LONGITUDE_FIELD = "GREENWICH_LONGITUDE";
    public static final String ZONE = "ZONE";

    private static Operation makeEPSG(Connection connection, int EPSG_CRS) {
        Operation operation = null;
        try {
            String fromStr;
            if (connection == null) {
                Log.addMessage(226, null, null, "EPSG connection error");
                return null;
            }
            Statement statement = connection.createStatement();
            ResultSet rs = null;
            int operationCode = 0;
            boolean blOpCode = false;
            int datumCode = 0;
            boolean blDatumCode = false;
            String query = null;
            int crsCode = EPSG_CRS;
            do {
                switch (serverDBMS) {
                    case 1: {
                        fromStr = "from [Coordinate Reference System] ";
                        break;
                    }
                    default: {
                        fromStr = "from epsg_coordinatereferencesystem ";
                    }
                }
                query = "select DATUM_CODE, SOURCE_GEOGCRS_CODE, PROJECTION_CONV_CODE " + fromStr + "where ( COORD_REF_SYS_CODE = " + crsCode + " )";
                rs = statement.executeQuery(query);
                if (!rs.next()) {
                    Log.addMessage(118, null, null, "The Coordinate Reference System with code " + EPSG_CRS + " is not found. May be it not exist.");
                }
                if (!blDatumCode) {
                    datumCode = rs.getInt(DATUM_CODE_FIELD);
                    boolean bl = blDatumCode = !rs.wasNull();
                }
                if (!blOpCode) {
                    operationCode = rs.getInt("PROJECTION_CONV_CODE");
                    boolean bl = blOpCode = !rs.wasNull();
                }
                if (blDatumCode && blOpCode) continue;
                crsCode = rs.getInt("SOURCE_GEOGCRS_CODE");
                if (!rs.wasNull()) continue;
                rs.close();
                Log.addMessage(118, null, null, "The Coordinate Reference System with code " + crsCode + " that is base for specified code " + EPSG_CRS + " is not found. May be it not exist.");
            } while (!blDatumCode || !blOpCode);
            switch (serverDBMS) {
                case 1: {
                    fromStr = "from [Coordinate_Operation] ";
                    break;
                }
                default: {
                    fromStr = "from epsg_coordoperation ";
                }
            }
            query = "select COORD_OP_METHOD_CODE, AREA_OF_USE_CODE, COORD_OP_VARIANT " + fromStr + "where COORD_OP_CODE = " + operationCode;
            rs = statement.executeQuery(query);
            if (!rs.next()) {
                rs.close();
                return null;
            }
            int methodCode = rs.getInt(COORD_OP_METHOD_CODE_FIELD);
            int variantCode = rs.getInt("COORD_OP_VARIANT");
            int areaCode = rs.getInt("AREA_OF_USE_CODE");
            rs.close();
            switch (methodCode) {
                case 9801: {
                    operation = new LCC1SPOperation();
                    break;
                }
                case 9802: {
                    operation = new LCC2SPOperation();
                    break;
                }
                case 9807: 
                case 9808: {
                    operation = new UTMOperation();
                    break;
                }
                case 9824: {
                    operation = new UTM_ZGS_Operation();
                    break;
                }
                default: {
                    Log.addMessage(119, null, null, "The method of transformation with code " + methodCode + " from/to Coordinate Reference System #" + EPSG_CRS + " to/from WGS 84 is not implemented in this version.");
                }
            }
            if (operation != null) {
                String parameterValue;
                switch (serverDBMS) {
                    case 1: {
                        fromStr = "from [Coordinate_Operation Parameter Value] COPV, [Coordinate_Operation Parameter Usage] COPU ";
                        break;
                    }
                    default: {
                        fromStr = "from epsg_coordoperationparamvalue COPV, epsg_coordoperationparamusage COPU ";
                    }
                }
                query = "select COPV.PARAMETER_CODE, COPV.PARAMETER_VALUE, COPU.PARAM_SIGN_REVERSAL, COPV.UOM_CODE " + fromStr + "where ( COPV.COORD_OP_CODE = " + operationCode + " ) and " + "( COPV.COORD_OP_METHOD_CODE = " + methodCode + " ) and " + "( COPV.PARAMETER_CODE = COPU.PARAMETER_CODE ) and " + "( COPV.COORD_OP_METHOD_CODE = COPU.COORD_OP_METHOD_CODE )";
                if (statement.execute(query)) {
                    rs = statement.getResultSet();
                    rs.next();
                    do {
                        String parameterCode = rs.getString(PARAMETER_CODE_FIELD);
                        parameterValue = rs.getString(PARAMETER_VALUE_FIELD);
                        boolean inversal = rs.getString("PARAM_SIGN_REVERSAL").equalsIgnoreCase("yes");
                        ((Hashtable)operation.getProperties()).put(parameterCode, (inversal ? "-" : "") + parameterValue);
                    } while (rs.next());
                }
                switch (serverDBMS) {
                    case 1: {
                        fromStr = "from [Datum] as DTM, [Ellipsoid] as ELS, [Prime Meridian] as PM ";
                        break;
                    }
                    default: {
                        fromStr = "from epsg_datum as DTM, epsg_ellipsoid as ELS, epsg_primemeridian as PM ";
                    }
                }
                query = "select ELS.SEMI_MAJOR_AXIS, ELS.INV_FLATTENING, ELS.SEMI_MINOR_AXIS, ELS.UOM_CODE, PM.GREENWICH_LONGITUDE, PM.UOM_CODE " + fromStr + "where ( DTM.DATUM_CODE = " + datumCode + " ) and " + "( DTM.ELLIPSOID_CODE = ELS.ELLIPSOID_CODE ) and " + "( DTM.PRIME_MERIDIAN_CODE = PM.PRIME_MERIDIAN_CODE )";
                rs = statement.executeQuery(query);
                if (!rs.next()) {
                    System.out.println("ResultSet is empty");
                }
                double semi_major_axis = -1.0;
                double inv_flattening = -1.0;
                double semi_minor_axis = -1.0;
                semi_major_axis = rs.getDouble(1);
                if (rs.wasNull()) {
                    // empty if block
                }
                inv_flattening = rs.getDouble(2);
                if (rs.wasNull()) {
                    semi_minor_axis = rs.getDouble(3);
                    if (rs.wasNull()) {
                        // empty if block
                    }
                }
                operation.setEllipsoidParams(semi_major_axis, inv_flattening, semi_minor_axis);
                parameterValue = rs.getString(5);
                if (null != parameterValue) {
                    ((Hashtable)operation.getProperties()).put(GREENWICH_LONGITUDE_FIELD, parameterValue);
                }
                operation.prepare();
            }
            rs.close();
            statement.close();
        }
        catch (SQLException e) {
            Log.addMessage(226, null, null, e.getMessage());
        }
        return operation;
    }

    private Operation makeEPSG(String Target) {
        if (!Strings.isNullOrBlank(Target)) {
            String typeTarget = "";
            String codeTarget = "";
            int crs = 0;
            try {
                typeTarget = Target.substring(0, 4);
                codeTarget = Target.substring(Target.indexOf(":") + 1);
                crs = Integer.valueOf(codeTarget);
            }
            catch (Exception e) {
                Log.addMessage(228, null, null, "Invalid name of map projection: " + Target);
            }
            return OperationFactory.makeEPSG(this.connection, crs);
        }
        return null;
    }

    public Operation make(String source, String target) {
        Operation op1 = null;
        Operation op2 = null;
        String _EPSG = "name=EPSG:4326";
        if (Strings.isNullOrBlank(source)) {
            source = "name=EPSG:4326";
        }
        if (Strings.isNullOrBlank(target)) {
            target = "name=EPSG:4326";
        }
        Properties sourceProp = null;
        Properties targetProp = null;
        try {
            sourceProp = XmlUtils.makeProperties(source, ",");
            targetProp = XmlUtils.makeProperties(target, ",");
        }
        catch (Exception e) {
            Log.addMessage(227, null, null, "Invalid parameters for map projection");
            return null;
        }
        if (OperationFactory.equalsProp(sourceProp, targetProp)) {
            return null;
        }
        if (source.equalsIgnoreCase("name=EPSG:4326")) {
            return this.make(target);
        }
        if (target.equalsIgnoreCase("name=EPSG:4326")) {
            op1 = this.make(source);
            if (op1 != null && (op2 = new InvertOperation(op1)).prepare()) {
                return op2;
            }
        } else {
            op1 = this.make(source);
            op2 = this.make(target);
            if (op1 == null || op2 == null) {
                return null;
            }
            PairOperation op3 = new PairOperation(op1, op2);
            if (((Operation)op3).prepare()) {
                return op3;
            }
        }
        return null;
    }

    private static boolean equalsProp(Properties prop1, Properties prop2) {
        boolean res = true;
        Enumeration<?> names = prop1.propertyNames();
        if (((Hashtable)prop1).size() == ((Hashtable)prop2).size()) {
            while (names.hasMoreElements() && res) {
                String val2;
                String key = names.nextElement().toString();
                String val1 = prop1.getProperty(key);
                if (val1.equalsIgnoreCase(val2 = prop2.getProperty(key))) continue;
                res = false;
            }
        } else {
            res = false;
        }
        return res;
    }

    public Operation make(Properties prop) {
        try {
            if (prop == null) {
                return null;
            }
            Operation op = null;
            String val = prop.getProperty("name");
            if (val.equalsIgnoreCase(ALOV_AZIMUTAL_ORTHOG)) {
                op = new AzimuthalOrthographicOperation();
            } else if (val.equalsIgnoreCase(ALOV_ALBERS_EQUAL_AREA_CONIC)) {
                op = new AlbersEqualAreaConicOperation();
            } else if (val.equalsIgnoreCase(ALOV_AZIMUTHAL_EQUIDISTANT)) {
                op = new AzimuthalEquidistantOperation();
            } else if (val.equalsIgnoreCase(ALOV_CYLINDRICAL_EQUAL_AREA)) {
                op = new CylindricalEqualAreaOperation();
            } else if (val.equalsIgnoreCase(ALOV_ECKERT6)) {
                op = new Eckert6Operation();
            } else if (val.equalsIgnoreCase(ALOV_MOLLWEIDE)) {
                op = new MollweideOperation();
            } else if (val.equalsIgnoreCase(ALOV_STEREOGRAPHIC)) {
                op = new StereographicOperation();
            } else if (val.equalsIgnoreCase(ALOV_LAMBERT_CONFORMAL2SP)) {
                op = new LCC2SPOperation();
            } else if (val.equalsIgnoreCase(ALOV_UTM)) {
                op = new UTMOperation();
            } else if (val.equalsIgnoreCase(ALOV_MERCATOR)) {
                op = new MercatorOperation();
            } else {
                if (val.length() >= 4 && val.substring(0, 4).equalsIgnoreCase(EPSG)) {
                    return this.makeEPSG(val);
                }
                Log.addMessage(228, null, null, "Invalid name of map projection: " + val);
            }
            if (op != null) {
                val = prop.getProperty("a");
                String val2 = prop.getProperty("f");
                if (val == null || val2 == null) {
                    Log.addMessage(227, null, null, "Parameter 'a' or/and 'f' not found:a=" + val + ",f=" + val2);
                    return null;
                }
                op.setEllipsoidParams(Double.valueOf(val), Double.valueOf(val2), -1.0);
                val = prop.getProperty("phi0");
                if (val != null) {
                    ((Hashtable)op.getProperties()).put(PHI_0, val);
                }
                if ((val = prop.getProperty("lambda0")) != null) {
                    ((Hashtable)op.getProperties()).put(LAMBDA_0, val);
                }
                if ((val = prop.getProperty("phi1")) != null) {
                    ((Hashtable)op.getProperties()).put(PHI_1, val);
                }
                if ((val = prop.getProperty("phi2")) != null) {
                    ((Hashtable)op.getProperties()).put(PHI_2, val);
                }
                if ((val = prop.getProperty("fe")) != null) {
                    ((Hashtable)op.getProperties()).put(FALSE_EASTING, val);
                }
                if ((val = prop.getProperty("fn")) != null) {
                    ((Hashtable)op.getProperties()).put(FALSE_NORTHING, val);
                }
                if ((val = prop.getProperty("nf")) != null) {
                    ((Hashtable)op.getProperties()).put(FN_0, val);
                }
                if ((val = prop.getProperty("ef")) != null) {
                    ((Hashtable)op.getProperties()).put(FE_0, val);
                }
                if ((val = prop.getProperty("k0")) != null) {
                    ((Hashtable)op.getProperties()).put(K_0, val);
                }
                if ((val = prop.getProperty("lambda_f")) != null) {
                    ((Hashtable)op.getProperties()).put(LAMBDA_F, val);
                }
                if ((val = prop.getProperty("phi_f")) != null) {
                    ((Hashtable)op.getProperties()).put(PHI_F, val);
                }
                if (!op.prepare()) {
                    Log.addMessage(227, null, null, "Invalid set of parameters for map projection");
                    op = null;
                }
            }
            return op;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public Operation make(String parameters) {
        if (Strings.isNullOrBlank(parameters)) {
            return null;
        }
        Properties prop = null;
        try {
            prop = XmlUtils.makeProperties(parameters, ",");
        }
        catch (Exception e) {
            Log.addMessage(227, null, null, "Invalid parameters for map projection: " + parameters);
        }
        return this.make(prop);
    }
}

