/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.alov.map.DataStorage;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.Record;
import org.alov.map.Shape;

public abstract class Operation {
    protected Properties properties = new Properties();
    protected double a = 0.0;
    protected double e = 1.0;
    protected double es = 1.0;
    protected double e1 = 1.0;
    protected double e1s = 1.0;
    protected double esp = 1.0;

    public void setEllipsoidParams(double semi_major_axis, double inv_flattening, double semi_minor_axis) {
        this.a = semi_major_axis;
        if (inv_flattening > 0.0) {
            this.es = 2.0 / inv_flattening - 1.0 / inv_flattening / inv_flattening;
        } else if (semi_minor_axis > 0.0) {
            this.es = 1.0 - semi_minor_axis * semi_minor_axis / this.a / this.a;
        }
        this.e = Math.sqrt(this.es);
        this.esp = this.es / (1.0 - this.es);
        this.e1 = (1.0 - Math.sqrt(1.0 - this.es)) / (1.0 + Math.sqrt(1.0 - this.es));
        this.e1s = this.e1 * this.e1;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public abstract boolean prepare();

    double toRadians(double angdeg) {
        return angdeg * (Math.PI / 180);
    }

    double toDegrees(double angrad) {
        return angrad * 57.29577951308232;
    }

    public FloatPoint transform(FloatPoint sourceData) {
        return null != sourceData ? this.transform(sourceData.x, sourceData.y) : null;
    }

    public abstract FloatPoint transform(double var1, double var3);

    public FloatPoint inverseTransform(FloatPoint sourceData) {
        return null != sourceData ? this.inverseTransform(sourceData.x, sourceData.y) : null;
    }

    public abstract FloatPoint inverseTransform(double var1, double var3);

    public Vector transform(Vector sourceData, boolean inverse) {
        Vector<FloatPoint> result = null;
        if (null != sourceData) {
            int count = sourceData.size();
            result = new Vector<FloatPoint>();
            result.setSize(count);
            for (int i = 0; i < count; ++i) {
                result.add(!inverse ? this.transform((FloatPoint)sourceData.elementAt(i)) : this.inverseTransform((FloatPoint)sourceData.elementAt(i)));
            }
        }
        return result;
    }

    public void transform(double[] x, double[] y, boolean inverse) {
        int count = x.length;
        FloatPoint fp = new FloatPoint();
        FloatPoint fpTransform = null;
        for (int i = 0; i < count; ++i) {
            fpTransform = !inverse ? this.transform(x[i], y[i]) : this.inverseTransform(x[i], y[i]);
            x[i] = fp.x;
            y[i] = fp.y;
        }
    }

    public void transform(Record record, int figType, boolean inverse) {
        Shape shape;
        if (null == record) {
            return;
        }
        int shapesCount = record.getShapeCount();
        FloatPoint fp = null;
        int fillIndex = -1;
        int pntTotals = 0;
        boolean bNeedGenPoints = false;
        for (int i = 0; i < shapesCount; ++i) {
            shape = record.getShape(i);
            if (shape.xCoords == null && shape.yCoords == null) continue;
            int len = shape.xCoords.length;
            Vector<FloatPoint> visiblePoints = new Vector<FloatPoint>(len);
            for (int j = 0; j < len; ++j) {
                FloatPoint floatPoint = fp = !inverse ? this.transform(shape.xCoords[j], shape.yCoords[j]) : this.inverseTransform(shape.xCoords[j], shape.yCoords[j]);
                if (fp != null) {
                    if (bNeedGenPoints) {
                        bNeedGenPoints = false;
                    }
                    visiblePoints.add(fp);
                    continue;
                }
                if (visiblePoints.size() <= 0) continue;
                bNeedGenPoints = true;
            }
            if (shape.typeFill == 1) {
                visiblePoints.clear();
                fillIndex = i;
            } else {
                pntTotals += visiblePoints.size();
            }
            int size = visiblePoints.size();
            if (size > 0 && figType == 1 || size > 1 && figType == 2 || size > 2 && figType == 3 || size > 2 && figType == 4) {
                Enumeration enum1 = visiblePoints.elements();
                if (shape.xCoords.length != size) {
                    shape.xCoords = new double[size];
                    shape.yCoords = new double[size];
                }
                int j = 0;
                while (enum1.hasMoreElements()) {
                    fp = (FloatPoint)enum1.nextElement();
                    shape.xCoords[j] = fp.x;
                    shape.yCoords[j++] = fp.y;
                }
                continue;
            }
            shape.xCoords = null;
            shape.yCoords = null;
        }
        if (fillIndex >= 0 && (shape = Record.getDoughnutShape(record)) != null) {
            record.setShape(fillIndex, shape);
        }
        record.setRecordExtent(null);
        record.getRecordExtent();
    }

    public void transform2(LayerVector layer, Boolean inverse) {
        this.transform(layer, (boolean)inverse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Layer layer, boolean inverse) {
        if (null != layer) {
            DataStorage dsTemp = layer.dataStorage.copy();
            dsTemp.openDataStorage(false);
            try {
                int count = layer.dataStorage.size();
                byte figType = (byte)layer.dataStorage.getObjectType();
                double xmin = 0.0;
                double ymin = 0.0;
                double xmax = 0.0;
                double ymax = 0.0;
                if (count > 0) {
                    layer.dataStorage.openDataStorageSaveCoordinates();
                }
                for (int i = 0; i < count; ++i) {
                    Record rec = dsTemp.newRecord(i);
                    dsTemp.readRecCoords(rec, null);
                    this.transform(rec, figType, inverse);
                    layer.dataStorage.saveDataStorageRec(rec, false);
                    FloatRectangle extent = rec.getRecordExtent();
                    if (i == 0) {
                        xmin = Operation.removeInfinity(extent.x);
                        ymin = Operation.removeInfinity(extent.y);
                        xmax = Operation.removeInfinity(extent.x2);
                        ymax = Operation.removeInfinity(extent.y2);
                    } else {
                        if (!Operation.isInfinity(extent.x) && extent.x < xmin) {
                            xmin = extent.x;
                        }
                        if (!Operation.isInfinity(extent.x2) && extent.x2 > xmax) {
                            xmax = extent.x2;
                        }
                        if (!Operation.isInfinity(extent.y) && extent.y < ymin) {
                            ymin = extent.y;
                        }
                        if (!Operation.isInfinity(extent.y2) && extent.y2 > ymax) {
                            ymax = extent.y2;
                        }
                    }
                    rec = null;
                }
                FloatRectangle rect = new FloatRectangle(xmin, ymin, xmax, ymax);
                layer.setLayerExtent(rect);
                layer.metadata.maxExtent = rect;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                dsTemp.closeDataStorage();
                layer.dataStorage.closeDataStorageSave();
                dsTemp.clear();
                dsTemp = null;
            }
        }
    }

    private static double removeInfinity(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            d = Double.MAX_VALUE;
        } else if (d == Double.NEGATIVE_INFINITY) {
            d = Double.MIN_VALUE;
        }
        return d;
    }

    private static boolean isInfinity(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public FloatRectangle transform(FloatRectangle rect) {
        FloatPoint fp = null;
        FloatPoint fp2 = null;
        fp = this.transform(rect.x, rect.y);
        fp2 = this.transform(rect.x2, rect.y2);
        if (fp != null && fp2 != null) {
            return new FloatRectangle(fp.x, fp.y, fp2.x, fp2.y);
        }
        if (fp2 == null && fp == null) {
            return null;
        }
        double fStep = 0.2;
        if (fp != null) {
            for (double fAlfa = 1.0 - fStep; fAlfa >= 0.0; fAlfa -= fStep) {
                fp2 = this.transform(rect.x * (1.0 - fAlfa) + rect.x2 * fAlfa, rect.y * (1.0 - fAlfa) + rect.y2 * fAlfa);
                if (fp2 == null) continue;
                return new FloatRectangle(fp.x, fp.y, fp2.x, fp2.y);
            }
        } else {
            for (double fAlfa = fStep; fAlfa <= 1.0; fAlfa += fStep) {
                fp = this.transform(rect.x * (1.0 - fAlfa) + rect.x2 * fAlfa, rect.y * (1.0 - fAlfa) + rect.y2 * fAlfa);
                if (fp == null) continue;
                return new FloatRectangle(fp.x, fp.y, fp2.x, fp2.y);
            }
        }
        return null;
    }

    public FloatRectangle inverseTransform(FloatRectangle rect) {
        FloatPoint fp1 = this.inverseTransform(rect.x, rect.y);
        FloatPoint fp2 = this.inverseTransform(rect.x2, rect.y2);
        if (fp1 == null || fp2 == null) {
            return null;
        }
        return new FloatRectangle(fp1.x, fp1.y, fp2.x, fp2.y);
    }
}

