/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.projections.Operation;

public class MollweideOperation
extends Operation {
    protected double lambda0 = 0.0;
    protected double FE = 0.0;
    protected double FN = 0.0;
    protected double Sqrt2_Ra = 0.0;
    protected double Sqrt8_Ra = 0.0;

    public boolean prepare() {
        String value = this.properties.getProperty("8802");
        if (null != value) {
            this.lambda0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8806"))) {
            this.FE = Double.valueOf(value);
        }
        if (null != (value = this.properties.getProperty("8807"))) {
            this.FN = Double.valueOf(value);
        }
        double Ra = this.a * (1.0 - this.es / 6.0 - 17.0 * this.es * this.es / 360.0 - 67.0 * this.es * this.es * this.es / 3024.0);
        this.Sqrt2_Ra = Math.sqrt(2.0) * Ra;
        this.Sqrt8_Ra = Math.sqrt(8.0) * Ra;
        return true;
    }

    public FloatPoint transform(double x, double y) {
        double phi = this.toRadians(y);
        double lambda = this.toRadians(x);
        double PI_Sin_Latitude = Math.PI * Math.sin(phi);
        double theta_primed = phi;
        double delta_theta_primed = 0.1745329;
        double dtp_tolerance = 4.85E-10;
        double dlam = lambda - this.lambda0;
        if (dlam > Math.PI) {
            dlam -= Math.PI * 2;
        } else if (dlam < -Math.PI) {
            dlam += Math.PI * 2;
        }
        while (Math.abs(delta_theta_primed) > dtp_tolerance) {
            delta_theta_primed = -(theta_primed + Math.sin(theta_primed) - PI_Sin_Latitude) / (1.0 + Math.cos(theta_primed));
            theta_primed += delta_theta_primed;
        }
        double theta = theta_primed / 2.0;
        double Easting = this.Sqrt8_Ra / Math.PI * dlam * Math.cos(theta) + this.FE;
        double Northing = this.Sqrt2_Ra * Math.sin(theta) + this.FN;
        return new FloatPoint(Easting, Northing);
    }

    public FloatPoint inverseTransform(double Easting, double Northing) {
        double lambda;
        double phi;
        double theta = 0.0;
        double dy = Northing - this.FN;
        double dx = Easting - this.FE;
        double i = dy / this.Sqrt2_Ra;
        if (Math.abs(i) > 1.0) {
            phi = this.toRadians(90.0);
            if (Northing < 0.0) {
                phi *= -1.0;
            }
        } else {
            theta = Math.asin(i);
            double two_theta = 2.0 * theta;
            phi = Math.asin((two_theta + Math.sin(two_theta)) / Math.PI);
            if (phi > 1.5707963267948966) {
                phi = 1.5707963267948966;
            } else if (phi < -1.5707963267948966) {
                phi = -1.5707963267948966;
            }
        }
        if ((lambda = Math.abs(Math.abs(phi) - this.toRadians(90.0)) < 1.0E-10 ? this.lambda0 : this.lambda0 + Math.PI * dx / (this.Sqrt8_Ra * Math.cos(theta))) > Math.PI) {
            lambda = Math.PI;
        } else if (lambda < -Math.PI) {
            lambda = -Math.PI;
        }
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }
}

