/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.projections.Operation;

public class MercatorOperation
extends Operation {
    protected double lambda0 = 0.0;
    protected double phi0 = 0.0;
    protected double FE = 0.0;
    protected double FN = 0.0;
    protected double k0 = 1.0;
    protected static double MAX_LAT = 1.562069680534925;
    static double Merc_ab = 0.0;
    static double Merc_bb = 0.0;
    static double Merc_cb = 0.0;
    static double Merc_db = 0.0;
    static double Merc_Delta_Easting = 0.0;
    static double Merc_Delta_Northing = 0.0;

    public boolean prepare() {
        String value = this.properties.getProperty("8802");
        if (null != value) {
            this.lambda0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8801"))) {
            this.phi0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8806"))) {
            this.FE = Double.valueOf(value);
        }
        if (null != (value = this.properties.getProperty("8807"))) {
            this.FN = Double.valueOf(value);
        }
        if (this.a <= 0.0) {
            return false;
        }
        if (this.lambda0 > Math.PI) {
            this.lambda0 -= Math.PI * 2;
        }
        double sin_olat = Math.sin(this.phi0);
        this.k0 = 1.0 / (Math.sqrt(1.0 - this.es * sin_olat * sin_olat) / Math.cos(this.phi0));
        double es2 = this.es * this.es;
        double es3 = es2 * this.es;
        double es4 = es3 * this.es;
        Merc_ab = this.es / 2.0 + 5.0 * es2 / 24.0 + es3 / 12.0 + 13.0 * es4 / 360.0;
        Merc_bb = 7.0 * es2 / 48.0 + 29.0 * es3 / 240.0 + 811.0 * es4 / 11520.0;
        Merc_cb = 7.0 * es3 / 120.0 + 81.0 * es4 / 1120.0;
        Merc_db = 4279.0 * es4 / 161280.0;
        FloatPoint fp = this.transform(MAX_LAT, this.lambda0 + Math.PI);
        if (fp != null) {
            Merc_Delta_Easting = fp.x;
            Merc_Delta_Northing = fp.y;
        }
        if (Merc_Delta_Easting < 0.0) {
            Merc_Delta_Easting = -Merc_Delta_Easting;
        }
        Merc_Delta_Easting *= 1.01;
        Merc_Delta_Easting -= this.FE;
        Merc_Delta_Northing *= 1.01;
        Merc_Delta_Northing -= this.FN;
        return true;
    }

    public FloatPoint transform(double x, double y) {
        double phi = this.toRadians(y);
        double lambda = this.toRadians(x);
        if (phi < -MAX_LAT) {
            phi = -MAX_LAT;
        } else if (phi > MAX_LAT) {
            phi = MAX_LAT;
        }
        if (lambda < -Math.PI || lambda > Math.PI * 2) {
            return null;
        }
        if (lambda > Math.PI) {
            lambda -= Math.PI * 2;
        }
        double e_x_sinlat = this.e * Math.sin(phi);
        double tan_temp = Math.tan(0.7853981633974483 + phi / 2.0);
        double pow_temp = Math.pow((1.0 - e_x_sinlat) / (1.0 + e_x_sinlat), this.e / 2.0);
        double ctanz2 = tan_temp * pow_temp;
        double Northing = this.k0 * this.a * Math.log(ctanz2) + this.FN;
        double Delta_Long = lambda - this.lambda0;
        if (Delta_Long > Math.PI) {
            Delta_Long -= Math.PI * 2;
        }
        if (Delta_Long < -Math.PI) {
            Delta_Long += Math.PI * 2;
        }
        double Easting = this.k0 * this.a * Delta_Long + this.FE;
        return new FloatPoint(Easting, Northing);
    }

    public FloatPoint inverseTransform(double Easting, double Northing) {
        if (Easting < this.FE - Merc_Delta_Easting || Easting > this.FE + Merc_Delta_Easting) {
            return null;
        }
        if (Northing < this.FN - Merc_Delta_Northing || Northing > this.FN + Merc_Delta_Northing) {
            return null;
        }
        double dy = Northing - this.FN;
        double dx = Easting - this.FE;
        double lambda = this.lambda0 + dx / (this.k0 * this.a);
        double xphi = 1.5707963267948966 - 2.0 * Math.atan(1.0 / Math.exp(dy / (this.k0 * this.a)));
        double phi = xphi + Merc_ab * Math.sin(2.0 * xphi) + Merc_bb * Math.sin(4.0 * xphi) + Merc_cb * Math.sin(6.0 * xphi) + Merc_db * Math.sin(8.0 * xphi);
        if (lambda > Math.PI) {
            lambda -= Math.PI * 2;
        }
        if (lambda < -Math.PI) {
            lambda += Math.PI * 2;
        }
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }
}

