/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.map.MapUtils;
import org.alov.projections.Operation;

public class LCC2SPOperation
extends Operation {
    private double phiF;
    private double lambdaF;
    private double phi1;
    private double phi2;
    private double EF;
    private double NF;
    private double m1;
    private double m2;
    private double t1;
    private double t2;
    private double tF;
    private double n;
    private double F;
    private double rF;

    public FloatPoint transform(double x, double y) {
        double lambda = this.toRadians(x);
        double phi = this.toRadians(y);
        double t = this.calc_t(phi);
        double r = this.a * this.F * Math.pow(t, this.n);
        double teta = this.n * (lambda - this.lambdaF);
        FloatPoint fp = new FloatPoint(this.EF + r * Math.sin(teta), this.NF + this.rF - r * Math.cos(teta));
        if (fp.x != Double.NEGATIVE_INFINITY && fp.x != Double.POSITIVE_INFINITY && fp.y != Double.NEGATIVE_INFINITY && fp.y != Double.POSITIVE_INFINITY) {
            return fp;
        }
        return null;
    }

    private double calc_m(double angle) {
        return Math.cos(angle) / Math.sqrt(1.0 - this.es * MapUtils.sqr(Math.sin(angle)));
    }

    private double calc_t(double angle) {
        return Math.tan(0.7853981633974483 - angle / 2.0) / Math.pow((1.0 - this.e * Math.sin(angle)) / (1.0 + this.e * Math.sin(angle)), this.e / 2.0);
    }

    public boolean prepare() {
        String value = this.properties.getProperty("8826");
        if (null == value) {
            return false;
        }
        this.EF = Double.valueOf(value);
        value = this.properties.getProperty("8827");
        if (null == value) {
            return false;
        }
        this.NF = Double.valueOf(value);
        value = this.properties.getProperty("8822");
        if (null == value) {
            return false;
        }
        this.lambdaF = this.toRadians(Double.valueOf(value));
        value = this.properties.getProperty("8821");
        if (null == value) {
            return false;
        }
        this.phiF = this.toRadians(Double.valueOf(value));
        value = this.properties.getProperty("8823");
        if (null == value) {
            return false;
        }
        this.phi1 = this.toRadians(Double.valueOf(value));
        value = this.properties.getProperty("8824");
        if (null == value) {
            return false;
        }
        this.phi2 = this.toRadians(Double.valueOf(value));
        this.t1 = this.calc_t(this.phi1);
        this.t2 = this.calc_t(this.phi2);
        this.tF = this.calc_t(this.phiF);
        this.m1 = this.calc_m(this.phi1);
        this.m2 = this.calc_m(this.phi2);
        this.n = (Math.log(this.m1) - Math.log(this.m2)) / (Math.log(this.t1) - Math.log(this.t2));
        this.F = this.m1 / (this.n * Math.pow(this.t1, this.n));
        this.rF = this.a * this.F * Math.pow(this.tF, this.n);
        return true;
    }

    private double calc_phi(double lastPhi, double t_1) {
        return 1.5707963267948966 - 2.0 * Math.atan(t_1 * Math.pow((1.0 - this.e * Math.sin(lastPhi)) / (1.0 + this.e * Math.sin(lastPhi)), this.e / 2.0));
    }

    public FloatPoint inverseTransform(double x, double y) {
        double d;
        double d2;
        double easting = x;
        double northing = y;
        double teta1 = Math.atan((easting - this.EF) / (this.rF - (northing - this.NF)));
        double lambda = teta1 / this.n + this.lambdaF;
        double r1 = Math.sqrt(MapUtils.sqr(easting - this.EF) + MapUtils.sqr(this.rF - (northing - this.NF)));
        double t_1 = Math.pow(r1 / this.a / this.F, 1.0 / this.n);
        double phi = this.calc_phi(0.0, t_1);
        int counter = 0;
        do {
            d2 = phi;
            phi = this.calc_phi(phi, t_1);
        } while (1.0E-5 < Math.abs(d2 - d) && 100000 > counter++);
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }
}

