/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.map.MapUtils;
import org.alov.projections.Operation;

public class LCC1SPOperation
extends Operation {
    protected double lambda0 = 0.0;
    protected double phi0 = 0.0;
    protected double FE = 0.0;
    protected double FN = 0.0;
    private double k0;
    private double F;
    private double n;
    private double t0;
    private double r0;

    private double calc_m(double angle) {
        return Math.cos(angle) / Math.sqrt(1.0 - this.es * MapUtils.sqr(Math.sin(angle)));
    }

    private double calc_t(double angle) {
        return Math.tan(0.7853981633974483 - angle / 2.0) / Math.pow((1.0 - this.e * Math.sin(angle)) / (1.0 + this.e * Math.sin(angle)), this.e / 2.0);
    }

    private double calc_phi(double lastPhi, double t_1) {
        return 1.5707963267948966 - 2.0 * Math.atan(t_1 * Math.pow((1.0 - this.e * Math.sin(lastPhi)) / (1.0 + this.e * Math.sin(lastPhi)), this.e / 2.0));
    }

    public boolean prepare() {
        String value = this.properties.getProperty("8802");
        if (null != value) {
            this.lambda0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8801"))) {
            this.phi0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8806"))) {
            this.FE = Double.valueOf(value);
        }
        if (null != (value = this.properties.getProperty("8807"))) {
            this.FN = Double.valueOf(value);
        }
        if (null == (value = this.properties.getProperty("8805"))) {
            return false;
        }
        this.k0 = Double.valueOf(value);
        this.n = Math.sin(this.phi0);
        this.t0 = this.calc_t(this.phi0);
        double m0 = this.calc_m(this.phi0);
        this.F = m0 / (this.n * Math.pow(this.t0, this.n));
        this.r0 = this.a * this.F * this.k0 * Math.pow(this.t0, this.n);
        return true;
    }

    public FloatPoint transform(double x, double y) {
        double phi = this.toRadians(y);
        double lambda = this.toRadians(x);
        double teta = this.n * (lambda - this.lambda0);
        double t = this.calc_t(phi);
        double r = this.a * this.F * this.k0 * Math.pow(t, this.n);
        return new FloatPoint(this.FE + r * Math.sin(teta), this.FN + this.r0 - r * Math.cos(teta));
    }

    public FloatPoint inverseTransform(double x, double y) {
        double d;
        double d2;
        double easting = x;
        double northing = y;
        double teta1 = Math.atan((easting - this.FE) / (this.r0 - (northing - this.FN)));
        double lambda = teta1 / this.n + this.lambda0;
        double r1 = Math.sqrt(MapUtils.sqr(easting - this.FE) + MapUtils.sqr(this.r0 - (northing - this.FN)));
        double t_1 = Math.pow(r1 / this.a / this.k0 / this.F, 1.0 / this.n);
        double phi = this.calc_phi(0.0, t_1);
        int counter = 0;
        do {
            d2 = phi;
            phi = this.calc_phi(phi, t_1);
        } while (1.0E-5 < Math.abs(d2 - d) && 100000 > counter++);
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }
}

