/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.projections.Operation;

public class Eckert6Operation
extends Operation {
    protected double lambda0 = 0.0;
    protected double FE = 0.0;
    protected double FN = 0.0;
    protected double Ra_Over_Sqrt_Two_Plus_PI = 0.0;

    public boolean prepare() {
        String value = this.properties.getProperty("8802");
        if (null != value) {
            this.lambda0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8806"))) {
            this.FE = Double.valueOf(value);
        }
        if (null != (value = this.properties.getProperty("8807"))) {
            this.FN = Double.valueOf(value);
        }
        double Ra = this.a * (1.0 - this.es / 6.0 - 17.0 * this.es * this.es / 360.0 - 67.0 * this.es * this.es * this.es / 3024.0);
        this.Ra_Over_Sqrt_Two_Plus_PI = Ra / Math.sqrt(5.141592653589793);
        return true;
    }

    public FloatPoint transform(double x, double y) {
        double phi = this.toRadians(y);
        double lambda = this.toRadians(x);
        double theta = phi;
        double delta_theta = 1.0;
        double dt_tolerance = 4.85E-10;
        double dlam = lambda - this.lambda0;
        if (dlam > Math.PI) {
            dlam -= Math.PI * 2;
        }
        if (dlam < -Math.PI) {
            dlam += Math.PI * 2;
        }
        while (Math.abs(delta_theta) > dt_tolerance) {
            delta_theta = -(theta + Math.sin(theta) - 2.5707963267948966 * Math.sin(phi)) / (1.0 + Math.cos(theta));
            theta += delta_theta;
        }
        double Easting = this.Ra_Over_Sqrt_Two_Plus_PI * dlam * (1.0 + Math.cos(theta)) + this.FE;
        double Northing = 2.0 * this.Ra_Over_Sqrt_Two_Plus_PI * theta + this.FN;
        return new FloatPoint(Easting, Northing);
    }

    public FloatPoint inverseTransform(double Easting, double Northing) {
        double dy = Northing - this.FN;
        double dx = Easting - this.FE;
        double theta = 1.0 * dy / this.Ra_Over_Sqrt_Two_Plus_PI / 2.0;
        double i = (theta + Math.sin(theta)) / 2.5707963267948966;
        double phi = i > 1.0 ? this.toRadians(90.0) : (i < -1.0 ? -this.toRadians(90.0) : Math.asin(i));
        double lambda = this.lambda0 + 1.0 * dx / this.Ra_Over_Sqrt_Two_Plus_PI / (1.0 + Math.cos(theta));
        if (phi > 1.5707963267948966) {
            phi = 1.5707963267948966;
        } else if (phi < -1.5707963267948966) {
            phi = -1.5707963267948966;
        }
        if (lambda > Math.PI) {
            lambda = Math.PI;
        } else if (lambda < -Math.PI) {
            lambda = -Math.PI;
        }
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }
}

