/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.projections.Operation;

public class CylindricalEqualAreaOperation
extends Operation {
    protected double lambda0 = 0.0;
    protected double phi0 = 0.0;
    protected double FE = 0.0;
    protected double FN = 0.0;
    protected double k0 = 1.0;
    protected double c0 = 0.0;
    protected double c1 = 0.0;
    protected double c2 = 0.0;

    public boolean prepare() {
        String value = this.properties.getProperty("8802");
        if (null != value) {
            this.lambda0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8801"))) {
            this.phi0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8806"))) {
            this.FE = Double.valueOf(value);
        }
        if (null != (value = this.properties.getProperty("8807"))) {
            this.FN = Double.valueOf(value);
        }
        this.k0 = Math.cos(this.phi0) / Math.sqrt(1.0 - this.es * Math.sin(this.phi0) * Math.sin(this.phi0));
        this.c0 = this.es / 3.0 + 31.0 * this.es * this.es / 180.0 + 517.0 * this.es * this.es * this.es / 5040.0;
        this.c1 = 23.0 * this.es * this.es / 360.0 + 251.0 * this.es * this.es * this.es / 3780.0;
        this.c2 = 761.0 * this.es * this.es * this.es / 45360.0;
        return true;
    }

    protected double calc_q(double slat, double x) {
        return (1.0 - this.es) * (slat / (1.0 - x * x) - 1.0 / (2.0 * this.e) * Math.log((1.0 - x) / (1.0 + x)));
    }

    public FloatPoint transform(double x, double y) {
        double phi = this.toRadians(y);
        double lambda = this.toRadians(x);
        double dlam = lambda - this.lambda0;
        if (dlam > Math.PI) {
            dlam -= Math.PI * 2;
        }
        if (dlam < -Math.PI) {
            dlam += Math.PI * 2;
        }
        double qq = this.calc_q(Math.sin(phi), this.es * Math.sin(phi));
        double Easting = this.a * this.k0 * dlam + this.FE;
        double Northing = this.a * qq / 2.0 * this.k0 + this.FN;
        return new FloatPoint(Easting, Northing);
    }

    public FloatPoint inverseTransform(double Easting, double Northing) {
        double sin_lat = Math.sin(1.5707963267948966);
        double dy = Northing - this.FN;
        double dx = Easting - this.FE;
        double x = this.es * sin_lat;
        double qp = this.calc_q(sin_lat, x);
        double i = 2.0 * this.k0 * dy / (this.a * qp);
        if (i > 1.0) {
            i = 1.0;
        } else if (i < -1.0) {
            i = -1.0;
        }
        double beta = Math.asin(i);
        double sin2beta = this.c0 * Math.sin(2.0 * beta);
        double sin4beta = this.c1 * Math.sin(4.0 * beta);
        double sin6beta = this.c2 * Math.sin(6.0 * beta);
        double phi = beta + sin2beta + sin4beta + sin6beta;
        double lambda = this.lambda0 + dx / this.a * this.k0;
        if (phi > 1.5707963267948966) {
            phi = 1.5707963267948966;
        } else if (phi < -1.5707963267948966) {
            phi = -1.5707963267948966;
        }
        if (lambda > Math.PI) {
            lambda = Math.PI;
        } else if (lambda < -Math.PI) {
            lambda = -Math.PI;
        }
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }
}

