/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.projections.Operation;

public class AzimuthalOrthographicOperation
extends Operation {
    private double R = 0.0;
    protected double lambda0 = 0.0;
    protected double phi0 = 0.0;
    protected double FE = 0.0;
    protected double FN = 0.0;

    public void setRadius(double r) {
        if (r > 0.0) {
            this.R = r;
        }
    }

    public void setLambda0(double l) {
        if (Math.abs(l) < 180.0) {
            this.lambda0 = this.toRadians(l);
        }
    }

    public void setPhi0(double phi) {
        if (Math.abs(phi) < 90.0) {
            this.phi0 = this.toRadians(phi);
        }
    }

    public boolean prepare() {
        String value = this.properties.getProperty("8802");
        if (null != value) {
            this.lambda0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8801"))) {
            this.phi0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8806"))) {
            this.FE = Double.valueOf(value);
        }
        if (null != (value = this.properties.getProperty("8807"))) {
            this.FN = Double.valueOf(value);
        }
        this.R = this.a * (1.0 - this.es / 6.0 - 17.0 * this.es * this.es / 360.0 - 67.0 * this.es * this.es * this.es / 3024.0);
        return this.R != 0.0;
    }

    public FloatPoint transform(double x, double y) {
        double phi = this.toRadians(y);
        double lambda = this.toRadians(x);
        double delta = lambda - this.lambda0;
        double cosphi_cosdelta = Math.cos(phi) * Math.cos(delta);
        double cos_c = Math.sin(this.phi0) * Math.sin(phi) + Math.cos(this.phi0) * cosphi_cosdelta;
        if (cos_c < 0.0) {
            return null;
        }
        if (delta > Math.PI) {
            delta -= Math.PI * 2;
        } else if (delta < -Math.PI) {
            delta += Math.PI * 2;
        }
        double Easting = this.R * Math.cos(phi) * Math.sin(delta) + this.FE;
        double Northing = this.R * (Math.cos(this.phi0) * Math.sin(phi) - Math.sin(this.phi0) * cosphi_cosdelta) + this.FN;
        return new FloatPoint(Easting, Northing);
    }

    public FloatPoint inverseTransform(double Easting, double Northing) {
        double lambda;
        double phi;
        if (Easting > this.FE + this.R || Easting < this.FE - this.R) {
            return null;
        }
        if (Northing > this.FN + this.R || Northing < this.FN - this.R) {
            return null;
        }
        double temp = Math.sqrt(Easting * Easting + Northing * Northing);
        if (temp > this.FE + this.R || temp > this.FN + this.R || temp < this.FE - this.R || temp < this.FN - this.R) {
            return null;
        }
        double dx = Easting - this.FE;
        double dy = Northing - this.FN;
        double atan_dx_over_dy = Math.atan(dx / dy);
        double rho = Math.sqrt(dx * dx + dy * dy);
        if (rho == 0.0) {
            phi = this.phi0;
            lambda = this.lambda0;
        } else {
            double rho_OVER_Ra = rho / this.R;
            if (rho_OVER_Ra > 1.0) {
                rho_OVER_Ra = 1.0;
            } else if (rho_OVER_Ra < -1.0) {
                rho_OVER_Ra = -1.0;
            }
            double cc = Math.asin(rho_OVER_Ra);
            double cos_cc = Math.cos(cc);
            double sin_cc = Math.sin(cc);
            phi = Math.asin(cos_cc * Math.sin(this.phi0) + dy * sin_cc * Math.cos(this.phi0) / rho);
            lambda = this.phi0 == this.toRadians(90.0) ? this.lambda0 - atan_dx_over_dy : (this.phi0 == -this.toRadians(90.0) ? this.lambda0 + atan_dx_over_dy : this.lambda0 + Math.atan(dx * sin_cc / (rho * Math.cos(this.phi0) * cos_cc - dy * Math.sin(this.phi0) * sin_cc)));
            if (phi > 1.5707963267948966) {
                phi = 1.5707963267948966;
            } else if (phi < -1.5707963267948966) {
                phi = -1.5707963267948966;
            }
            if (lambda > Math.PI) {
                lambda -= Math.PI * 2;
            }
            if (lambda < -Math.PI) {
                lambda += Math.PI * 2;
            }
            if (lambda > Math.PI) {
                lambda = Math.PI;
            } else if (lambda < -Math.PI) {
                lambda = -Math.PI;
            }
        }
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }
}

